/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.connectors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ximpleware.ParseException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.connectors.RepositoryBranchInformation;
import de.julielab.jcore.pipeline.builder.base.exceptions.GithubInformationException;
import de.julielab.jcore.pipeline.builder.base.main.GitHubRepository;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import de.julielab.xml.JulieXMLTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubConnector {
    private static Map<String, MetaDescription> componentMap = null;
    private static final Logger log = LoggerFactory.getLogger(GitHubConnector.class);

    private static URL getComponentMetaURL(String name, GitHubRepository repository) {
        try {
            URIBuilder builder = new URIBuilder();
            builder.setScheme("https");
            builder.setHost("raw.githubusercontent.com");
            builder.setPath(new StringJoiner("/").add("").add(repository.getGitHubName()).add(repository.getName()).add(repository.getVersion()).add(name).add("component.meta").toString());
            return builder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URL getGitHubBranchListApiRequestURL(String user, String repositoryName) {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("https");
        builder.setHost("api.github.com");
        builder.setPath(new StringJoiner("/").add("").add("repos").add(user).add(repositoryName).add("branches").toString());
        try {
            return builder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Could not build GitHub branch request URI with user {} and repository name {}", new Object[]{user, repositoryName, e});
            return null;
        }
    }

    public static List<RepositoryBranchInformation> getRepositoryBranches(GitHubRepository repository) {
        return GitHubConnector.getRepositoryBranches(repository.getGitHubName(), repository.getName());
    }

    public static List<RepositoryBranchInformation> getRepositoryBranches(String user, String repositoryName) {
        try {
            ObjectMapper om = new ObjectMapper();
            return Arrays.asList((RepositoryBranchInformation[])om.readValue(GitHubConnector.getGitHubBranchListApiRequestURL(user, repositoryName), RepositoryBranchInformation[].class));
        }
        catch (IOException e) {
            log.error("Exception while trying to read list of branches from {}", (Object)GitHubConnector.getGitHubBranchListApiRequestURL(user, repositoryName), (Object)e);
            return Collections.emptyList();
        }
    }

    private static URL getComponentPomURL(String user, String name, String module, String version) {
        try {
            URIBuilder builder = new URIBuilder();
            builder.setScheme("https");
            builder.setHost("raw.githubusercontent.com");
            builder.setPath(new StringJoiner("/").add("").add(user).add(module).add(version).add(name).add(PipelineBuilderConstants.Maven.POM).toString());
            return builder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Could not build GitHub component POM request for component name {}, repository {} and branch {}", new Object[]{name, module, version, e});
            return null;
        }
    }

    private static URL getRepoContentsURL(GitHubRepository repository) {
        try {
            URIBuilder builder = new URIBuilder();
            builder.setScheme("https");
            builder.setHost("api.github.com");
            builder.setPath(new StringJoiner("/").add("").add("repos").add(repository.getGitHubName()).add(repository.getName()).add("contents").toString());
            builder.addParameter("ref", repository.getVersion());
            String accessToken = System.getProperty("github.api.accesstoken");
            String username = System.getProperty("github.api.username");
            String passwd = System.getProperty("github.api.password");
            if (accessToken != null) {
                builder.addParameter("access_token", accessToken);
            } else if (username != null && passwd != null) {
                builder.setUserInfo(username, passwd);
            } else {
                log.warn("Neither a GitHub OAuth token nor username and password were given. Thus, your requests to GitHub for retrieving the JCoRe component list and their meta descriptions are limited. If this is an issue, provide your access token or your user name and password for GitHub via the github.api.accesstoken, github.api.username and github.api.password Java system properties.");
            }
            return builder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URLConnection connectWithHeader(URL url) throws IOException, GithubInformationException {
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", "JCoRe Pipeline Builder");
        try {
            Integer rateLimit = Integer.parseInt(connection.getHeaderField("X-RateLimit-Limit"));
            int rateLimitRemaining = Integer.parseInt(connection.getHeaderField("X-RateLimit-Remaining"));
            log.debug("GitHub API requests rate limit: {} of {} remaining", (Object)rateLimitRemaining, (Object)rateLimit);
            if (rateLimitRemaining == 0) {
                throw new GithubInformationException("Cannot request JCoRe component meta data from GitHub due to the request rate limit imposed by GitHub. Your current rate limit is " + rateLimit + " and no requests remain within the hour. Provide your access token or your user name and password for GitHub via the github.api.accesstoken, github.api.username and github.api.password Java system properties to raise your rate limit. For more information, see https://developer.github.com/v3/#rate-limiting");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return connection;
    }

    private static MetaDescription checkForExposable(String component, GitHubRepository repository) throws IOException, GithubInformationException {
        InputStream metaFile = GitHubConnector.getMetaFileStream(component, repository);
        if (metaFile != null) {
            MetaDescription metaDescription;
            ObjectMapper mapper = new ObjectMapper();
            try {
                metaDescription = (MetaDescription)mapper.readValue(metaFile, MetaDescription.class);
            }
            catch (JsonProcessingException e) {
                log.error("JSON reading exception for the meta descriptor of component {} in repository {}, version {}", new Object[]{component, repository.getName(), repository.getVersion()});
                throw e;
            }
            if (metaDescription.isExposable()) {
                return metaDescription;
            }
            log.info(String.format("'%s' has a meta file, but is skipped due to being not exposed to the builder.", component));
        }
        return null;
    }

    public static InputStream getMetaFileStream(String name, GitHubRepository repository) throws GithubInformationException {
        URL meta = GitHubConnector.getComponentMetaURL(name, repository);
        try {
            return meta.openStream();
        }
        catch (IOException e) {
            log.info(String.format("URL was not found: %s", meta.toString()));
            return null;
        }
        catch (NullPointerException e) {
            log.error(String.format("URL could not be built for component '%s' in module '%s' for version '%s'.", name, repository.getName(), repository.getVersion()), (Throwable)e);
            return null;
        }
    }

    public static InputStream getPomFileStream(String user, String name, String module, String version) throws GithubInformationException {
        URL meta = GitHubConnector.getComponentPomURL(user, name, module, version);
        try {
            return meta.openStream();
        }
        catch (IOException e) {
            log.info(String.format("URL was not found: %s", meta.toString()));
            return null;
        }
        catch (NullPointerException e) {
            log.error(String.format("URL could not be built for component '%s' in module '%s' for version '%s'.", name, module, version), (Throwable)e);
            return null;
        }
    }

    public static InputStream getGitHubContentStream(GitHubRepository repository) throws GithubInformationException {
        URL meta = GitHubConnector.getRepoContentsURL(repository);
        try {
            return GitHubConnector.connectWithHeader(meta).getInputStream();
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void listComponents(GitHubRepository repository, Boolean exposable) throws IOException, GithubInformationException {
        log.trace("Fetching JCoRe component list for module {}:{}. Only exposable parameters are fetched: {}", new Object[]{repository.getName(), repository.getVersion(), exposable});
        HashMap<String, MetaDescription> componentList = new HashMap<String, MetaDescription>();
        InputStream is = GitHubConnector.getGitHubContentStream(repository);
        JsonReader rdr = Json.createReader((InputStream)is);
        for (JsonObject result : rdr.readArray().getValuesAs(JsonObject.class)) {
            if (!result.getString("type").equals("dir")) continue;
            String component = result.getString("path");
            log.trace("Fetching meta description of component {}", (Object)component);
            MetaDescription metaFile = GitHubConnector.checkForExposable(component, repository);
            if (exposable.booleanValue() && metaFile == null) {
                log.trace("Component {} is skipped because only exposable components are loaded and the component does not have a meta description file.", (Object)component);
                continue;
            }
            try {
                component = JulieXMLTools.getXpathValue((String)"/project/artifactId", (InputStream)GitHubConnector.getPomFileStream(repository.getGitHubName(), component, repository.getName(), repository.getVersion()));
                log.trace("The parsed artifact ID for the component is {}", (Object)component);
            }
            catch (ParseException | XPathParseException e) {
                throw new IOException(e);
            }
            componentList.put(component, metaFile);
        }
        componentMap = componentList;
    }

    public static Map<String, MetaDescription> getComponents(GitHubRepository repository, Boolean exposable) throws IOException, GithubInformationException {
        GitHubConnector.listComponents(repository, exposable);
        return componentMap;
    }
}

