/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.exceptions.DescriptorLoadingException;
import de.julielab.jcore.pipeline.builder.base.exceptions.MetaDescriptionInteractionException;
import de.julielab.jcore.pipeline.builder.base.interfaces.IMetaDescription;
import de.julielab.jcore.pipeline.builder.base.main.ComponentRepository;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.jcore.pipeline.builder.base.main.JcoreGithubInformationService;
import de.julielab.jcore.pipeline.builder.base.utils.DescriptorUtils;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(converter=FromJsonSetup.class)
public class MetaDescription
implements IMetaDescription,
Serializable {
    private static final long serialVersionUID = 20180621001L;
    private static Logger logger = LoggerFactory.getLogger(MetaDescription.class);
    private String description;
    private Map<String, Description> descriptionMap = new HashMap<String, Description>();
    private String group;
    private ComponentRepository module;
    private String base;
    @JsonProperty(value="name")
    private String componentName;
    private boolean exposable;
    @JsonProperty(value="base-project")
    private String baseProject;
    @JsonProperty(value="maven-artifact")
    private MavenArtifact artifact;
    private List<PipelineBuilderConstants.JcoreMeta.Category> categories;
    private Integer chosenDescriptor;
    @JsonProperty(value="descriptors")
    private List<Description> descriptorList = new ArrayList<Description>();
    private Boolean isPear = false;
    @JsonIgnore
    private boolean artifactInitialized = false;

    public Boolean isPear() {
        return this.isPear;
    }

    public void setPear(Boolean pear) {
        this.isPear = pear;
    }

    public String getBaseProject() {
        return this.baseProject;
    }

    public void setBaseProject(String baseProject) {
        this.baseProject = baseProject;
    }

    public String getDescription() throws DescriptorLoadingException {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isExposable() {
        return this.exposable;
    }

    public void setExposable(boolean exposable) {
        this.exposable = exposable;
    }

    @Override
    @JsonIgnore
    public Description getChosenDescriptor() throws DescriptorLoadingException {
        this.getJCoReDescriptions();
        if (this.chosenDescriptor != null) {
            if (this.chosenDescriptor > this.descriptorList.size()) {
                this.chosenDescriptor = this.descriptorList.size() - 1;
            }
            return this.descriptorList.get(this.chosenDescriptor);
        }
        throw new IllegalStateException("No descriptor has been chosen.");
    }

    @Override
    public void setChosenDescriptor(String xmlName) throws DescriptorLoadingException {
        this.getJCoReDescriptions();
        if (!this.descriptionMap.containsKey(xmlName)) {
            throw new IllegalArgumentException("There is no descriptor with XML name " + xmlName);
        }
        this.chosenDescriptor = this.descriptorList.indexOf(this.descriptionMap.get(xmlName));
    }

    private void loadDescriptorsFromMavenArtifact() throws DescriptorLoadingException {
        if (!this.isPear.booleanValue()) {
            this.initMavenArtifact();
            try {
                for (Description description : this.descriptorList) {
                    ResourceSpecifier spec = DescriptorUtils.searchDescriptor(this.artifact.getFile(), description.getLocation());
                    description.setMetaDescription(this);
                    description.setDescriptor((MetaDataObject)spec);
                    this.descriptionMap.put(description.getLocation(), description);
                }
            }
            catch (IOException e) {
                throw new MetaDescriptionInteractionException(e);
            }
        }
        if (this.descriptionMap.size() >= 1) {
            this.setChosenDescriptorAsIndex(0);
        }
    }

    @Override
    @JsonIgnore
    public Integer getChosenDescriptorAsIndex() {
        return this.chosenDescriptor;
    }

    @Override
    public void setChosenDescriptorAsIndex(Integer descIndex) {
        this.chosenDescriptor = descIndex;
    }

    @Override
    @JsonIgnore
    public Description getJCoReDescription(String specifier) throws DescriptorLoadingException {
        this.getJCoReDescriptions();
        return this.descriptionMap.getOrDefault(specifier, null);
    }

    @Override
    @JsonIgnore
    public Collection<Description> getJCoReDescriptions() throws DescriptorLoadingException {
        if (this.descriptionMap.isEmpty()) {
            if (this.isPear.booleanValue()) {
                for (Description description : this.descriptorList) {
                    description.setMetaDescription(this);
                    this.descriptionMap.put(description.getLocation(), description);
                }
                if (this.descriptionMap.size() == 1) {
                    this.setChosenDescriptorAsIndex(0);
                }
            } else {
                this.loadDescriptorsFromMavenArtifact();
            }
        }
        return this.descriptionMap.values();
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    public void setName(String name) {
        this.componentName = name;
    }

    @Override
    public List<PipelineBuilderConstants.JcoreMeta.Category> getCategories() {
        return this.categories;
    }

    public String toString() {
        return "MetaDescription{group='" + this.group + '\'' + ", module='" + this.module + '\'' + ", componentName='" + this.componentName + '\'' + '}';
    }

    public void setArtifact(MavenArtifact artifact) {
        this.artifact = artifact;
    }

    @Override
    @JsonIgnore
    public MavenArtifact getMavenArtifact() {
        if (!this.isPear.booleanValue() && !this.artifactInitialized) {
            this.initMavenArtifact();
        }
        return this.artifact;
    }

    private void initMavenArtifact() {
        Supplier<String> metaJsonSupplier = () -> {
            ObjectMapper mapper = new ObjectMapper();
            String metaJson = "<could not serialize>";
            try {
                metaJson = mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            return metaJson;
        };
        try {
            List<MavenArtifact> mavenArtifacts = JcoreGithubInformationService.getInstance().downloadArtifacts(Collections.singletonList(this.artifact));
            MavenArtifact resolvedArtifact = mavenArtifacts.get(0);
            this.artifact.setFile(resolvedArtifact.getFile());
        }
        catch (MavenException e) {
            throw new MetaDescriptionInteractionException("Cannot initialize meta description because the Maven artifact could not be retrieved. The meta description is: " + metaJsonSupplier.get(), e);
        }
        this.setArtifact(this.artifact);
        this.artifactInitialized = true;
    }

    @JsonIgnore
    public ComponentRepository getModule() {
        return this.module;
    }

    public void setModule(ComponentRepository module) {
        this.module = module;
    }

    protected static final class FromJsonSetup
    extends StdConverter<MetaDescription, MetaDescription> {
        protected FromJsonSetup() {
        }

        public MetaDescription convert(MetaDescription value) {
            return value;
        }
    }
}

