/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.google.common.collect.Sets;
import de.julielab.java.utilities.FileUtilities;
import de.julielab.java.utilities.classpath.JarLoader;
import de.julielab.jcore.pipeline.builder.base.PipelineParameterChecker;
import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.builder.base.main.Description;
import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.impl.metadata.cpe.CpeCasProcessorsImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeComponentDescriptorImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeIntegratedCasProcessorImpl;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.fit.cpe.CpeBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JCoReUIMAPipeline {
    public static final String DIR_DESC = "desc";
    public static final String DIR_LIB = "lib";
    public static final String DIR_CONF = "config";
    public static final String CPE_AAE_DESC_NAME = "cpeAAE.xml";
    public static final String JAR_CONF_FILES = "jcore-pipeline-config.jar";
    private static final String SERIALIZED_CR_DESCS_FILE = "crDescriptions.bin";
    private static final String SERIALIZED_CM_DESCS_FILE = "cmDescriptions.bin";
    private static final String SERIALIZED_AE_DESCS_FILE = "aeDescriptions.bin";
    private static final String SERIALIZED_CC_DESCS_FILE = "ccDescriptions.bin";
    private static final Logger log = LoggerFactory.getLogger(JCoReUIMAPipeline.class);
    private static Function<List<Description>, Stream<Import>> tsImportsExtractor = descs -> descs.stream().flatMap(desc -> {
        AnalysisEngineMetaData analysisEngineMetaData = desc.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData();
        if (analysisEngineMetaData == null) {
            return null;
        }
        TypeSystemDescription typeSystem = analysisEngineMetaData.getTypeSystem();
        if (typeSystem == null) {
            return null;
        }
        return Stream.of(typeSystem.getImports());
    }).filter(Objects::nonNull);
    private Description crDescription;
    private List<Description> aeDelegates;
    private List<Description> cmDelegates;
    private List<Description> ccDelegates;
    private CollectionReaderDescription crDesc;
    private AnalysisEngineDescription aaeDesc;
    private AnalysisEngineDescription aaeCmDesc;
    private ResourceCreationSpecifier ccDesc;
    private File loadDirectory;
    private Set<String> filesToDeleteOnSave = new HashSet<String>();

    public JCoReUIMAPipeline(File baseDirectory) {
        this();
        this.setLoadDirectory(baseDirectory);
    }

    public JCoReUIMAPipeline() {
        this.cmDelegates = new ArrayList<Description>();
        this.aeDelegates = new ArrayList<Description>();
        this.ccDelegates = new ArrayList<Description>();
    }

    public Stream<Description> getMultipliers() {
        return this.aeDelegates.stream().filter(d -> ((AnalysisEngineDescription)d.getDescriptor()).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes());
    }

    public Stream<Description> getNonMultiplierAes() {
        return this.aeDelegates.stream().filter(d -> !((AnalysisEngineDescription)d.getDescriptor()).getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes());
    }

    public Description getCrDescription() {
        return this.crDescription;
    }

    public void setCrDescription(Description crDescription) {
        this.crDescription = crDescription;
        this.crDesc = crDescription.getDescriptorAsCollectionReaderDescription();
    }

    public AnalysisEngineDescription getAaeDesc() {
        return this.aaeDesc;
    }

    public List<Description> getCcDelegates() {
        return this.ccDelegates;
    }

    public void addCcDesc(Description ccDesc) {
        if (this.ccDelegates.stream().map(Description::getDescriptor).filter(CasConsumerDescription.class::isInstance).findAny().isPresent()) {
            throw new IllegalArgumentException("There is already a consumer represented by a  " + CasConsumerDescription.class.getCanonicalName() + ". Those are deprecated and only one can be used in each pipeline.");
        }
        this.ccDelegates.add(ccDesc);
    }

    public void store(File directory) throws PipelineIOException {
        this.store(directory, false);
    }

    /*
     * Unable to fully structure code
     */
    public void store(File directory, boolean clearLibDir) throws PipelineIOException {
        message = "";
        if (this.aaeDesc == null && (this.aeDelegates == null || this.aeDelegates.isEmpty()) && this.ccDesc == null && (this.ccDelegates == null || this.ccDelegates.isEmpty()) || this.crDescription == null) {
            message = "This pipeline has either no collection reader or no analysis engines and no consumer. A reader and an analysis engine or a consumer is required to do any work. The pipeline will be stored anyway but will need additional work.";
            JCoReUIMAPipeline.log.warn(message);
        }
        this.getClasspathElements().forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addJarToClassPath(java.io.File ), (Ljava/io/File;)V)());
        try {
            descDir = new File(directory.getAbsolutePath() + File.separator + "desc");
            if (!descDir.exists()) {
                descDir.mkdirs();
            } else {
                Stream.of(descDir.listFiles()).forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, delete(), (Ljava/io/File;)V)());
            }
            if (this.aeDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() > 0L) {
                descStream = this.aeDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$store$4(de.julielab.jcore.pipeline.builder.base.main.Description ), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).map((Function<Description, AnalysisEngineDescription>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDescriptorAsAnalysisEngineDescription(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Lorg/apache/uima/analysis_engine/AnalysisEngineDescription;)());
                this.aaeDesc = AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])descStream.toArray((IntFunction<AnalysisEngineDescription[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$store$5(int ), (I)[Lorg/apache/uima/analysis_engine/AnalysisEngineDescription;)()));
                delegatesWithImports = this.aaeDesc.getDelegateAnalysisEngineSpecifiersWithImports();
                delegatesWithImports.clear();
                flowNames = new ArrayList<String>();
                for (i = 0; i < this.aeDelegates.size(); ++i) {
                    description = this.aeDelegates.get(i);
                    if (!description.getMetaDescription().isPear().booleanValue() && description.isActive()) {
                        imp = new Import_impl();
                        imp.setLocation(description.getName() + ".xml");
                        delegatesWithImports.put(description.getName(), (MetaDataObject)imp);
                        destination = new File(descDir.getAbsolutePath() + File.separator + description.getName() + ".xml");
                        description.getDescriptorAsAnalysisEngineDescription().toXML(FileUtilities.getWriterToFile(destination), true);
                        flowNames.add(description.getName());
                        continue;
                    }
                    if (!description.isActive()) continue;
                    imp = new Import_impl();
                    pearDescriptorFile = new File(description.getLocation());
                    imp.setLocation(pearDescriptorFile.toURI().toString());
                    delegatesWithImports.put(description.getName(), (MetaDataObject)imp);
                    flowNames.add(description.getName());
                }
                this.aaeDesc.setSourceUrl(descDir.toURI().toURL());
                this.aaeDesc.getDelegateAnalysisEngineSpecifiers();
                ((FixedFlow)this.aaeDesc.getAnalysisEngineMetaData().getFlowConstraints()).setFixedFlow(flowNames.toArray(new String[flowNames.size()]));
            }
            if (this.cmDelegates != null && this.cmDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() > 1L) {
                descStream = this.cmDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).map((Function<Description, AnalysisEngineDescription>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDescriptorAsAnalysisEngineDescription(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Lorg/apache/uima/analysis_engine/AnalysisEngineDescription;)());
                this.aaeCmDesc = AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])descStream.toArray((IntFunction<AnalysisEngineDescription[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$store$6(int ), (I)[Lorg/apache/uima/analysis_engine/AnalysisEngineDescription;)()));
            }
            crFile = null;
            if (this.crDescription != null) {
                descriptorFilename = this.crDescription.getName() + ".xml";
                pathname = descDir.getAbsolutePath() + File.separator + descriptorFilename;
                crFile = new File(pathname);
                this.crDescription.getDescriptor().setSourceUrl(crFile.toURI().toURL());
                this.crDescription.getDescriptor().toXML(FileUtilities.getWriterToFile(crFile));
                this.crDescription.setUimaDescPath(descriptorFilename);
                this.filesToDeleteOnSave.remove(descriptorFilename);
            }
            cmFile = new File(descDir.getAbsolutePath() + File.separator + "AggregateMultiplier.xml");
            if (this.cmDelegates != null && this.cmDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() == 1L) {
                cm = this.cmDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).findFirst().get();
                this.aaeCmDesc = cm.getDescriptorAsAnalysisEngineDescription();
                descriptorFilename = cm.getName() + ".xml";
                pathname = descDir.getAbsolutePath() + File.separator + descriptorFilename;
                cmFile = new File(pathname);
                cm.getDescriptor().setSourceUrl(cmFile.toURI().toURL());
                cm.getDescriptorAsAnalysisEngineDescription().toXML(FileUtilities.getWriterToFile(cmFile), true);
                cm.setUimaDescPath(descriptorFilename);
                this.filesToDeleteOnSave.remove(descriptorFilename);
            } else if (this.cmDelegates != null && this.cmDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() > 1L) {
                this.aaeCmDesc.setSourceUrl(cmFile.toURI().toURL());
                this.aaeCmDesc.getMetaData().setName("JCoRe Multiplier AAE");
                this.aaeCmDesc.getMetaData().setDescription("This AAE descriptor directly contains the CAS multipliers added through the JCoRe pipeline builder. The AAE serves to bundle all the components together.");
                this.aaeCmDesc.toXML(FileUtilities.getWriterToFile(cmFile), true);
            } else if (cmFile.exists()) {
                cmFile.delete();
            }
            aaeFile = new File(descDir.getAbsolutePath() + File.separator + "AggregateAnalysisEngine.xml");
            if (this.aaeDesc != null) {
                this.aaeDesc.setSourceUrl(aaeFile.toURI().toURL());
                this.aaeDesc.getMetaData().setName("JCoRe Pipeline AAE");
                this.aaeDesc.getMetaData().setDescription("This AAE descriptor directly contains the analysis engines added through the JCoRe pipeline builder. The AAE serves to bundle all the components together.");
                this.aaeDesc.toXML(FileUtilities.getWriterToFile(aaeFile), true);
            } else if (aaeFile.exists()) {
                aaeFile.delete();
            }
            ccFile = new File(descDir.getAbsolutePath() + File.separator + "AggregateConsumer.xml");
            if (ccFile.exists()) {
                ccFile.delete();
            }
            if (this.ccDelegates != null && this.ccDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() != 0L) {
                activeCCs = this.ccDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).collect(Collectors.toList());
                for (Description ccDesc : activeCCs) {
                    this.storeCCDescriptor(ccDesc, descDir);
                }
                if (activeCCs.size() == 1) {
                    this.ccDesc = (ResourceCreationSpecifier)((Description)activeCCs.get(0)).getDescriptor();
                    ccFile = new File(descDir.getAbsolutePath() + File.separator + ((Description)activeCCs.get(0)).getUimaDescPath());
                } else if (activeCCs.size() > 1) {
                    this.ccDesc = AnalysisEngineFactory.createEngineDescription(new AnalysisEngineDescription[0]);
                    ccAAE = (AnalysisEngineDescription)this.ccDesc;
                    delegateAnalysisEngineSpecifiersWithImports = ccAAE.getDelegateAnalysisEngineSpecifiersWithImports();
                    for (Description desc : activeCCs) {
                        ae = desc.getDescriptorAsAnalysisEngineDescription();
                        aeImport = new Import_impl();
                        aeImport.setLocation(new File(desc.getUri()).getName());
                        aeImport.setSourceUrl(desc.getUri().toURL());
                        delegateAnalysisEngineSpecifiersWithImports.put(ae.getMetaData().getName(), aeImport);
                    }
                    flow = new FixedFlow_impl();
                    delegateNames = (String[])activeCCs.stream().map((Function<Description, AnalysisEngineDescription>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDescriptorAsAnalysisEngineDescription(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Lorg/apache/uima/analysis_engine/AnalysisEngineDescription;)()).map((Function<AnalysisEngineDescription, ResourceMetaData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMetaData(), (Lorg/apache/uima/analysis_engine/AnalysisEngineDescription;)Lorg/apache/uima/resource/metadata/ResourceMetaData;)()).map((Function<ResourceMetaData, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lorg/apache/uima/resource/metadata/ResourceMetaData;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$store$7(int ), (I)[Ljava/lang/String;)());
                    flow.setFixedFlow(delegateNames);
                    ccAAE.getAnalysisEngineMetaData().setFlowConstraints(flow);
                    this.ccDesc.setSourceUrl(ccFile.toURI().toURL());
                    this.ccDesc.getMetaData().setName("JCoRe Consumer AAE");
                    this.ccDesc.getMetaData().setDescription("This consumer AAE descriptor directly contains the CAS consumers added through the JCoRe pipeline builder. The AAE serves to bundle all the components together.");
                    this.ccDesc.toXML(FileUtilities.getWriterToFile(ccFile));
                }
            }
            try {
                cpeAAEFile = new File(descDir.getAbsolutePath() + File.separator + "cpeAAE.xml");
                cpeFile = new File(descDir.getAbsolutePath() + File.separator + "CPE.xml");
                if (this.ccDelegates == null) ** GOTO lbl-1000
                if (this.ccDelegates.stream().map((Function<Description, MetaDataObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getDescriptor(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Lorg/apache/uima/resource/metadata/MetaDataObject;)()).filter((Predicate<MetaDataObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/apache/uima/resource/metadata/MetaDataObject;)Z)(CasConsumer.class)).count() == 0L) lbl-1000:
                // 2 sources

                {
                    builder = new CpeBuilder();
                    if (this.crDescription != null) {
                        builder.setReader(this.crDescription.getDescriptorAsCollectionReaderDescription());
                    }
                    cpeAAE = AnalysisEngineFactory.createEngineDescription(new AnalysisEngineDescription[0]);
                    cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().clear();
                    if (this.cmDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() > 0L) {
                        cmImport = new Import_impl();
                        cmImport.setLocation(cmFile.getName());
                        cmImport.setSourceUrl(cmFile.toURI().toURL());
                        cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().put(this.aaeCmDesc.getMetaData().getName(), cmImport);
                    }
                    if (this.aaeDesc != null) {
                        aaeImport = new Import_impl();
                        aaeImport.setLocation(aaeFile.getName());
                        aaeImport.setSourceUrl(aaeFile.toURI().toURL());
                        cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().put(this.aaeDesc.getMetaData().getName(), aaeImport);
                    }
                    if (this.ccDelegates != null && this.ccDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() > 0L) {
                        ccImport = new Import_impl();
                        ccImport.setLocation(ccFile.getName());
                        ccImport.setSourceUrl(ccFile.toURI().toURL());
                        cpeAAE.getDelegateAnalysisEngineSpecifiersWithImports().put(this.ccDesc.getMetaData().getName(), ccImport);
                    }
                    descriptorsForFlow = Stream.of(new ResourceCreationSpecifier[]{this.aaeCmDesc, this.aaeDesc});
                    if (this.ccDelegates != null && this.ccDelegates.stream().filter((Predicate<Description>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isActive(), (Lde/julielab/jcore/pipeline/builder/base/main/Description;)Z)()).count() > 0L) {
                        descriptorsForFlow = Stream.concat(descriptorsForFlow, Stream.of(this.ccDesc));
                    }
                    flow = (String[])descriptorsForFlow.filter((Predicate<ResourceCreationSpecifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Lorg/apache/uima/resource/ResourceCreationSpecifier;)Z)()).map((Function<ResourceCreationSpecifier, ResourceMetaData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMetaData(), (Lorg/apache/uima/resource/ResourceCreationSpecifier;)Lorg/apache/uima/resource/metadata/ResourceMetaData;)()).map((Function<ResourceMetaData, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lorg/apache/uima/resource/metadata/ResourceMetaData;)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$store$8(int ), (I)[Ljava/lang/String;)());
                    ((FixedFlow)cpeAAE.getAnalysisEngineMetaData().getFlowConstraints()).setFixedFlow(flow);
                    cpeAAE.toXML(FileUtilities.getWriterToFile(cpeAAEFile));
                    builder.setAnalysisEngine(cpeAAE);
                    cpeDescription = builder.getCpeDescription();
                    if (this.crDescription != null) {
                        crImport = new Import_impl();
                        crImport.setLocation(crFile.getName());
                        crDescriptor = cpeDescription.getAllCollectionCollectionReaders()[0].getCollectionIterator().getDescriptor();
                        crDescriptor.setInclude(null);
                        crDescriptor.setImport(crImport);
                    }
                    cpeAaeImport = new Import_impl();
                    cpeAaeImport.setLocation(cpeAAEFile.getName());
                    cpeComponentDescriptor = new CpeComponentDescriptorImpl();
                    cpeComponentDescriptor.setImport(cpeAaeImport);
                    cpeIntegratedCasProcessor = new CpeIntegratedCasProcessorImpl();
                    cpeIntegratedCasProcessor.setCpeComponentDescriptor(cpeComponentDescriptor);
                    cpeIntegratedCasProcessor.setName("CPE AAE");
                    cpeIntegratedCasProcessor.setBatchSize(500);
                    cpeCasProcessors = new CpeCasProcessorsImpl();
                    cpeCasProcessors.addCpeCasProcessor(cpeIntegratedCasProcessor);
                    cpeDescription.setCpeCasProcessors(cpeCasProcessors);
                    cpeDescription.getCpeCasProcessors().setPoolSize(24);
                    cpeDescription.toXML(FileUtilities.getWriterToFile(cpeFile));
                } else {
                    JCoReUIMAPipeline.log.warn("Could not store a CPE descriptor because a CasConsumer is included in the pipeline that implements a CasConsumer interface rather than the AnalysisEngine interface. Note that CasConsumers are basically analysis engines since UIMA 2.0 and that there is no downside in using AEs as consumers.");
                    if (cpeAAEFile.exists()) {
                        cpeAAEFile.delete();
                    }
                    if (cpeFile.exists()) {
                        cpeFile.delete();
                    }
                }
            }
            catch (InvalidXMLException e) {
                JCoReUIMAPipeline.log.error("Could not store the CPE descriptor: ", e);
            }
        }
        catch (IOException | ResourceInitializationException | SAXException e) {
            throw new PipelineIOException(e);
        }
        catch (CpeDescriptorException e) {
            throw new PipelineIOException(e);
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        missingConfiguration = PipelineParameterChecker.findMissingConfiguration(this);
        missingConfigFile = new File(directory.getAbsolutePath() + File.separator + "missing_configuration.txt");
        if (missingConfigFile.exists()) {
            missingConfigFile.delete();
        }
        if (!missingConfiguration.isEmpty()) {
            try {
                JCoReUIMAPipeline.log.warn("There are missing configuration items for this pipeline. A list of these items is written to {}.", (Object)missingConfigFile);
                PipelineParameterChecker.writeMissingConfigurationToFile(missingConfiguration, missingConfigFile);
            }
            catch (IOException e) {
                JCoReUIMAPipeline.log.warn("Could not write the file for missing configuration items", e);
            }
        }
        if ((versionFileStream = this.getClass().getResourceAsStream("/version.txt")) != null) {
            try {
                version = IOUtils.toString(versionFileStream);
                FileUtils.write(new File(directory.getAbsolutePath() + File.separator + "version-pipelinebuilder.txt"), (CharSequence)(version + System.getProperty("line.separator")), StandardCharsets.UTF_8.name());
            }
            catch (IOException e) {
                JCoReUIMAPipeline.log.warn("Could not write pipeline builder version to file:", e);
            }
        }
        try {
            libDir = new File(directory.getAbsolutePath() + File.separator + "lib");
            if (clearLibDir && libDir.exists()) {
                JCoReUIMAPipeline.log.debug("Removing all files from the library directory at {}", (Object)libDir);
                Stream.of(libDir.listFiles()).forEach((Consumer<File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, delete(), (Ljava/io/File;)V)());
            }
            this.storeArtifacts(directory);
        }
        catch (MavenException e) {
            throw new PipelineIOException(e);
        }
        try {
            this.serializeDescriptions(directory, "crDescriptions.bin", this.crDescription);
            this.serializeDescriptions(directory, "cmDescriptions.bin", this.cmDelegates);
            this.serializeDescriptions(directory, "aeDescriptions.bin", this.aeDelegates);
            this.serializeDescriptions(directory, "ccDescriptions.bin", this.ccDelegates);
        }
        catch (IOException e) {
            throw new PipelineIOException(e);
        }
        try {
            if (this.loadDirectory != null && this.loadDirectory.getCanonicalPath().equals(directory.getCanonicalPath())) {
                for (String toDelete : this.filesToDeleteOnSave) {
                    file = new File(directory.getAbsolutePath() + File.separator + "desc" + File.separator + toDelete);
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (IOException e) {
            throw new PipelineIOException(e);
        }
    }

    private void storeCCDescriptor(Description ccDesc, File descDir) throws SAXException, IOException {
        if (!ccDesc.getName().toLowerCase().contains("writer") && !ccDesc.getName().toLowerCase().contains("consumer")) {
            throw new IllegalStateException("The CAS consumer descriptor " + ccDesc.getName() + " at " + ccDesc.getDescriptor().getSourceUrlString() + " does not specify 'writer' or 'consumer' in its name. By convention, consumers must do this to be recognized as consumer.");
        }
        String descriptorFilename = ccDesc.getName() + ".xml";
        File ccFile = new File(descDir.getAbsolutePath() + File.separator + descriptorFilename);
        if (ccDesc.getDescriptor() instanceof AnalysisEngineDescription) {
            ccDesc.getDescriptorAsAnalysisEngineDescription().toXML(FileUtilities.getWriterToFile(ccFile), true);
        } else {
            ccDesc.getDescriptor().toXML(FileUtilities.getWriterToFile(ccFile));
        }
        ccDesc.setUri(ccFile.toURI());
        ccDesc.setUimaDescPath(descriptorFilename);
        this.filesToDeleteOnSave.remove(descriptorFilename);
    }

    public void storeArtifacts(File directory) throws MavenException {
        File libDir = new File(directory.getAbsolutePath() + File.separator + DIR_LIB);
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        Stream<Description> descriptions = Stream.empty();
        if (this.crDescription != null && this.crDescription.getMetaDescription() != null) {
            descriptions = Stream.concat(descriptions, Stream.of(this.crDescription));
        }
        if (this.cmDelegates != null) {
            descriptions = Stream.concat(descriptions, this.cmDelegates.stream().filter(d -> Objects.nonNull(d.getMetaDescription())));
        }
        if (this.aeDelegates != null) {
            descriptions = Stream.concat(descriptions, this.aeDelegates.stream().filter(d -> d.getMetaDescription().isPear() == false && Objects.nonNull(d.getMetaDescription())));
        }
        if (this.ccDelegates != null) {
            descriptions = Stream.concat(descriptions, this.ccDelegates.stream().filter(d -> Objects.nonNull(d.getMetaDescription())));
        }
        this.storeArtifactsOfDescriptions(descriptions, libDir);
    }

    private void storeArtifactsOfDescriptions(Stream<Description> descriptions, File libDir) throws MavenException {
        AetherUtilities.storeArtifactsWithDependencies(descriptions.map(d -> d.getMetaDescription().getMavenArtifact()), libDir);
    }

    private void serializeDescriptions(File pipelineStorageDir, String targetFileName, Object descriptions) throws IOException {
        if (!pipelineStorageDir.exists()) {
            pipelineStorageDir.mkdirs();
        }
        File targetFile = new File(pipelineStorageDir.getAbsolutePath() + File.separatorChar + targetFileName);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(FileUtilities.getOutputStreamToFile(targetFile));){
            objectOutputStream.writeObject(descriptions);
        }
    }

    private <T> T deserializeDescriptions(File pipelineStorageDir, String sourceFileName) throws IOException, ClassNotFoundException {
        File sourceFile = new File(pipelineStorageDir.getAbsolutePath() + File.separatorChar + sourceFileName);
        if (!sourceFile.exists()) {
            return null;
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(FileUtilities.getInputStreamFromFile(sourceFile));){
            Object object = objectInputStream.readObject();
            return (T)object;
        }
    }

    public File getLoadDirectory() {
        return this.loadDirectory;
    }

    public void setLoadDirectory(File loadDirectory) {
        this.loadDirectory = loadDirectory;
    }

    public JCoReUIMAPipeline load(boolean forEditing) throws PipelineIOException {
        if (this.loadDirectory == null) {
            throw new IllegalStateException("The base directory for the pipeline has not been set, cannot load.");
        }
        if (!this.loadDirectory.exists()) {
            throw new PipelineIOException("The JCoReUIMAPipeline directory " + this.loadDirectory + " does not exist.");
        }
        try {
            File confDir;
            try {
                if (forEditing) {
                    this.crDescription = (Description)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CR_DESCS_FILE);
                    this.cmDelegates = (List)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CM_DESCS_FILE);
                    this.aeDelegates = (List)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_AE_DESCS_FILE);
                    this.ccDelegates = (List)this.deserializeDescriptions(this.loadDirectory, SERIALIZED_CC_DESCS_FILE);
                    if (this.cmDelegates == null) {
                        this.cmDelegates = new ArrayList<Description>();
                    }
                    if (this.aeDelegates == null) {
                        this.aeDelegates = new ArrayList<Description>();
                    }
                    if (this.ccDelegates == null) {
                        this.ccDelegates = new ArrayList<Description>();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new PipelineIOException(e);
            }
            File descDir = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_DESC);
            if (!descDir.exists()) {
                throw new PipelineIOException("The JCoReUIMAPipeline directory " + this.loadDirectory + " does not have the descriptor sub directory " + DIR_DESC);
            }
            File[] xmlFiles = descDir.listFiles(f -> f.getName().endsWith(".xml"));
            ArrayList<CollectionReaderDescription> crDescs = new ArrayList<CollectionReaderDescription>();
            ArrayList<AnalysisEngineDescription> cmDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<AnalysisEngineDescription> aaeCmDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<AnalysisEngineDescription> aeDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<AnalysisEngineDescription> aaeDescs = new ArrayList<AnalysisEngineDescription>();
            ArrayList<ResourceSpecifier> ccDescs = new ArrayList<ResourceSpecifier>();
            ArrayList<ResourceSpecifier> aaeCcDescs = new ArrayList<ResourceSpecifier>();
            for (File xmlFile : xmlFiles) {
                ResourceSpecifier spec;
                block41: {
                    if (xmlFile.getName().equals(CPE_AAE_DESC_NAME)) continue;
                    XMLParser parser2 = UIMAFramework.getXMLParser();
                    spec = null;
                    try {
                        spec = parser2.parseResourceSpecifier(new XMLInputSource(xmlFile));
                    }
                    catch (InvalidXMLException e) {
                        if (!log.isDebugEnabled()) break block41;
                        ArrayList<String> messages = new ArrayList<String>();
                        Throwable cause = e;
                        do {
                            messages.add(((Throwable)cause).getMessage());
                        } while ((cause = ((Throwable)cause).getCause()) != null);
                        log.debug("File {} could not be parsed as a UIMA component and is skipped: {}", (Object)xmlFile, (Object)messages.stream().collect(Collectors.joining("; ")));
                    }
                }
                if (spec == null) continue;
                spec.setSourceUrl(xmlFile.getAbsoluteFile().toURI().toURL());
                if (spec instanceof CollectionReaderDescription) {
                    crDescs.add((CollectionReaderDescription)spec);
                    continue;
                }
                if (spec instanceof AnalysisEngineDescription) {
                    AnalysisEngineDescription aeDesc = (AnalysisEngineDescription)spec;
                    if (xmlFile.getName().toLowerCase().contains("consumer") || xmlFile.getName().toLowerCase().contains("writer")) {
                        log.debug("Adding the descriptor {} to CAS consumers because of its file name", (Object)xmlFile);
                        if (aeDesc.isPrimitive()) {
                            log.debug("Reading descriptor {} as CAS consumer", (Object)xmlFile);
                            ccDescs.add(spec);
                            continue;
                        }
                        aaeCcDescs.add(spec);
                        continue;
                    }
                    if (aeDesc.getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
                        log.debug("Reading descriptor {} as CAS multiplier", (Object)xmlFile);
                        if (aeDesc.isPrimitive()) {
                            cmDescs.add(aeDesc);
                            continue;
                        }
                        aaeCmDescs.add(aeDesc);
                        continue;
                    }
                    log.debug("Reading descriptor {} as analysis engine", (Object)xmlFile);
                    if (aeDesc.isPrimitive()) {
                        aeDescs.add(aeDesc);
                        continue;
                    }
                    aaeDescs.add(aeDesc);
                    continue;
                }
                if (spec instanceof CasConsumerDescription) {
                    ccDescs.add(spec);
                    continue;
                }
                log.debug("Ignoring file " + xmlFile + " because it is no UIMA component descriptor.");
            }
            if (crDescs.isEmpty()) {
                log.warn("There is no CollectionReader descriptor in directory " + descDir.getAbsolutePath() + ". A pipeline without a CollectionReader cannot be run.");
            }
            if (crDescs.size() > 1) {
                throw new PipelineIOException("There are multiple CollectionReader descriptors in directory " + descDir.getAbsolutePath() + ": " + crDescs.stream().map(MetaDataObject::getSourceUrlString).collect(Collectors.joining("\n")));
            }
            if (aeDescs.size() > 1 && aaeDescs.isEmpty()) {
                throw new PipelineIOException("There are multiple primitive Analysis Engine descriptors in directory " + descDir.getAbsolutePath() + ": " + crDescs.stream().map(MetaDataObject::getSourceUrlString).collect(Collectors.joining("\n")) + ". While it would be possible to build an aggregate automatically, this cannot be done because the required order is unknown. Automatic ordering by annotator capabilities is currently not supported.");
            }
            this.getClasspathElements().forEach(JarLoader::addJarToClassPath);
            if (this.crDescription == null && crDescs != null && !crDescs.isEmpty()) {
                this.crDescription = new Description(((CollectionReaderDescription)crDescs.get(0)).getSourceUrl());
            }
            if (!cmDescs.isEmpty()) {
                this.aaeCmDesc = (AnalysisEngineDescription)cmDescs.get(0);
            }
            if (aaeCmDescs.size() == 1) {
                this.aaeCmDesc = (AnalysisEngineDescription)aaeCmDescs.get(0);
            }
            if (aaeCmDescs.size() > 1) {
                this.setAaeDesc(descDir, cmDescs, aaeCmDescs, "CAS multiplier", desc -> {
                    this.aaeCmDesc = desc;
                });
            }
            if (!aeDescs.isEmpty()) {
                this.aaeDesc = (AnalysisEngineDescription)aeDescs.get(0);
            }
            if (aaeDescs.size() == 1) {
                this.aaeDesc = (AnalysisEngineDescription)aaeDescs.get(0);
            }
            if (aaeDescs.size() > 1) {
                this.setAaeDesc(descDir, aeDescs, aaeDescs, "analysis engine", desc -> {
                    this.aaeDesc = desc;
                });
            }
            if (!ccDescs.isEmpty()) {
                this.ccDesc = (ResourceCreationSpecifier)ccDescs.get(0);
            }
            if (aaeCcDescs.size() == 1) {
                this.ccDesc = (ResourceCreationSpecifier)aaeCcDescs.get(0);
            }
            if (aaeCcDescs.size() > 1) {
                List<AnalysisEngineDescription> ccAeDescs = ccDescs.stream().map(AnalysisEngineDescription.class::cast).collect(Collectors.toList());
                List<AnalysisEngineDescription> ccAaeDescs = aaeCcDescs.stream().map(AnalysisEngineDescription.class::cast).collect(Collectors.toList());
                this.setAaeDesc(descDir, ccAeDescs, ccAaeDescs, "CAS consumer", desc -> {
                    this.ccDesc = desc;
                });
            }
            if (this.crDescription != null && !crDescs.isEmpty()) {
                this.crDescription.setDescriptor((MetaDataObject)crDescs.get(0));
            }
            if (this.aaeCmDesc != null && !this.cmDelegates.isEmpty()) {
                this.setAaeDescriptors(this.aaeCmDesc, this.cmDelegates, "CAS Multiplier");
            }
            if (this.aaeDesc != null && !this.aeDelegates.isEmpty()) {
                this.setAaeDescriptors(this.aaeDesc, this.aeDelegates, "Analysis Engine");
            }
            if (this.ccDesc != null && !this.ccDelegates.isEmpty() && this.ccDesc instanceof AnalysisEngineDescription) {
                this.setAaeDescriptors((AnalysisEngineDescription)this.ccDesc, this.ccDelegates, "CAS Consumer");
            }
            if ((confDir = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_CONF)).exists()) {
                File[] files = confDir.listFiles((dir, name) -> !name.equals(JAR_CONF_FILES));
                File configJar = new File(confDir.getAbsolutePath() + File.separator + JAR_CONF_FILES);
                log.debug("Packaging configuration data files {} into the JAR file {} to be able to load it for the pipeline runner.", (Object)files, (Object)configJar);
                FileUtilities.createJarFile(configJar, files);
            }
        }
        catch (IOException | URISyntaxException | InvalidXMLException e) {
            throw new PipelineIOException(e);
        }
        return this;
    }

    private void setAaeDescriptors(AnalysisEngineDescription aae, List<Description> descriptions, String type) throws PipelineIOException, InvalidXMLException {
        if (!aae.isPrimitive()) {
            Map descByName = descriptions.stream().collect(Collectors.toMap(Description::getName, Function.identity()));
            FlowConstraints flowConstraints = aae.getAnalysisEngineMetaData().getFlowConstraints();
            if (!(flowConstraints instanceof FixedFlow)) {
                throw new PipelineIOException(String.format("The %s aggregate does not define a FixedFlow. Only FixedFlow constraints are currently supported.", type));
            }
            FixedFlow flow = (FixedFlow)flowConstraints;
            for (int i = 0; i < flow.getFixedFlow().length; ++i) {
                String component = flow.getFixedFlow()[i];
                ResourceSpecifier descriptor = aae.getDelegateAnalysisEngineSpecifiers().get(component);
                if (i >= descriptions.size()) continue;
                ((Description)descByName.get(component)).setDescriptor(descriptor);
            }
            log.debug("For the {} aggregate, the following delegate descriptors were set: {}", (Object)type, (Object)Stream.of(flow.getFixedFlow()).collect(Collectors.joining(", ")));
        } else {
            if (descriptions.size() > 1) {
                log.error("The {} is not an aggregate but there are {} descriptions with the following names: {}", type, descriptions.size(), descriptions.stream().map(Description::getName).collect(Collectors.joining(", ")));
            }
            descriptions.get(0).setDescriptor(aae);
        }
    }

    private void setAaeDesc(File descDir, List<AnalysisEngineDescription> aeDescs, List<AnalysisEngineDescription> aaeDescs, String componentType, Consumer<AnalysisEngineDescription> descSetter) throws InvalidXMLException, PipelineIOException {
        Set aeUris = aeDescs.stream().map(MetaDataObject::getSourceUrl).map(URL::toString).collect(Collectors.toSet());
        Set aaeUris = aaeDescs.stream().map(MetaDataObject::getSourceUrl).map(URL::toString).collect(Collectors.toSet());
        HashSet delegateUris = new HashSet();
        for (AnalysisEngineDescription aaeDesc2 : aaeDescs) {
            delegateUris.addAll(aaeDesc2.getDelegateAnalysisEngineSpecifiers().values().stream().map(MetaDataObject::getSourceUrl).map(URL::toString).collect(Collectors.toList()));
        }
        Sets.SetView topAAEs = Sets.difference(aaeUris, delegateUris);
        Sets.SetView aesNotInAAE = Sets.difference(aeUris, delegateUris);
        if (topAAEs.size() > 1) {
            throw new PipelineIOException("There are multiple " + componentType + "s in " + descDir.getAbsolutePath() + " that don't have a common super AAE. The pipeline cannot be built because it is unknown which to use.");
        }
        if (!topAAEs.isEmpty()) {
            String topAAEUri = (String)topAAEs.iterator().next();
            descSetter.accept(aaeDescs.stream().filter(aaeDesc -> aaeDesc.getSourceUrlString().equals(topAAEUri)).findFirst().get());
            if (!aesNotInAAE.isEmpty()) {
                log.warn("The AAE {} is used for the " + componentType + " + part of the pipeline. Primitive Analysis Engines that are no direct or indirect delegate of this AAE will not be run. The following " + componentType + "s are not a part of the AAE: {}", (Object)topAAEUri, (Object)aesNotInAAE);
            }
        } else {
            descSetter.accept(aaeDescs.get(0));
        }
    }

    public List<Description> getAeDelegates() {
        return this.aeDelegates;
    }

    public void addDelegateAe(Description aeDesc) {
        if (!aeDesc.getMetaDescription().isPear().booleanValue()) {
            if (!(aeDesc.getDescriptor() instanceof AnalysisEngineDescription)) {
                throw new IllegalArgumentException("The passed description " + aeDesc + " does not specify an analysis engine description but an instance of " + aeDesc.getDescriptor().getClass().getCanonicalName());
            }
            if (aeDesc.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
                throw new IllegalArgumentException("The passed description " + aeDesc + " is set to output new CASes, i.e. it is a CAS multiplier. Add it via the appropriate method to the pipeline.");
            }
        }
        this.aeDelegates.add(aeDesc);
    }

    public void addCasMultiplier(Description multiplier) {
        if (!(multiplier.getDescriptor() instanceof AnalysisEngineDescription)) {
            throw new IllegalArgumentException("The passed description " + multiplier + " does not specify an analysis engine description but an instance of " + multiplier.getDescriptor().getClass().getCanonicalName());
        }
        if (!multiplier.getDescriptorAsAnalysisEngineDescription().getAnalysisEngineMetaData().getOperationalProperties().getOutputsNewCASes()) {
            throw new IllegalArgumentException("The passed description " + multiplier + " is set not to output new CASes, i.e. it is a simple analysis engine and not a CAS multiplier. Add it via the appropriate method to the pipeline.");
        }
        this.cmDelegates.add(multiplier);
    }

    public Stream<File> getClasspathElements() throws PipelineIOException {
        File libDir = null;
        if (this.loadDirectory != null) {
            libDir = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_LIB);
        }
        if (!(this.loadDirectory == null || libDir.exists() && libDir.list().length != 0)) {
            try {
                this.storeArtifacts(this.loadDirectory);
            }
            catch (MavenException e) {
                throw new PipelineIOException("Error occurred when trying to store the Maven artifacts to the " + this.loadDirectory.getAbsolutePath() + File.separator + DIR_LIB + " directory. This storage is necessary to return the classpath elements which was requested by calling this method.", e);
            }
        }
        if (this.loadDirectory != null && libDir.exists()) {
            File configJar = new File(this.loadDirectory.getAbsolutePath() + File.separator + DIR_CONF);
            File[] libFiles = libDir.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".zip"));
            Stream<File> libFilesStream = Stream.of(libFiles);
            if (configJar.exists()) {
                libFilesStream = Stream.concat(libFilesStream, Stream.of(configJar));
            }
            return libFilesStream;
        }
        ArrayList<Stream<MavenArtifact>> artifactList = new ArrayList<Stream<MavenArtifact>>();
        Function<Description, MavenArtifact> artifactExtractor = d -> d.getMetaDescription() != null ? d.getMetaDescription().getMavenArtifact() : null;
        if (this.crDescription != null) {
            artifactList.add(Stream.of(artifactExtractor.apply(this.crDescription)));
        }
        if (this.cmDelegates != null) {
            artifactList.add(this.cmDelegates.stream().map(artifactExtractor));
        }
        if (this.aeDelegates != null) {
            artifactList.add(this.aeDelegates.stream().map(artifactExtractor));
        }
        if (this.ccDelegates != null) {
            artifactList.add(this.ccDelegates.stream().map(artifactExtractor));
        }
        return artifactList.stream().flatMap(Function.identity()).filter(Objects::nonNull).flatMap(artifact -> {
            try {
                return AetherUtilities.getDependencies(artifact);
            }
            catch (MavenException e) {
                log.error("Maven exception while trying to get transitive dependencies of artifact {}:{}:{}", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), e);
                return null;
            }
        }).map(Artifact::getFile);
    }

    public void removeComponent(Description description) {
        if (description.equals(this.crDescription)) {
            this.crDescription = null;
        }
        if (this.aeDelegates != null && this.aeDelegates.contains(description)) {
            this.aeDelegates.remove(description);
            this.aaeDesc = null;
        }
        if (this.cmDelegates != null && this.cmDelegates.contains(description)) {
            this.cmDelegates.remove(description);
            this.aaeCmDesc = null;
        }
        if (this.ccDelegates != null && this.ccDelegates.contains(description)) {
            this.ccDelegates.remove(description);
            this.ccDesc = null;
        }
        if (description.getUimaDescPath() != null) {
            this.filesToDeleteOnSave.add(description.getUimaDescPath());
        }
    }

    public String getClassPath() throws PipelineIOException {
        Stream<File> artifactFiles = this.getClasspathElements();
        Stream<String> classpathElements = artifactFiles.map(File::getAbsolutePath);
        return classpathElements.collect(Collectors.joining(File.pathSeparator));
    }

    public AnalysisEngineDescription getAaeCmDesc() {
        return this.aaeCmDesc;
    }

    public ResourceCreationSpecifier getCcDesc() {
        return this.ccDesc;
    }

    public List<Description> getCmDelegates() {
        return this.cmDelegates;
    }

    public AnalysisEngineDescription getCompleteAggregateDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription((AnalysisEngineDescription[])Stream.of(this.aaeCmDesc, this.aaeDesc, (AnalysisEngineDescription)this.ccDesc).filter(Objects::nonNull).toArray(AnalysisEngineDescription[]::new));
    }

    public void clear() {
        this.crDescription = null;
        if (this.aeDelegates != null) {
            this.aeDelegates.clear();
        }
        if (this.cmDelegates != null) {
            this.cmDelegates.clear();
        }
        this.aaeDesc = null;
        this.aaeCmDesc = null;
        this.ccDesc = null;
        if (this.ccDelegates != null) {
            this.ccDelegates.clear();
        }
        this.loadDirectory = null;
    }

    private static /* synthetic */ String[] lambda$store$8(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$store$7(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ AnalysisEngineDescription[] lambda$store$6(int x$0) {
        return new AnalysisEngineDescription[x$0];
    }

    private static /* synthetic */ AnalysisEngineDescription[] lambda$store$5(int x$0) {
        return new AnalysisEngineDescription[x$0];
    }

    private static /* synthetic */ boolean lambda$store$4(Description desc) {
        return desc.getMetaDescription().isPear() == false;
    }
}

