/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorUtils {
    private static final Logger log = LoggerFactory.getLogger(DescriptorUtils.class);
    private static final Map<String, String> descRoots = new HashMap<String, String>(){
        {
            this.put("collectionReaderDescription", "processingResourceMetaData");
            this.put("analysisEngineDescription", "analysisEngineMetaData");
            this.put("casConsumerDescription", "processingResourceMetaData");
        }
    };

    public static Map<URI, ResourceSpecifier> searchDescriptor(File artifact) throws IOException {
        HashMap<URI, ResourceSpecifier> descriptors = new HashMap<URI, ResourceSpecifier>();
        XMLParser parser = UIMAFramework.getXMLParser();
        try (FileSystem zipFs = FileSystems.newFileSystem(artifact.toPath(), null);){
            for (Path rootDir : zipFs.getRootDirectories()) {
                Iterator xmlIt = Files.walk(rootDir, new FileVisitOption[0]).filter(p -> p.getFileName().toString().toLowerCase().endsWith(".xml")).iterator();
                while (xmlIt.hasNext()) {
                    Path xmlFile = (Path)xmlIt.next();
                    try {
                        ResourceSpecifier resourceSpecifier = parser.parseResourceSpecifier(new XMLInputSource(xmlFile.toUri().toURL().openStream(), null));
                        descriptors.put(xmlFile.toUri(), resourceSpecifier);
                    }
                    catch (InvalidXMLException e) {
                        log.debug("XML file {} could not be parsed as a UIMA descriptor and is skipped in the search of descriptors in {}", (Object)xmlFile, (Object)artifact);
                    }
                }
            }
        }
        if (descriptors.isEmpty()) {
            log.debug("No descriptors were found for artifact file {}", (Object)artifact);
        }
        return descriptors;
    }

    public static ResourceSpecifier searchDescriptor(File artifactPath, String descLocation) throws IOException {
        ResourceSpecifier spec = null;
        XMLParser parser = UIMAFramework.getXMLParser();
        try (ZipFile zipFile = new ZipFile(artifactPath);){
            String path = descLocation.replaceAll("\\.", "/") + ".xml";
            ZipEntry entry = zipFile.getEntry(path);
            InputStream inputStream = zipFile.getInputStream(entry);
            spec = parser.parseResourceSpecifier(new XMLInputSource(inputStream, null));
        }
        catch (InvalidXMLException e) {
            log.error("Could not load XML descriptor {} in file {}", new Object[]{descLocation, artifactPath, e});
        }
        return spec;
    }

    public static Map<String, String> getDescRoots() {
        return descRoots;
    }
}

