/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.main;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.java.utilities.UriUtilities;
import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.main.MetaDescription;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Description
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20180619001L;
    private static Logger logger = LoggerFactory.getLogger(Description.class);
    private URI uri;
    private String location;
    private PipelineBuilderConstants.JcoreMeta.Category category;
    private String xmlName;
    private MetaDataObject specifier;
    private String descriptorType;
    private Map<String, ArrayList<String>> capabilities = new HashMap<String, ArrayList<String>>(){
        {
            this.put("in", new ArrayList());
            this.put("out", new ArrayList());
        }
    };
    private Boolean initCapabilities = false;
    private Map<String, ConfigurationParameter> configurationParameter = null;
    private MetaDescription metaDescription;

    public Description() {
    }

    public Description(URI uri, ResourceSpecifier specifier) {
        this.uri = uri;
        this.xmlName = uri.toString();
        this.specifier = specifier;
    }

    public Description(URL sourceUrl) throws URISyntaxException, IOException, InvalidXMLException {
        this.uri = sourceUrl.toURI();
        this.parseDescXml(UriUtilities.getInputStreamFromUri((URI)sourceUrl.toURI()), this.xmlName);
    }

    public URI getUri() {
        return this.uri;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public PipelineBuilderConstants.JcoreMeta.Category getCategory() {
        return this.category;
    }

    public void setCategory(PipelineBuilderConstants.JcoreMeta.Category category) {
        this.category = category;
    }

    @JsonIgnore
    public String getDescriptorType() {
        return this.descriptorType;
    }

    private void parseDescXml(InputStream desc, String xmlName) throws InvalidXMLException {
        ResourceSpecifier spec;
        XMLParser parser = UIMAFramework.getXMLParser();
        try {
            spec = parser.parseResourceSpecifier(new XMLInputSource(desc, null));
        }
        catch (InvalidXMLException e) {
            logger.debug("XML {} could not be parsed as a UIMA component and is skipped.", (Object)xmlName);
            throw e;
        }
        if (spec != null) {
            this.specifier = spec;
            if (spec instanceof CollectionReaderDescription) {
                this.descriptorType = "reader";
            } else if (spec instanceof AnalysisEngineDescription) {
                this.descriptorType = "ae|multiplier";
            } else if (spec instanceof CasConsumerDescription) {
                this.descriptorType = "consumer";
            }
        }
    }

    private ResourceMetaData getMetaData() {
        return this.specifier != null && this.specifier instanceof ResourceCreationSpecifier ? ((ResourceCreationSpecifier)this.specifier).getMetaData() : null;
    }

    @JsonIgnore
    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public void addCapability(String type, String value) {
        if (this.capabilities.containsKey(type)) {
            this.capabilities.get(type).add(value);
        }
    }

    public void setCapabilities(String type, List<String> values) {
    }

    @JsonIgnore
    public List<String> getCapabilities(String type) {
        if (!this.initCapabilities.booleanValue()) {
            TypeOrFeature tof;
            int i;
            Capability[] capsArray = (Capability[])this.getMetaData().getAttributeValue("capabilities");
            for (i = 0; i < capsArray[0].getInputs().length; ++i) {
                tof = capsArray[0].getInputs()[i];
                this.addCapability("in", tof.getName());
            }
            for (i = 0; i < capsArray[0].getOutputs().length; ++i) {
                tof = capsArray[0].getOutputs()[i];
                this.addCapability("out", tof.getName());
            }
            this.initCapabilities = true;
        }
        return this.capabilities.getOrDefault(type, null);
    }

    @JsonIgnore
    public String getName() {
        return this.getMetaData() != null ? this.getMetaData().getName() : this.getMetaDescription().getName();
    }

    @JsonIgnore
    public Map<String, ConfigurationParameter> getConfigurationParameters() {
        if (this.configurationParameter == null) {
            this.configurationParameter = new HashMap<String, ConfigurationParameter>();
            for (ConfigurationParameter cp : this.getMetaData().getConfigurationParameterDeclarations().getConfigurationParameters()) {
                this.configurationParameter.put(cp.getName(), cp);
            }
        }
        return this.configurationParameter;
    }

    @JsonIgnore
    public Object getConfigurationParameterValue(String parameter) {
        if (!(this.specifier instanceof ResourceCreationSpecifier)) {
            throw new IllegalArgumentException("The descriptor " + this.getName() + " is of class " + this.specifier.getClass().getCanonicalName() + ". A " + ResourceSpecifier.class.getCanonicalName() + " is required.");
        }
        if (this.getConfigurationParameters().containsKey(parameter)) {
            return ConfigurationParameterFactory.getParameterSettings((ResourceSpecifier)((ResourceSpecifier)this.specifier)).getOrDefault(parameter, null);
        }
        return null;
    }

    public void setConfigurationParameterValue(String key, Object value) {
        if (!(this.specifier instanceof ResourceCreationSpecifier)) {
            throw new IllegalArgumentException("The descriptor " + this.getName() + " is of class " + this.specifier.getClass().getCanonicalName() + ". A " + ResourceSpecifier.class.getCanonicalName() + " is required.");
        }
        ConfigurationParameterFactory.setParameter((ResourceSpecifier)((ResourceSpecifier)this.specifier), (String)key, (Object)value);
    }

    @JsonIgnore
    public MetaDataObject getDescriptor() {
        return this.specifier;
    }

    public void setDescriptor(MetaDataObject descriptor) {
        this.specifier = descriptor;
    }

    @JsonIgnore
    public CollectionReaderDescription getDescriptorAsCollectionReaderDescription() {
        return (CollectionReaderDescription)this.specifier;
    }

    @JsonIgnore
    public AnalysisEngineDescription getDescriptorAsAnalysisEngineDescription() {
        return (AnalysisEngineDescription)this.specifier;
    }

    public void loadDescriptor(InputStream descStream) throws InvalidXMLException {
        this.parseDescXml(descStream, this.getXmlName() != null ? this.getXmlName() : "<XML descriptor location not set>");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Description that = (Description)o;
        return Objects.equals(this.location, that.location) && this.category == that.category && Objects.equals(this.descriptorType, that.descriptorType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.location, this.category, this.descriptorType});
    }

    @JsonIgnore
    public MetaDescription getMetaDescription() {
        return this.metaDescription;
    }

    public void setMetaDescription(MetaDescription metaDescription) {
        this.metaDescription = metaDescription;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            logger.debug("Error occurred when serializing description for toString(), only returning the name: ", (Throwable)e);
            return this.getName();
        }
    }

    public Description clone() throws CloneNotSupportedException {
        Description clone = (Description)super.clone();
        if (this.specifier != null) {
            clone.specifier = (MetaDataObject)this.specifier.clone();
        }
        clone.configurationParameter = null;
        return clone;
    }
}

