/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.builder.base.connectors;

import de.julielab.jcore.pipeline.builder.base.configurations.PipelineBuilderConstants;
import de.julielab.jcore.pipeline.builder.base.exceptions.IORuntimeException;
import de.julielab.jcore.pipeline.builder.base.exceptions.MavenException;
import de.julielab.jcore.pipeline.builder.base.main.MavenArtifact;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenConnector {
    private static final Logger log = LoggerFactory.getLogger(MavenConnector.class);
    private static final RemoteRepository central = new RemoteRepository.Builder("central", "default", "https://oss.sonatype.org/content/repositories/public/").setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn")).build();

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private static RepositorySystemSession newSession(RepositorySystem system, File localRepository) throws SettingsBuildingException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setConfigProperty("aether.artifactResolver.snapshotNormalization", (Object)false);
        LocalRepository localRepo = new LocalRepository(localRepository.toString());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setUpdatePolicy("always");
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        Settings mavenSettings = MavenConnector.getMavenSettings();
        List mirrors = mavenSettings.getMirrors();
        for (Mirror mirror : mirrors) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), null, false, mirror.getMirrorOf(), "");
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        return session;
    }

    private static Map<String, Authentication> getRepositoryAuthenticationsFromMavenSettings() throws SettingsBuildingException {
        HashMap<String, Authentication> authenticationMap = new HashMap<String, Authentication>();
        List servers = MavenConnector.getMavenSettings().getServers();
        for (Server server : servers) {
            Authentication auth;
            if (server.getUsername() != null && server.getPassword() != null) {
                auth = new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).build();
                authenticationMap.put(server.getId(), auth);
            }
            if (server.getPassphrase() == null || server.getPrivateKey() == null) continue;
            auth = new AuthenticationBuilder().addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build();
            authenticationMap.put(server.getId(), auth);
        }
        return authenticationMap;
    }

    public static void main(String[] args) {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId("de.julielab");
        artifact.setArtifactId("jcore-jsbd-ae");
        artifact.setVersion("2.3.0-SNAPSHOT");
        artifact.setPackaging("jar");
        try {
            MavenConnector.storeArtifactWithDependencies(artifact, new File("testdir"));
        }
        catch (MavenException e) {
            e.printStackTrace();
        }
    }

    public static MavenArtifact getArtifactByAether(MavenArtifact artifact) throws MavenException {
        return MavenConnector.getArtifactByAether(artifact, new File(System.getProperty("user.home") + File.separatorChar + PipelineBuilderConstants.Maven.LOCAL_REPO));
    }

    public static MavenArtifact getArtifactByAether(MavenArtifact a, File localRepository) throws MavenException {
        DefaultArtifact artifact = null;
        try {
            RepositorySystem repositorySystem = MavenConnector.newRepositorySystem();
            RepositorySystemSession session = MavenConnector.newSession(repositorySystem, localRepository);
            artifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getPackaging(), a.getVersion());
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            List<RemoteRepository> repositories = MavenConnector.getEffectiveRepositories(session);
            artifactRequest.setRepositories(repositories);
            File localArtifactFile = new File(localRepository.getAbsolutePath() + File.separator + session.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)artifact));
            if (localArtifactFile.exists()) {
                MavenArtifact ret = new MavenArtifact((Artifact)artifact);
                ret.setFile(localArtifactFile);
                return ret;
            }
            ArtifactResult artifactResult = repositorySystem.resolveArtifact(session, artifactRequest);
            artifact = artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            e.printStackTrace();
            throw new MavenException(e);
        }
        catch (SettingsBuildingException e) {
            e.printStackTrace();
        }
        return new MavenArtifact((Artifact)artifact);
    }

    private static List<RemoteRepository> getEffectiveRepositories(RepositorySystemSession session) throws SettingsBuildingException {
        Map<String, Authentication> authenticationMap = MavenConnector.getRepositoryAuthenticationsFromMavenSettings();
        DefaultRemoteRepositoryManager remoteRepositoryManager = new DefaultRemoteRepositoryManager();
        List<RemoteRepository> repositories = remoteRepositoryManager.aggregateRepositories(session, Arrays.asList(central), MavenConnector.getRemoteRepositoriesFromSettings(), true);
        repositories = repositories.stream().map(repo -> {
            if (authenticationMap.containsKey(repo.getId())) {
                return new RemoteRepository.Builder(repo).setAuthentication((Authentication)authenticationMap.get(repo.getId())).build();
            }
            return repo;
        }).collect(Collectors.toList());
        return repositories;
    }

    public static void storeArtifactWithDependencies(MavenArtifact requestedArtifact, File libDir) throws MavenException {
        log.trace("Storing artifact {} with all its dependencies to {}", (Object)requestedArtifact, (Object)libDir);
        Stream<Artifact> dependencies = MavenConnector.getDependencies(requestedArtifact);
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        Consumer<Artifact> writer = a -> {
            File destination = new File(libDir.getAbsolutePath() + File.separator + a.getFile().getName());
            try {
                log.trace("Now writing: {} to {}", a, (Object)destination);
                Files.copy(a.getFile().toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        };
        dependencies.forEach(writer);
    }

    public static Stream<Artifact> getDependencies(MavenArtifact requestedArtifact) throws MavenException {
        return MavenConnector.getDependencies(requestedArtifact, false);
    }

    public static Stream<String> getVersions(MavenArtifact requestedArtifact) throws MavenException {
        return MavenConnector.getVersions(requestedArtifact, "0", String.valueOf(Integer.MAX_VALUE), true, true);
    }

    public static Stream<String> getVersions(MavenArtifact requestedArtifact, String lowerBound, String upperBound, boolean lowerInclusive, boolean upperInclusive) throws MavenException {
        RepositorySystemSession session;
        RepositorySystem repositorySystem = MavenConnector.newRepositorySystem();
        try {
            session = MavenConnector.newSession(repositorySystem, new File(Paths.get(System.getProperty("user.home"), PipelineBuilderConstants.Maven.LOCAL_REPO).toString()));
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        String groupId = requestedArtifact.getGroupId();
        String artifactId = requestedArtifact.getArtifactId();
        String classifier = requestedArtifact.getClassifier();
        String version = requestedArtifact.getVersion();
        String packaging = requestedArtifact.getPackaging();
        String lower = lowerInclusive ? "[" : "(";
        String upper = upperInclusive ? "]" : ")";
        String range = lower + lowerBound + ", " + upperBound + upper;
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, range);
        try {
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, MavenConnector.getEffectiveRepositories(session), null);
            VersionRangeResult result = repositorySystem.resolveVersionRange(session, versionRangeRequest);
            return result.getVersions().stream().map(Version::toString);
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        catch (VersionRangeResolutionException e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }

    public static String getNewestVersion(MavenArtifact requestedArtifact) throws MavenException {
        List versions = MavenConnector.getVersions(requestedArtifact).collect(Collectors.toList());
        if (!versions.isEmpty()) {
            return (String)versions.get(versions.size() - 1);
        }
        return null;
    }

    private static Stream<Artifact> getDependencies(MavenArtifact requestedArtifact, boolean recursiveCall) throws MavenException {
        RepositorySystemSession session;
        RepositorySystem repositorySystem = MavenConnector.newRepositorySystem();
        try {
            session = MavenConnector.newSession(repositorySystem, new File(Paths.get(System.getProperty("user.home"), PipelineBuilderConstants.Maven.LOCAL_REPO).toString()));
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        String groupId = requestedArtifact.getGroupId();
        String artifactId = requestedArtifact.getArtifactId();
        String classifier = requestedArtifact.getClassifier();
        String version = requestedArtifact.getVersion();
        String packaging = requestedArtifact.getPackaging();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
        Dependency dependency = new Dependency((Artifact)artifact, "compile");
        DependencyResult dependencyResult = null;
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(dependency);
            collectRequest.setRepositories(MavenConnector.getEffectiveRepositories(session));
            CollectResult collectResult = repositorySystem.collectDependencies(session, collectRequest);
            DependencyNode node = collectResult.getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            dependencyResult = repositorySystem.resolveDependencies(session, dependencyRequest);
        }
        catch (SettingsBuildingException | DependencyCollectionException | DependencyResolutionException e) {
            if (!recursiveCall) {
                try {
                    return MavenConnector.getDependencies(requestedArtifact, true);
                }
                catch (MavenException e1) {
                    throw new MavenException(e);
                }
            }
            throw new MavenException(e);
        }
        return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact);
    }

    private static List<RemoteRepository> getRemoteRepositoriesFromSettings() throws SettingsBuildingException {
        Settings effectiveSettings = MavenConnector.getMavenSettings();
        Map<String, Authentication> authenticationMap = MavenConnector.getRepositoryAuthenticationsFromMavenSettings();
        Map profilesMap = effectiveSettings.getProfilesAsMap();
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>(20);
        for (String profileName : effectiveSettings.getActiveProfiles()) {
            Profile profile = (Profile)profilesMap.get(profileName);
            if (profile == null) continue;
            List repositories = profile.getRepositories();
            for (Repository repo : repositories) {
                Authentication auth = authenticationMap.get(repo.getId());
                RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl());
                if (auth != null) {
                    repoBuilder.setAuthentication(auth);
                }
                repoBuilder.setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn"));
                RemoteRepository remoteRepo = repoBuilder.build();
                remotes.add(remoteRepo);
            }
        }
        if (log.isTraceEnabled()) {
            remotes.forEach(r -> log.trace("Getting repository from Maven settings: {}", r));
        }
        return remotes;
    }

    private static Settings getMavenSettings() throws SettingsBuildingException {
        String userHome = System.getProperty("user.home");
        File userMavenConfigurationHome = new File(userHome, ".m2");
        String envM2Home = System.getenv("M2_HOME");
        File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
        File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", envM2Home != null ? envM2Home : ""), "conf/settings.xml");
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(DEFAULT_USER_SETTINGS_FILE);
        settingsBuildingRequest.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        return settingsBuildingResult.getEffectiveSettings();
    }
}

