/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.opennlp.token;

import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAnnotator
extends JCasAnnotator_ImplBase {
    private static final String PARAM_NAME = "ModelFile";
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAnnotator.class);
    public static final String COMPONENT_ID = TokenAnnotator.class.getName();
    private TokenizerME tokenizer;
    private String modelFilePath;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        LOGGER.info("Initializing OpenNLP Token Annotator ...");
        super.initialize(aContext);
        this.modelFilePath = (String)aContext.getConfigParameterValue(PARAM_NAME);
        try {
            InputStream is;
            File modelFile = new File(this.modelFilePath);
            if (modelFile.exists()) {
                is = new FileInputStream(modelFile);
            } else {
                String modelResource = this.modelFilePath.startsWith("/") ? this.modelFilePath : "/" + this.modelFilePath;
                is = ((Object)((Object)this)).getClass().getResourceAsStream(modelResource);
            }
            if (is == null) {
                throw new ResourceInitializationException("could_not_access_data", new Object[]{this.modelFilePath});
            }
            this.tokenizer = new TokenizerME(new TokenizerModel(is));
        }
        catch (IOException e) {
            LOGGER.error("Could not load tokenizer model: " + e.getMessage());
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas aJCas) {
        int tokenNumber = 1;
        LOGGER.trace("Processing document ...");
        AnnotationIndex sentenceIndex = aJCas.getJFSIndexRepository().getAnnotationIndex(Sentence.type);
        FSIterator sentenceIterator = sentenceIndex.iterator();
        if (!sentenceIterator.hasNext()) {
            LOGGER.debug("Current document has no annotations of type {}, skipping.", Sentence.class);
        }
        while (sentenceIterator.hasNext()) {
            Sentence sentence = (Sentence)sentenceIterator.next();
            String text = sentence.getCoveredText();
            Span[] tokenSpans = this.tokenizer.tokenizePos(text);
            int i = 0;
            while (i < tokenSpans.length) {
                Span span = tokenSpans[i];
                Token token = new Token(aJCas);
                token.setId("" + tokenNumber);
                token.setBegin(sentence.getBegin() + span.getStart());
                token.setEnd(sentence.getBegin() + span.getEnd());
                token.setComponentId(COMPONENT_ID);
                token.addToIndexes();
                ++tokenNumber;
                ++i;
            }
        }
    }
}

