/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.FSCollectionFactory;

public final class CasUtil {
    public static final String UIMA_BUILTIN_JCAS_PREFIX = "org.apache.uima.jcas.";

    private CasUtil() {
    }

    public static <T extends FeatureStructure> Iterator<T> iteratorFS(CAS cas, Type type) {
        return FSCollectionFactory.create(cas, type).iterator();
    }

    public static <T extends AnnotationFS> Iterator<T> iterator(CAS cas, Type type) {
        return cas.getAnnotationIndex(type).withSnapshotIterators().iterator();
    }

    public static Type getType(CAS cas, Class<?> type) {
        return CasUtil.getType(cas, type.getName());
    }

    public static Type getType(CAS aCas, String aTypename) {
        String typeName = aTypename;
        if (typeName.startsWith(UIMA_BUILTIN_JCAS_PREFIX)) {
            typeName = "uima." + typeName.substring(UIMA_BUILTIN_JCAS_PREFIX.length());
        } else if (FeatureStructure.class.getName().equals(aTypename)) {
            typeName = "uima.cas.TOP";
        } else if (AnnotationFS.class.getName().equals(aTypename)) {
            typeName = "uima.tcas.Annotation";
        }
        Type type = aCas.getTypeSystem().getType(typeName);
        if (type == null) {
            StringBuilder sb = new StringBuilder();
            Iterator<Type> i = aCas.getTypeSystem().getTypeIterator();
            while (i.hasNext()) {
                sb.append(i.next().getName()).append('\n');
            }
            throw new IllegalArgumentException("Undeclared type [" + aTypename + "]. Available types: " + sb);
        }
        return type;
    }

    public static Type getAnnotationType(CAS aCas, Class<?> aJCasClass) {
        Type type = CasUtil.getType(aCas, aJCasClass);
        if (!aCas.getTypeSystem().subsumes(aCas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + aJCasClass.getName() + "] is not an annotation type");
        }
        return type;
    }

    public static Type getAnnotationType(CAS aCas, String aTypeName) {
        Type type = CasUtil.getType(aCas, aTypeName);
        if (!aCas.getTypeSystem().subsumes(aCas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + aTypeName + "] is not an annotation type");
        }
        return type;
    }

    public static Collection<FeatureStructure> selectFS(ArrayFS array, Type type) {
        return FSCollectionFactory.create(array, type);
    }

    public static Collection<AnnotationFS> select(ArrayFS array, Type type) {
        CAS cas = array.getCAS();
        if (!cas.getTypeSystem().subsumes(cas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + type.getName() + "] is not an annotation type");
        }
        return FSCollectionFactory.create(array, type);
    }

    public static Collection<FeatureStructure> selectAllFS(CAS aCas) {
        return CasUtil.selectFS(aCas, CasUtil.getType(aCas, "uima.cas.TOP"));
    }

    public static Collection<FeatureStructure> selectFS(CAS cas, Type type) {
        return FSCollectionFactory.create(cas, type);
    }

    public static Collection<AnnotationFS> selectAll(CAS aCas) {
        return CasUtil.select(aCas, CasUtil.getType(aCas, "uima.tcas.Annotation"));
    }

    public static Collection<AnnotationFS> select(CAS cas, Type type) {
        if (!cas.getTypeSystem().subsumes(cas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + type.getName() + "] is not an annotation type");
        }
        return FSCollectionFactory.create(cas.getAnnotationIndex(type));
    }

    public static List<AnnotationFS> selectAt(CAS aCas, Type aType, int aBegin, int aEnd) {
        AnnotationFS a;
        ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
        FSIterator it = aCas.getAnnotationIndex(aType).iterator();
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < aBegin) {
            it.moveToNext();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getEnd() > aEnd) {
            it.moveToNext();
        }
        while (it.isValid() && (a = (AnnotationFS)it.get()).getBegin() == aBegin && a.getEnd() == aEnd) {
            it.moveToNext();
            list.add(a);
        }
        return list;
    }

    public static AnnotationFS selectSingleAt(CAS aCas, Type aType, int aBegin, int aEnd) {
        List<AnnotationFS> list = CasUtil.selectAt(aCas, aType, aBegin, aEnd);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("CAS does not contain any [" + aType.getName() + "] at [" + aBegin + "," + aEnd + "]");
        }
        if (list.size() > 1) {
            throw new IllegalArgumentException("CAS contains more than one [" + aType.getName() + "] at [" + aBegin + "," + aEnd + "]");
        }
        return list.get(0);
    }

    public static List<AnnotationFS> selectBetween(Type type, AnnotationFS ann1, AnnotationFS ann2) {
        return CasUtil.selectBetween(ann1.getView(), type, ann1, ann2);
    }

    public static List<AnnotationFS> selectBetween(CAS cas, Type type, AnnotationFS ann1, AnnotationFS ann2) {
        AnnotationFS a;
        AnnotationFS right;
        AnnotationFS left;
        if (ann1.getEnd() > ann2.getBegin()) {
            left = ann2;
            right = ann1;
        } else {
            left = ann1;
            right = ann2;
        }
        int begin = left.getEnd();
        int end = right.getBegin();
        ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
        FSIterator it = cas.getAnnotationIndex(type).iterator();
        it.moveTo(left);
        if (!it.isValid()) {
            it.moveToLast();
            if (!it.isValid()) {
                return list;
            }
        }
        boolean moved = false;
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() >= begin) {
            it.moveToPrevious();
            moved = true;
        }
        if (moved) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            it.moveToFirst();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < begin) {
            it.moveToNext();
        }
        boolean strict = true;
        while (it.isValid() && (a = (AnnotationFS)it.get()).getBegin() <= end) {
            it.moveToNext();
            if (strict && a.getEnd() > end) continue;
            assert (a.getBegin() >= left.getEnd()) : "Illegal begin " + a.getBegin() + " in [" + begin + ".." + end + "]";
            assert (a.getEnd() <= right.getBegin()) : "Illegal end " + a.getBegin() + " in [" + begin + ".." + end + "]";
            if (a.equals(left) || a.equals(right)) continue;
            list.add(a);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<AnnotationFS> selectCovered(Type type, AnnotationFS coveringAnnotation) {
        return CasUtil.selectCovered(coveringAnnotation.getView(), type, coveringAnnotation);
    }

    public static List<AnnotationFS> selectCovered(CAS cas, Type type, AnnotationFS coveringAnnotation) {
        AnnotationFS a;
        int begin = coveringAnnotation.getBegin();
        int end = coveringAnnotation.getEnd();
        ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
        FSIterator it = cas.getAnnotationIndex(type).iterator();
        it.moveTo(coveringAnnotation);
        if (!it.isValid()) {
            it.moveToLast();
            if (!it.isValid()) {
                return list;
            }
        }
        boolean moved = false;
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() >= begin) {
            it.moveToPrevious();
            moved = true;
        }
        if (moved) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            it.moveToFirst();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < begin) {
            it.moveToNext();
        }
        boolean strict = true;
        while (it.isValid() && (a = (AnnotationFS)it.get()).getBegin() <= end) {
            it.moveToNext();
            if (strict && a.getEnd() > end) continue;
            assert (a.getBegin() >= coveringAnnotation.getBegin()) : "Illegal begin " + a.getBegin() + " in [" + coveringAnnotation.getBegin() + ".." + coveringAnnotation.getEnd() + "]";
            assert (a.getEnd() <= coveringAnnotation.getEnd()) : "Illegal end " + a.getEnd() + " in [" + coveringAnnotation.getBegin() + ".." + coveringAnnotation.getEnd() + "]";
            if (a.equals(coveringAnnotation)) continue;
            list.add(a);
        }
        return Collections.unmodifiableList(list);
    }

    public static List<AnnotationFS> selectCovered(CAS cas, Type type, int begin, int end) {
        AnnotationFS a;
        ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
        FSIterator it = cas.getAnnotationIndex(type).iterator();
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < begin) {
            it.moveToNext();
        }
        boolean strict = true;
        while (it.isValid() && (a = (AnnotationFS)it.get()).getBegin() <= end) {
            it.moveToNext();
            if (strict && a.getEnd() > end) continue;
            assert (a.getBegin() >= begin) : "Illegal begin " + a.getBegin() + " in [" + begin + ".." + end + "]";
            assert (a.getEnd() <= end) : "Illegal end " + a.getEnd() + " in [" + begin + ".." + end + "]";
            list.add(a);
        }
        return list;
    }

    public static List<AnnotationFS> selectCovering(Type type, AnnotationFS coveredAnnotation) {
        return CasUtil.selectCovering(coveredAnnotation.getView(), type, coveredAnnotation.getBegin(), coveredAnnotation.getEnd());
    }

    public static List<AnnotationFS> selectCovering(CAS cas, Type type, AnnotationFS coveredAnnotation) {
        return CasUtil.selectCovering(cas, type, coveredAnnotation.getBegin(), coveredAnnotation.getEnd());
    }

    public static List<AnnotationFS> selectCovering(CAS cas, Type type, int begin, int end) {
        TypeSystem ts = cas.getTypeSystem();
        ArrayList<AnnotationFS> list = new ArrayList<AnnotationFS>();
        for (AnnotationFS a : cas.getAnnotationIndex()) {
            if (a.getBegin() > begin || a.getEnd() < end || type != null && !ts.subsumes(type, a.getType())) continue;
            list.add(a);
        }
        return list;
    }

    public static Map<AnnotationFS, Collection<AnnotationFS>> indexCovering(CAS cas, Type type, Type coveringType) {
        HashMap<AnnotationFS, Collection<AnnotationFS>> index = new HashMap<AnnotationFS, Collection<AnnotationFS>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Collection<AnnotationFS> get(Object paramObject) {
                Collection res = (Collection)super.get(paramObject);
                if (res == null) {
                    return Collections.emptyList();
                }
                return res;
            }
        };
        for (AnnotationFS s : CasUtil.select(cas, coveringType)) {
            for (AnnotationFS u : CasUtil.selectCovered(cas, type, s)) {
                LinkedList<AnnotationFS> c = (LinkedList<AnnotationFS>)index.get(u);
                if (c == Collections.EMPTY_LIST) {
                    c = new LinkedList<AnnotationFS>();
                    index.put(u, c);
                }
                c.add(s);
            }
        }
        return Collections.unmodifiableMap(index);
    }

    public static Map<AnnotationFS, Collection<AnnotationFS>> indexCovered(CAS cas, Type type, Type coveredType) {
        HashMap<AnnotationFS, Collection<AnnotationFS>> index = new HashMap<AnnotationFS, Collection<AnnotationFS>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Collection<AnnotationFS> get(Object paramObject) {
                Collection res = (Collection)super.get(paramObject);
                if (res == null) {
                    return Collections.emptyList();
                }
                return res;
            }
        };
        Collection<AnnotationFS> collType = CasUtil.select(cas, type);
        Collection<AnnotationFS> collCoveredType = CasUtil.select(cas, coveredType);
        AnnotationFS[] typeArray = collType.toArray(new AnnotationFS[collType.size()]);
        AnnotationFS[] coveredTypeArray = collCoveredType.toArray(new AnnotationFS[collCoveredType.size()]);
        ArrayDeque<AnnotationFS> memory = new ArrayDeque<AnnotationFS>();
        int o = 0;
        int i = 0;
        while (!(o >= typeArray.length && memory.isEmpty() || i >= coveredTypeArray.length)) {
            if (memory.isEmpty()) {
                memory.push(typeArray[o]);
                ++o;
            }
            AnnotationFS bottom = (AnnotationFS)memory.peek();
            AnnotationFS iFS = coveredTypeArray[i];
            while (i < coveredTypeArray.length - 1 && iFS.getBegin() < bottom.getBegin()) {
                iFS = coveredTypeArray[++i];
            }
            int iFSbegin = iFS.getBegin();
            int iFSend = iFS.getEnd();
            if (bottom.getBegin() <= iFS.getBegin()) {
                while (o < typeArray.length && typeArray[o].getBegin() <= iFSbegin) {
                    memory.push(typeArray[o]);
                    ++o;
                }
                for (AnnotationFS covering : memory) {
                    if (covering.getBegin() > iFSbegin || iFS.getEnd() > covering.getEnd()) continue;
                    LinkedList<AnnotationFS> c = (LinkedList<AnnotationFS>)index.get(covering);
                    if (c == Collections.EMPTY_LIST) {
                        c = new LinkedList<AnnotationFS>();
                        index.put(covering, c);
                    }
                    if (iFS == covering) continue;
                    c.add(iFS);
                }
                ++i;
            } else {
                ++i;
            }
            Iterator purgeIterator = memory.iterator();
            while (purgeIterator.hasNext()) {
                AnnotationFS purgeCandidate = (AnnotationFS)purgeIterator.next();
                if (purgeCandidate.getEnd() >= iFS.getBegin()) continue;
                purgeIterator.remove();
            }
        }
        return Collections.unmodifiableMap(index);
    }

    public static AnnotationFS selectByIndex(CAS cas, Type type, int index) {
        int n;
        if (!cas.getTypeSystem().subsumes(cas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + type.getName() + "] is not an annotation type");
        }
        FSIterator i = cas.getAnnotationIndex(type).iterator();
        i.moveToFirst();
        if (n > 0) {
            for (n = index; n > 0 && i.isValid(); --n) {
                i.moveToNext();
            }
        }
        if (n < 0) {
            i.moveToLast();
            while (n < -1 && i.isValid()) {
                i.moveToPrevious();
                ++n;
            }
        }
        return i.isValid() ? (AnnotationFS)i.get() : null;
    }

    public static FeatureStructure selectSingle(CAS cas, Type type) {
        FSIterator iterator = cas.getIndexRepository().getAllIndexedFS(type);
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("CAS does not contain any [" + type.getName() + "]");
        }
        FeatureStructure result = (FeatureStructure)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("CAS contains more than one [" + type.getName() + "]");
        }
        return result;
    }

    public static AnnotationFS selectSingleRelative(Type type, AnnotationFS annotation, int index) {
        return CasUtil.selectSingleRelative(annotation.getView(), type, annotation, index);
    }

    public static AnnotationFS selectSingleRelative(CAS cas, Type type, AnnotationFS aAnchor, int aPosition) {
        if (!cas.getTypeSystem().subsumes(cas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + type.getName() + "] is not an annotation type");
        }
        FSIterator itr = cas.getAnnotationIndex(type).iterator();
        itr.moveTo(aAnchor);
        if (aPosition < 0) {
            if (!itr.isValid()) {
                itr.moveToLast();
                if (!itr.isValid()) {
                    throw new IndexOutOfBoundsException("Reached end of index while seeking.");
                }
            }
            while (itr.isValid() && ((AnnotationFS)itr.get()).getEnd() > aAnchor.getBegin()) {
                itr.moveToPrevious();
            }
            for (int i = 0; i < -aPosition - 1 && itr.isValid(); ++i) {
                itr.moveToPrevious();
            }
            if (!itr.isValid()) {
                throw new IndexOutOfBoundsException("Reached end of index while seeking.");
            }
            return (AnnotationFS)itr.get();
        }
        if (aPosition > 0) {
            while (itr.isValid() && ((AnnotationFS)itr.get()).getBegin() < aAnchor.getEnd()) {
                itr.moveToNext();
            }
            for (int i = 0; i < aPosition - 1 && itr.isValid(); ++i) {
                itr.moveToPrevious();
            }
            if (!itr.isValid()) {
                throw new IndexOutOfBoundsException("Reached end of index while seeking.");
            }
            return (AnnotationFS)itr.get();
        }
        if (cas.getTypeSystem().subsumes(aAnchor.getType(), type)) {
            return aAnchor;
        }
        throw new IllegalArgumentException("Relative position cannot be 0 if the type of the anchor annotator does not subsume the selected type.");
    }

    public static List<AnnotationFS> selectPreceding(CAS cas, Type type, AnnotationFS annotation, int count) {
        if (!cas.getTypeSystem().subsumes(cas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + type.getName() + "] is not an annotation type");
        }
        LinkedList<AnnotationFS> precedingAnnotations = new LinkedList<AnnotationFS>();
        FSIterator itr = cas.getAnnotationIndex(type).iterator();
        itr.moveTo(annotation);
        if (!itr.isValid()) {
            itr.moveToLast();
            if (!itr.isValid()) {
                return precedingAnnotations;
            }
        }
        while (itr.isValid() && ((AnnotationFS)itr.get()).getEnd() > annotation.getBegin()) {
            itr.moveToPrevious();
        }
        int i = 0;
        while (i < count && itr.isValid()) {
            AnnotationFS cur = (AnnotationFS)itr.get();
            if (cur.getEnd() <= annotation.getBegin()) {
                precedingAnnotations.add((AnnotationFS)itr.get());
                ++i;
            }
            itr.moveToPrevious();
        }
        Collections.reverse(precedingAnnotations);
        return precedingAnnotations;
    }

    public static List<AnnotationFS> selectFollowing(CAS cas, Type type, AnnotationFS annotation, int count) {
        if (!cas.getTypeSystem().subsumes(cas.getAnnotationType(), type)) {
            throw new IllegalArgumentException("Type [" + type.getName() + "] is not an annotation type");
        }
        FSIterator itr = cas.getAnnotationIndex(type).iterator();
        itr.moveTo(annotation);
        while (itr.isValid() && ((AnnotationFS)itr.get()).getBegin() < annotation.getEnd()) {
            itr.moveToNext();
        }
        LinkedList<AnnotationFS> followingAnnotations = new LinkedList<AnnotationFS>();
        for (int i = 0; i < count && itr.isValid(); ++i) {
            followingAnnotations.add((AnnotationFS)itr.get());
            itr.moveToNext();
        }
        return followingAnnotations;
    }

    public static CAS getView(CAS cas, String viewName, CAS fallback) {
        CAS view;
        try {
            view = cas.getView(viewName);
        }
        catch (CASRuntimeException e) {
            view = fallback;
        }
        return view;
    }

    public static CAS getView(CAS cas, String viewName, boolean create) {
        CAS view;
        try {
            view = cas.getView(viewName);
        }
        catch (CASRuntimeException e) {
            if (create) {
                view = cas.createView(viewName);
            }
            throw new IllegalArgumentException("No view with name [" + viewName + "]");
        }
        return view;
    }

    public static <T extends AnnotationFS> List<String> toText(Iterable<T> iterable) {
        return CasUtil.toText(iterable.iterator());
    }

    public static <T extends AnnotationFS> List<String> toText(Iterator<T> iterator) {
        ArrayList<String> text = new ArrayList<String>();
        while (iterator.hasNext()) {
            AnnotationFS a = (AnnotationFS)iterator.next();
            text.add(a.getCoveredText());
        }
        return text;
    }
}

