/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.opennlpparser.main;

import de.julielab.jcore.ae.opennlpparser.utils.OffsetMapping;
import de.julielab.jcore.types.Constituent;
import de.julielab.jcore.types.GENIAConstituent;
import de.julielab.jcore.types.PTBConstituent;
import de.julielab.jcore.types.PennBioIEConstituent;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.util.Span;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseAnnotator.class);
    private static final String COMPONENT_ID = "de.julielab.jcore.ae.OpenNLPParser";
    private Parser parser;
    private String model;
    private String tagSet;
    private boolean useTagdict;
    private boolean caseSensitive;
    private int beamSize = 20;
    private double advancePercentage = 0.95;
    private boolean fun;
    private String[] mappings;
    private Hashtable<String, String> escMap = new Hashtable();
    private OffsetMapping offsetMap = new OffsetMapping();
    private Hashtable<String, String> mapTable = new Hashtable();
    private Hashtable<String, String> funTable = new Hashtable();

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        System.out.println("initializing OpenNLP Parse Annotator ...");
        super.initialize(aContext);
        this.model = (String)aContext.getConfigParameterValue("modelDir");
        this.tagSet = (String)aContext.getConfigParameterValue("tagset");
        this.useTagdict = (Boolean)aContext.getConfigParameterValue("useTagdict");
        this.caseSensitive = (Boolean)aContext.getConfigParameterValue("caseSensitive");
        this.fun = (Boolean)aContext.getConfigParameterValue("fun");
        this.mappings = (String[])aContext.getConfigParameterValue("mappings");
        this.loadMappings();
        if (aContext.getConfigParameterValue("beamSize") != null) {
            this.beamSize = (Integer)aContext.getConfigParameterValue("beamSize");
        }
        if (aContext.getConfigParameterValue("advancePercentage") != null) {
            this.advancePercentage = new Double((String)aContext.getConfigParameterValue("advancePercentage"));
        }
        this.initBracketMap();
        this.initFunMap();
        try {
            InputStream is;
            File modelFile = new File(this.model);
            if (!modelFile.exists()) {
                LOGGER.debug("File \"{}\" does not exist. Searching for the model as a classpath resource.", (Object)this.model);
                String resourceLocation = this.model.startsWith("/") ? this.model : "/" + this.model;
                is = this.getClass().getResourceAsStream(resourceLocation);
                if (is.equals(null)) {
                    throw new IllegalArgumentException("The model file \"" + this.model + "\" could be found neither in the file system nor in the classpath.");
                }
            } else {
                is = new FileInputStream(modelFile);
            }
            this.parser = ParserFactory.create(new ParserModel(is), this.beamSize, this.advancePercentage);
        }
        catch (IOException e) {
            LOGGER.error("[OpenNLP Parser] Could not load Parser models: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        LOGGER.info("[OpenNLP Parser]: processing  document...");
        ArrayList<Token> tokenList = new ArrayList<Token>();
        ArrayList<String> tokenTextList = new ArrayList<String>();
        ArrayList tagTextList = new ArrayList();
        AnnotationIndex sentenceIndex = aJCas.getJFSIndexRepository().getAnnotationIndex(Sentence.type);
        AnnotationIndex tokenIndex = aJCas.getJFSIndexRepository().getAnnotationIndex(Token.type);
        FSIterator sentenceIterator = sentenceIndex.iterator();
        StringBuffer senBuf = new StringBuffer();
        while (sentenceIterator.hasNext()) {
            senBuf.setLength(0);
            tokenList.clear();
            tokenTextList.clear();
            tagTextList.clear();
            Sentence sentence = (Sentence)sentenceIterator.next();
            int mapId = 0;
            FSIterator tokenIterator = tokenIndex.subiterator(sentence);
            while (tokenIterator.hasNext()) {
                Token token = (Token)tokenIterator.next();
                tokenList.add(token);
                String tokenText = this.escapeToken(token.getCoveredText());
                int start = senBuf.length();
                int end = start + tokenText.length();
                int origId = token.getBegin();
                for (mapId = start; mapId <= end; ++mapId) {
                    this.offsetMap.putMapping(mapId, origId);
                    if (origId >= token.getEnd()) continue;
                    ++origId;
                }
                senBuf.append(tokenText + " ");
                tokenTextList.add(tokenText);
            }
            StringBuffer line = new StringBuffer();
            Iterator i = tokenTextList.iterator();
            if (i.hasNext()) {
                while (i.hasNext()) {
                    line.append(i.next() + " ");
                }
                String line2parse = line.substring(0, line.length() - 1);
                Parse parse = new Parse(line2parse, new Span(0, line2parse.length()), "INC", 1.0, null);
                int tokenStart = 0;
                int tokenEnd = 0;
                for (String tok : tokenTextList) {
                    tokenEnd = tokenStart + tok.length();
                    parse.insert(new Parse(line2parse, new Span(tokenStart, tokenEnd), "TK", parse.getProb(), 0));
                    tokenStart = tokenEnd + 1;
                }
                try {
                    parse = this.parser.parse(parse);
                    this.annotate(parse, aJCas, null);
                }
                catch (Exception e) {
                    LOGGER.error("process()", e);
                }
                continue;
            }
            LOGGER.warn("process() - No tokens available in sentence");
        }
    }

    private void loadMappings() {
        for (int i = 0; i < this.mappings.length; ++i) {
            String[] pair = this.mappings[i].split(";");
            if (pair.length < 2) {
                try {
                    throw new AnnotatorConfigurationException();
                }
                catch (AnnotatorConfigurationException e) {
                    LOGGER.error("[OpenNLP Parser: ]" + e.getMessage());
                    continue;
                }
            }
            String consTag = pair[0];
            String casTag = pair[1];
            this.mapTable.put(consTag, casTag);
        }
    }

    private void annotate(Parse parse, JCas cas, Constituent parent) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constituent cons = null;
        Span span = parse.getSpan();
        String label = parse.getType();
        String[] funCatlabels = null;
        if (!label.equals("TK")) {
            String labelCat;
            int start = this.offsetMap.getMapping(span.getStart());
            int end = this.offsetMap.getMapping(span.getEnd());
            if (this.fun && label.contains("-")) {
                funCatlabels = label.split("-");
                labelCat = funCatlabels[0];
            } else {
                labelCat = label;
            }
            String casLabel = this.mapTable.get(labelCat);
            if (casLabel != null) {
                cons = (Constituent)JCoReAnnotationTools.getAnnotationByClassName(cas, this.tagSet);
                cons.setBegin(start);
                cons.setEnd(end);
                cons.setComponentId(COMPONENT_ID);
                cons.setCat(casLabel);
                Class<?> c = cons.getClass();
                this.makeFunAnnotations(cons, funCatlabels);
                if (parent != null) {
                    cons.setParent(parent);
                }
                cons.addToIndexes();
                try {
                    this.addHeadAnnotation(cons, parse.getHead().getSpan());
                }
                catch (CASRuntimeException e) {
                    e.printStackTrace();
                }
                catch (CASException e) {
                    e.printStackTrace();
                }
            }
            Parse[] children = parse.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.annotate(children[i], cas, cons);
            }
        }
    }

    private void addHeadAnnotation(Constituent cons, Span headSpan) throws CASRuntimeException, CASException {
        FSIterator tokens = cons.getCAS().getJCas().getAnnotationIndex(Token.type).subiterator(cons);
        int headStart = this.offsetMap.getMapping(headSpan.getStart());
        int headEnd = this.offsetMap.getMapping(headSpan.getEnd());
        while (tokens.hasNext()) {
            Token token = (Token)tokens.next();
            if (token.getBegin() != headStart || token.getEnd() != headEnd) continue;
            cons.setHead(token);
            tokens.moveToLast();
            tokens.next();
        }
    }

    private void makeFunAnnotations(Constituent cons, String[] funCatLabels) {
        if (funCatLabels != null && funCatLabels.length > 1) {
            for (int i = 1; i < funCatLabels.length; ++i) {
                String labeltype = this.funTable.get(funCatLabels[i]);
                if (labeltype == null) continue;
                Class<?> c = cons.getClass();
                if (labeltype.equals("formFuncDisc")) {
                    if (c.equals(GENIAConstituent.class)) {
                        ((GENIAConstituent)cons).setFormFuncDisc(funCatLabels[i]);
                    }
                    if (c.equals(PennBioIEConstituent.class)) {
                        ((PennBioIEConstituent)cons).setFormFuncDisc(funCatLabels[i]);
                    }
                    if (c.equals(PTBConstituent.class)) {
                        ((PTBConstituent)cons).setFormFuncDisc(funCatLabels[i]);
                    }
                }
                if (labeltype.equals("gramRole")) {
                    if (c.equals(GENIAConstituent.class)) {
                        ((GENIAConstituent)cons).setGramRole(funCatLabels[i]);
                    }
                    if (c.equals(PennBioIEConstituent.class)) {
                        ((PennBioIEConstituent)cons).setGramRole(funCatLabels[i]);
                    }
                    if (c.equals(PTBConstituent.class)) {
                        ((PTBConstituent)cons).setGramRole(funCatLabels[i]);
                    }
                }
                if (labeltype.equals("adv")) {
                    if (c.equals(GENIAConstituent.class)) {
                        ((GENIAConstituent)cons).setAdv(funCatLabels[i]);
                    }
                    if (c.equals(PennBioIEConstituent.class)) {
                        ((PennBioIEConstituent)cons).setAdv(funCatLabels[i]);
                    }
                    if (c.equals(PTBConstituent.class)) {
                        ((PTBConstituent)cons).setAdv(funCatLabels[i]);
                    }
                }
                if (labeltype.equals("misc")) {
                    if (c.equals(GENIAConstituent.class)) {
                        ((GENIAConstituent)cons).setMisc(funCatLabels[i]);
                    }
                    if (c.equals(PennBioIEConstituent.class)) {
                        ((PennBioIEConstituent)cons).setMisc(funCatLabels[i]);
                    }
                    if (c.equals(PTBConstituent.class)) {
                        ((PTBConstituent)cons).setMisc(funCatLabels[i]);
                    }
                }
                if (!labeltype.equals("syn") || !c.equals(GENIAConstituent.class)) continue;
                ((GENIAConstituent)cons).setSyn(funCatLabels[i]);
            }
        }
    }

    private void initBracketMap() {
        this.escMap.put("(", "-LRB-");
        this.escMap.put(")", "-RRB-");
        this.escMap.put("{", "-LCB-");
        this.escMap.put("}", "-RCB-");
        this.escMap.put("[", "-LSB-");
        this.escMap.put("]", "-RSB-");
    }

    private void initFunMap() {
        this.funTable.put("ADV", "formFuncDisc");
        this.funTable.put("NOM", "formFuncDisc");
        this.funTable.put("DTV", "gramRole");
        this.funTable.put("LGS", "gramRole");
        this.funTable.put("PRD", "gramRole");
        this.funTable.put("PUT", "gramRole");
        this.funTable.put("SBJ", "gramRole");
        this.funTable.put("VOC", "gramRole");
        this.funTable.put("BNF", "adv");
        this.funTable.put("DIR", "adv");
        this.funTable.put("EXT", "adv");
        this.funTable.put("LOC", "adv");
        this.funTable.put("MNR", "adv");
        this.funTable.put("PRP", "adv");
        this.funTable.put("TMP", "adv");
        this.funTable.put("CLR", "misc");
        this.funTable.put("CLF", "misc");
        this.funTable.put("HLN", "misc");
        this.funTable.put("TTL", "misc");
        this.funTable.put("COOD", "syn");
    }

    private String escapeToken(String token) {
        String newToken = this.escMap.get(token);
        if (newToken == null) {
            return token;
        }
        return newToken;
    }
}

