/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.opennlp.chunk.convert;

import de.julielab.jcore.ae.opennlp.chunk.convert.GeniaTreebankXMLHandler;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeniaTreebankToOpenNLPChunkFormat {
    public static void main(String[] args) {
        File inputDir;
        if (args.length != 2) {
            System.err.println("Usage: GeniaTreebankToOpenNLPChunkFormat <inputDir> <outputFile>");
            System.exit(-1);
        }
        if (!(inputDir = new File(args[0])).exists()) {
            System.err.println(inputDir.getAbsolutePath() + " does not exist!");
            System.exit(-1);
        }
        if (!inputDir.isDirectory()) {
            System.err.println(inputDir.getAbsolutePath() + " is not a directory!");
            System.exit(-1);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Error while instantiating the SAX Parser.");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SAXException e) {
            System.err.println("Error while instantiating the SAX Parser.");
            e.printStackTrace();
            System.exit(-1);
        }
        File out = new File(args[1]);
        if (out.exists() && out.isDirectory()) {
            System.err.println(out.getAbsolutePath() + " already exists and is a directory.");
            System.exit(-1);
        }
        if (out.exists()) {
            Scanner reader = new Scanner(System.in);
            System.out.println(out.getAbsolutePath() + " (output file) already exists. Overwrite? y / n");
            String answer = reader.next();
            if (!answer.equalsIgnoreCase("Y") && !answer.equalsIgnoreCase("YES")) {
                System.out.println("File will not be overwritten. Converter terminates now.");
                System.exit(0);
            }
            if (!out.delete()) {
                System.err.println("Old output file could not be deleted.");
                System.exit(-1);
            }
        }
        try {
            out.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.err.println("Error while creating a new output file.");
            System.exit(-1);
        }
        GeniaTreebankXMLHandler handler = new GeniaTreebankXMLHandler(args[1]);
        for (File currentFile : inputDir.listFiles()) {
            String type;
            int indexOfDot = currentFile.getName().lastIndexOf(".");
            if (indexOfDot <= -1 || !(type = currentFile.getName().substring(indexOfDot + 1)).equals("xml")) continue;
            System.out.println("Converting " + currentFile.getName() + " ...");
            try {
                parser.parse(currentFile, (DefaultHandler)handler);
            }
            catch (SAXException e) {
                System.err.println("Error while parsing input xml file.");
                e.printStackTrace();
                System.exit(-1);
            }
            catch (IOException e) {
                System.err.println("Error while writing to output file.");
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }
}

