/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.opennlp.chunk.convert;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeniaTreebankXMLHandler
extends DefaultHandler {
    private final int BEGIN = 0;
    private final int IN = 1;
    private final int OUT = 2;
    private int currentState = 2;
    private boolean inToken = false;
    private String currentPOS = "";
    private Stack<String> consCatStack = new Stack();
    private StringBuilder sb = new StringBuilder();
    private File outputFile = null;

    public GeniaTreebankXMLHandler(String out) {
        this.outputFile = new File(out);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String cat;
        if (qName.equals("cons") && (cat = attributes.getValue("cat")) != null && !cat.equals("")) {
            this.currentState = 0;
            this.consCatStack.push(cat);
        }
        if (qName.equals("tok") && (cat = attributes.getValue("cat")) != null && !cat.equals("")) {
            this.inToken = true;
            this.currentPOS = cat;
            if (this.currentPOS.equals("PERIOD")) {
                this.currentPOS = ".";
            } else if (this.currentPOS.equals("COMMA")) {
                this.currentPOS = ",";
            }
        }
        if (qName.equals("sentence")) {
            this.consCatStack = new Stack();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("cons")) {
            this.consCatStack.pop();
            this.currentState = this.consCatStack.isEmpty() || this.consCatStack.peek().equals("S") ? 2 : 0;
        }
        if (qName.equals("tok")) {
            this.inToken = false;
            this.currentPOS = "";
        }
        if (qName.equals("sentence")) {
            this.currentState = 2;
            this.sb.append("\n");
        }
        if (qName.equals("Annotation")) {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(this.outputFile));
                writer.append(this.sb.toString());
                writer.close();
            }
            catch (IOException e) {
                System.err.println("Error while writing to output file " + this.outputFile.getAbsolutePath() + ".");
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inToken) {
            this.sb.append(new String(ch, start, length).replaceAll("\\s+", ""));
            this.sb.append(" ");
            this.sb.append(this.currentPOS.replaceAll("\\s+", ""));
            this.sb.append(" ");
            if (this.currentState == 2) {
                this.sb.append("O\n");
            } else {
                if (this.currentState == 0) {
                    this.sb.append("B-");
                    this.currentState = 1;
                } else {
                    this.sb.append("I-");
                }
                this.sb.append(this.consCatStack.peek().replaceAll("\\s+", ""));
                this.sb.append("\n");
            }
        }
    }
}

