/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.opennlp.chunk;

import de.julielab.jcore.types.Chunk;
import de.julielab.jcore.types.ChunkADJP;
import de.julielab.jcore.types.ChunkADVP;
import de.julielab.jcore.types.ChunkCONJP;
import de.julielab.jcore.types.ChunkLST;
import de.julielab.jcore.types.ChunkNP;
import de.julielab.jcore.types.ChunkPP;
import de.julielab.jcore.types.ChunkPRT;
import de.julielab.jcore.types.ChunkSBAR;
import de.julielab.jcore.types.ChunkVP;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkAnnotator.class);
    private static final String COMPONENT_ID = "de.julielab.jcore.ae.OpenNLPChunker";
    private ChunkerME chunker;
    private static String posTagSetPreference;
    private static String[] mappings;
    private static Map<String, String> mappingsTable;
    private static Map<String, Integer> defaultChunkTagMap;
    private static String[] DEFAULT_CHUNK_TAGS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        InputStream is;
        LOGGER.info("initializing OpenNLP Chunk Annotator ...");
        super.initialize(aContext);
        String modelFileName = "";
        Object o = aContext.getConfigParameterValue("modelFile");
        if (o == null) {
            LOGGER.error("[OpenNLP Chunk Annotator] descriptor incomplete, no model file specified!");
            throw new ResourceInitializationException();
        }
        modelFileName = (String)o;
        String posTagSetPreference = "";
        Object o2 = aContext.getConfigParameterValue("posTagSetPref");
        if (o2 == null) {
            LOGGER.error("[OpenNLP Chunk Annotator] descriptor incomplete, posTagSetPref not specified!");
            throw new ResourceInitializationException();
        }
        posTagSetPreference = (String)o2;
        mappings = (String[])aContext.getConfigParameterValue("mappings");
        if (mappings != null && mappings.length > 0) {
            try {
                this.loadMappings();
            }
            catch (AnnotatorConfigurationException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        } else {
            this.loadDefaultChunkTagMap();
            LOGGER.info("[OpenNLP Chunk Annotator] Working with default mappings in getChunk()");
        }
        LOGGER.debug("[OpenNLP Chunk Annotator] Reading sentence model...");
        File modelFile = new File(modelFileName);
        if (!modelFile.exists()) {
            String resourceLocation = modelFileName.startsWith("/") ? modelFileName : "/" + modelFileName;
            is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceLocation);
        } else {
            try {
                is = new FileInputStream(modelFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("[OpenNLP Chunk Annotator] Sentence model {} not found.", (Object)modelFile.getAbsolutePath());
                throw new ResourceInitializationException();
            }
        }
        try {
            ChunkerModel chunkerModel = new ChunkerModel(is);
            this.chunker = new ChunkerME(chunkerModel);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("[OpenNLP Chunk Annotator] Error while opening chunk model {}. . Sentence Annotations will not be done.", (Object)modelFile);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadDefaultChunkTagMap() {
        defaultChunkTagMap = new HashMap<String, Integer>();
        int i = 0;
        for (String chunkTag : DEFAULT_CHUNK_TAGS) {
            defaultChunkTagMap.put(chunkTag, i);
            ++i;
        }
    }

    private void loadMappings() throws AnnotatorConfigurationException {
        mappingsTable = new HashMap<String, String>();
        for (int i = 0; i < mappings.length; ++i) {
            String[] pair = mappings[i].split(";");
            if (pair.length != 2) {
                throw new AnnotatorConfigurationException();
            }
            String chunkTag = pair[0];
            String classTag = pair[1];
            mappingsTable.put(chunkTag, classTag);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        LOGGER.debug("[OpenNLP Chunk Annotator] processing document ...");
        JFSIndexRepository indexes = aJCas.getJFSIndexRepository();
        AnnotationIndex sentenceIndex = indexes.getAnnotationIndex(Sentence.type);
        AnnotationIndex tokenIndex = indexes.getAnnotationIndex(Token.type);
        for (Sentence sentence : sentenceIndex) {
            FSIterator tokenIterator = tokenIndex.subiterator((AnnotationFS)sentence);
            int numTokens = 0;
            while (tokenIterator.isValid()) {
                ++numTokens;
                tokenIterator.moveToNext();
            }
            tokenIterator.moveToFirst();
            Token[] tokenArray = new Token[numTokens];
            String[] tokenTextArray = new String[numTokens];
            String[] tagArray = new String[numTokens];
            int i = 0;
            while (tokenIterator.hasNext()) {
                Token token;
                tokenArray[i] = token = (Token)tokenIterator.next();
                tokenTextArray[i] = token.getCoveredText();
                POSTag postag = null;
                if (posTagSetPreference != null) {
                    postag = this.getPrefPOSTag(token);
                }
                if (postag == null) {
                    postag = token.getPosTag(0);
                }
                if (postag == null) {
                    LOGGER.error("Token has no POS tag annotation: " + token.getCoveredText());
                    throw new AnalysisEngineProcessException();
                }
                tagArray[i] = postag.getValue();
                ++i;
            }
            String[] chunks = this.chunker.chunk(tokenTextArray, tagArray);
            this.createChunkAnnotations(chunks, tokenArray, aJCas);
        }
    }

    private void createChunkAnnotations(String[] chunks, Token[] tokenArray, JCas aJCas) throws AnalysisEngineProcessException {
        Chunk chunkAnnotation = null;
        boolean inChunk = false;
        for (int index = 0; index < chunks.length; ++index) {
            if (chunks[index].charAt(0) == 'B') {
                if (inChunk) {
                    chunkAnnotation.setEnd(tokenArray[index - 1].getEnd());
                    chunkAnnotation.addToIndexes();
                }
                String chunkType = chunks[index].substring(2);
                chunkAnnotation = this.getChunk(chunkType, aJCas);
                chunkAnnotation.setComponentId(COMPONENT_ID);
                chunkAnnotation.setBegin(tokenArray[index].getBegin());
                inChunk = true;
                continue;
            }
            if (chunks[index].charAt(0) != 'O' && index + 1 != chunks.length) continue;
            if (inChunk) {
                chunkAnnotation.setEnd(tokenArray[index].getEnd());
                chunkAnnotation.addToIndexes();
            }
            inChunk = false;
        }
    }

    private Chunk getChunk(String chunkValue, JCas aJCas) throws AnalysisEngineProcessException {
        ChunkNP chunk = null;
        if (mappings == null || mappings.length == 0) {
            Integer value = defaultChunkTagMap.get(chunkValue);
            if (value == null) {
                value = DEFAULT_CHUNK_TAGS.length;
            }
            switch (value) {
                case 0: {
                    chunk = new ChunkNP(aJCas);
                    break;
                }
                case 1: {
                    chunk = new ChunkPP(aJCas);
                    break;
                }
                case 2: {
                    chunk = new ChunkVP(aJCas);
                    break;
                }
                case 3: {
                    chunk = new ChunkADJP(aJCas);
                    break;
                }
                case 4: {
                    chunk = new ChunkCONJP(aJCas);
                    break;
                }
                case 5: {
                    chunk = new ChunkLST(aJCas);
                    break;
                }
                case 6: {
                    chunk = new ChunkSBAR(aJCas);
                    break;
                }
                case 7: {
                    chunk = new ChunkPRT(aJCas);
                    break;
                }
                case 8: {
                    chunk = new ChunkADVP(aJCas);
                    break;
                }
                default: {
                    chunk = new Chunk(aJCas);
                    LOGGER.debug("Chunk type " + chunkValue + " is not in the list of predefined mappings.");
                    break;
                }
            }
        } else {
            try {
                String className = mappingsTable.get(chunkValue);
                if (className != null) {
                    Class<?> myNewClass = Class.forName(className);
                    Constructor<?> myConstructor = myNewClass.getConstructor(JCas.class);
                    chunk = (Chunk)myConstructor.newInstance(aJCas);
                } else {
                    chunk = new Chunk(aJCas);
                    LOGGER.debug("Chunk " + chunkValue + " is not in mapping file.");
                }
            }
            catch (SecurityException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("[OpenNLP Chunk Annotator]" + e.getMessage());
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
        return chunk;
    }

    private POSTag getPrefPOSTag(Token token) {
        FSArray posTags = token.getPosTag();
        for (int i = 0; i < posTags.size(); ++i) {
            POSTag posTag = (POSTag)posTags.get(i);
            if (posTag == null || !posTag.getType().getName().equals(posTagSetPreference)) continue;
            return posTag;
        }
        return null;
    }

    static {
        DEFAULT_CHUNK_TAGS = new String[]{"NP", "PP", "VP", "ADJP", "CONJP", "LST", "SBAR", "PRT", "ADVP"};
    }
}

