/*
 * Decompiled with CFR 0.152.
 */
package edu.uchsc.ccp.nlp.ei.mutation;

import edu.uchsc.ccp.nlp.ei.mutation.Mutation;
import edu.uchsc.ccp.nlp.ei.mutation.MutationException;
import edu.uchsc.ccp.nlp.ei.mutation.MutationFinder;
import java.util.HashMap;
import java.util.Map;

public class PointMutation
extends Mutation {
    private Map<String, String> abbreviationLookup;
    private char wtResidue;
    private char mutResidue;

    public PointMutation(int position, String wtResidue, String mutResidue) throws MutationException {
        super(position);
        this.initialize(wtResidue, mutResidue);
    }

    public PointMutation(String position, String wtResidue, String mutResidue) throws MutationException {
        super(position);
        this.initialize(wtResidue, mutResidue);
    }

    private void initialize(String wtResidue, String mutResidue) throws MutationException {
        this.abbreviationLookup = this.populateAminoAcidOneToOneLookupMap();
        this.updateMapping(this.abbreviationLookup, MutationFinder.populateAminoAcidThreeToOneLookupMap());
        this.updateMapping(this.abbreviationLookup, MutationFinder.populateAminoAcidNameToOneLookupMap());
        this.wtResidue = this.normalizeResidueIdentity(wtResidue);
        this.mutResidue = this.normalizeResidueIdentity(mutResidue);
    }

    public char normalizeResidueIdentity(String residue) throws MutationException {
        if (this.abbreviationLookup.containsKey(residue = residue.toUpperCase())) {
            return this.abbreviationLookup.get(residue).charAt(0);
        }
        throw new MutationException("Input residue not recognized, must be a standard residue: " + residue);
    }

    protected Map<String, String> populateAminoAcidOneToOneLookupMap() {
        HashMap<String, String> amino_acid_three_to_one_map = new HashMap<String, String>();
        amino_acid_three_to_one_map = new HashMap();
        amino_acid_three_to_one_map.put("A", "A");
        amino_acid_three_to_one_map.put("G", "G");
        amino_acid_three_to_one_map.put("L", "L");
        amino_acid_three_to_one_map.put("M", "M");
        amino_acid_three_to_one_map.put("F", "F");
        amino_acid_three_to_one_map.put("W", "W");
        amino_acid_three_to_one_map.put("K", "K");
        amino_acid_three_to_one_map.put("Q", "Q");
        amino_acid_three_to_one_map.put("E", "E");
        amino_acid_three_to_one_map.put("S", "S");
        amino_acid_three_to_one_map.put("P", "P");
        amino_acid_three_to_one_map.put("V", "V");
        amino_acid_three_to_one_map.put("I", "I");
        amino_acid_three_to_one_map.put("C", "C");
        amino_acid_three_to_one_map.put("Y", "Y");
        amino_acid_three_to_one_map.put("H", "H");
        amino_acid_three_to_one_map.put("R", "R");
        amino_acid_three_to_one_map.put("N", "N");
        amino_acid_three_to_one_map.put("D", "D");
        amino_acid_three_to_one_map.put("T", "T");
        return amino_acid_three_to_one_map;
    }

    public char getMutResidue() {
        return this.mutResidue;
    }

    public char getWtResidue() {
        return this.wtResidue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PointMutation) {
            PointMutation pm = (PointMutation)obj;
            return this.getPosition() == pm.getPosition() && this.getWtResidue() == pm.getWtResidue() && this.getMutResidue() == pm.getMutResidue();
        }
        this.error("Invalid comparision. Trying to compare a PointMutation with: " + obj.getClass().getName());
        return false;
    }

    @Override
    public int hashCode() {
        return (this.getClass().getName() + this.toString()).hashCode();
    }

    @Override
    public String toString() {
        return this.getWtResidue() + Integer.toString(this.getPosition()) + this.getMutResidue();
    }

    public static PointMutation createPointMutationFrom_wNm(String wNm) throws MutationException {
        try {
            PointMutation pm = new PointMutation(Integer.parseInt(wNm.substring(1, wNm.length() - 1)), Character.toString(wNm.charAt(0)), Character.toString(wNm.charAt(wNm.length() - 1)));
            return pm;
        }
        catch (Exception e) {
            throw new MutationException("Improperly formatted mutation mention: " + wNm);
        }
    }
}

