/*
 * Decompiled with CFR 0.152.
 */
package edu.uchsc.ccp.nlp.ei.mutation;

import edu.uchsc.ccp.nlp.ei.mutation.Mutation;
import edu.uchsc.ccp.nlp.ei.mutation.MutationException;
import edu.uchsc.ccp.nlp.ei.mutation.MutationExtractor;
import edu.uchsc.ccp.nlp.ei.mutation.PointMutation;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationFinder
extends MutationExtractor {
    protected static final String MUT_RES = "?P<mut_res>";
    protected static final String WT_RES = "?P<wt_res>";
    protected static final String POS = "?P<pos>";
    private static final Logger log = LoggerFactory.getLogger(MutationFinder.class);
    private final String CASE_SENSITIVE = "[CASE_SENSITIVE]";
    private Map<org.apache.oro.text.regex.Pattern, Map<String, Integer>> regular_expressions;

    public MutationFinder(String fileName) {
        File file = new File(fileName);
        this.loadRegularExpressionsFromFile(file);
    }

    public MutationFinder(InputStream is) throws IOException {
        this.loadRegularExpressionsFromStream(is);
    }

    public MutationFinder(File file) {
        this.loadRegularExpressionsFromFile(file);
    }

    public MutationFinder(Set<String> unprocessed_python_regexes) {
        this.regular_expressions = new HashMap<org.apache.oro.text.regex.Pattern, Map<String, Integer>>();
        for (String python_regex : unprocessed_python_regexes) {
            this.processPythonRegex(python_regex);
        }
    }

    public static Map<String, Integer> extractMappingsFromPythonRegex(String pythonRegex) {
        HashMap<String, Integer> groupMappings = new HashMap<String, Integer>();
        groupMappings.put(MUT_RES, MutationFinder.countRegExParenthesesBeforeIndex(pythonRegex, pythonRegex.indexOf(MUT_RES)));
        groupMappings.put(WT_RES, MutationFinder.countRegExParenthesesBeforeIndex(pythonRegex, pythonRegex.indexOf(WT_RES)));
        groupMappings.put(POS, MutationFinder.countRegExParenthesesBeforeIndex(pythonRegex, pythonRegex.indexOf(POS)));
        return groupMappings;
    }

    public static String removeTagsFromPythonRegex(String regexStr) {
        return regexStr.replaceAll("\\?P<mut_res>", "").replaceAll("\\?P<wt_res>", "").replaceAll("\\?P<pos>", "");
    }

    private static int countRegExParenthesesBeforeIndex(String regexStr, int index) {
        Pattern p = Pattern.compile("[^\\\\]\\(");
        Matcher m = p.matcher(regexStr);
        int count = 0;
        int currentIndex = -1;
        while (m.find() && currentIndex < index) {
            ++count;
            currentIndex = m.start();
        }
        return count;
    }

    public static void main(String[] args) {
        try {
            if (args.length == 3) {
                String line;
                String regularExpressionFile = args[0];
                String inputFileLocation = args[1];
                String outputFileLocation = args[2];
                System.out.print("Initializing MutationFinder...");
                MutationFinder mf = new MutationFinder(regularExpressionFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inputFileLocation)));
                PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFileLocation)));
                while ((line = br.readLine()) != null) {
                    int firstTabIndex = line.indexOf("\t");
                    String id = line.substring(0, firstTabIndex);
                    String text = line.substring(firstTabIndex + 1);
                    Object outputLine = id;
                    Map<Mutation, Set<int[]>> mutations = mf.extractMutations(text);
                    for (Mutation mutation : mutations.keySet()) {
                        for (int i = 0; i < mutations.get(mutation).size(); ++i) {
                            outputLine = (String)outputLine + "\t" + ((PointMutation)mutation).toString();
                        }
                    }
                    ps.println((String)outputLine);
                }
                br.close();
                ps.close();
            } else {
                System.err.println("ERROR: Invalid number of input parameters. Execution of MutationFinder requires three input parameters.");
                System.err.println("USAGE: MutationFinder regularExpressionFile inputFile outputFile");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processPythonRegex(String regexStr) {
        Map<String, Integer> groupMappings = MutationFinder.extractMappingsFromPythonRegex(regexStr);
        regexStr = MutationFinder.removeTagsFromPythonRegex(regexStr);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            if (regexStr.endsWith("[CASE_SENSITIVE]")) {
                this.regular_expressions.put(compiler.compile(regexStr.substring(0, regexStr.lastIndexOf(91))), groupMappings);
            } else {
                this.regular_expressions.put(compiler.compile(regexStr, 1), groupMappings);
            }
        }
        catch (MalformedPatternException mpe) {
            mpe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRegularExpressionsFromFile(File file) {
        this.regular_expressions = new HashMap<org.apache.oro.text.regex.Pattern, Map<String, Integer>>();
        BufferedReader br = null;
        int count = 0;
        try {
            String line;
            FileReader fr = new FileReader(file);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                this.processPythonRegex(line);
                if (++count % 100 != 0) continue;
                System.err.println("Loading regex's: " + count);
            }
        }
        catch (FileNotFoundException fnfe) {
            this.error("The file containing regular expressions could not be found: " + file.getAbsolutePath() + File.separator + file.getName());
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            this.error("IO Exception while processing regular expression file.");
            ioe.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception fnfe) {}
            }
        }
        System.err.println("Completed loading of regular expressions: " + this.regular_expressions.size() + " loaded.");
    }

    private void loadRegularExpressionsFromStream(InputStream inputStream) throws IOException {
        this.regular_expressions = new HashMap<org.apache.oro.text.regex.Pattern, Map<String, Integer>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
            br.lines().filter(l -> !l.startsWith("#")).forEach(this::processPythonRegex);
        }
        System.err.println("Completed loading of regular expressions from input stream: " + this.regular_expressions.size() + " loaded.");
    }

    private void postProcess(Map<Mutation, Set<int[]>> mutations) {
        ArrayList<PointMutation> mutationsToDelete = new ArrayList<PointMutation>();
        for (Mutation mutation : mutations.keySet()) {
            PointMutation pm;
            if (!(mutation instanceof PointMutation) || (pm = (PointMutation)mutation).getWtResidue() != pm.getMutResidue()) continue;
            mutationsToDelete.add(pm);
        }
        for (Mutation mutation : mutationsToDelete) {
            mutations.remove(mutation);
        }
    }

    @Override
    public Map<Mutation, Set<int[]>> extractMutations(String rawText) throws MutationException {
        HashMap<Mutation, Set<int[]>> extractedMutations = new HashMap<Mutation, Set<int[]>>();
        for (org.apache.oro.text.regex.Pattern pattern : this.regular_expressions.keySet()) {
            Perl5Matcher m = new Perl5Matcher();
            PatternMatcherInput input = new PatternMatcherInput(rawText);
            Map<String, Integer> groupMappings = this.regular_expressions.get(pattern);
            while (m.contains(input, pattern)) {
                int pos_group = groupMappings.get(POS);
                int wtres_group = groupMappings.get(WT_RES);
                int mutres_group = groupMappings.get(MUT_RES);
                MatchResult result = m.getMatch();
                try {
                    PointMutation pm = new PointMutation(Integer.parseInt(result.group(pos_group)), result.group(wtres_group), result.group(mutres_group));
                    int[] span = new int[]{Math.min(result.beginOffset(pos_group), Math.min(result.beginOffset(wtres_group), result.beginOffset(mutres_group))), Math.max(result.endOffset(pos_group), Math.max(result.endOffset(wtres_group), result.endOffset(mutres_group)))};
                    if (extractedMutations.containsKey(pm)) {
                        ((Set)extractedMutations.get(pm)).add(span);
                        continue;
                    }
                    HashSet<int[]> spans = new HashSet<int[]>();
                    spans.add(span);
                    extractedMutations.put(pm, spans);
                }
                catch (NumberFormatException e) {
                    log.debug("Caught a NumberFormatException when trying to create a new PointMutation instance. This is probably due to trying to parse a number into an integer that is actually larger than an integer. The respective mutation is skipped.", (Throwable)e);
                }
            }
        }
        this.postProcess(extractedMutations);
        return extractedMutations;
    }
}

