/*
 * Decompiled with CFR 0.152.
 */
package edu.uchsc.ccp.nlp.ei.mutation;

import edu.uchsc.ccp.nlp.ei.mutation.MutationException;
import java.util.Map;

public class Mutation {
    private int position;

    public Mutation(int position) throws MutationException {
        this.position = position;
        this.checkPosition();
    }

    public Mutation(String position) throws MutationException {
        try {
            this.position = Integer.parseInt(position);
        }
        catch (NumberFormatException nfe) {
            throw new MutationException("Invalid position: " + position);
        }
        this.checkPosition();
    }

    private void checkPosition() throws MutationException {
        if (this.position < 1) {
            throw new MutationException("Position must be greater than 0");
        }
    }

    public int getPosition() {
        return this.position;
    }

    protected void updateMapping(Map<String, String> inputMap, Map<String, String> additionalMappings) {
        for (String key : additionalMappings.keySet()) {
            if (!inputMap.containsKey(key)) {
                inputMap.put(key, additionalMappings.get(key));
                continue;
            }
            this.warn("Key already exists, original value retained while updating a mapping: " + key + " Old value: " + inputMap.get(key) + " Attempted new value: " + additionalMappings.get(key));
        }
    }

    protected void warn(String message) {
        System.err.println("WARNING -- " + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46)) + message);
    }

    protected void error(String message) {
        System.err.println("ERROR -- " + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46)) + message);
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        throw new UnsupportedOperationException();
    }
}

