/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser.io;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.Util;
import edu.upenn.seas.mstparser.io.DependencyWriter;
import java.io.IOException;

public class MSTWriter
extends DependencyWriter {
    public MSTWriter(boolean labeled) {
        this.labeled = labeled;
    }

    @Override
    public String write(DependencyInstance instance, boolean fileAccess) throws IOException {
        StringBuilder b = new StringBuilder();
        b.append(Util.join(instance.forms, '\t')).append("\n");
        b.append(Util.join(instance.postags, '\t')).append("\n");
        if (this.labeled) {
            b.append(Util.join(instance.deprels, '\t')).append("\n");
        }
        b.append(Util.join(instance.heads, '\t')).append("\n\n");
        String outString = b.toString();
        if (fileAccess) {
            this.writer.write(outString);
        }
        return outString;
    }
}

