/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import de.julielab.gnu.trove.TIntArrayList;
import edu.upenn.seas.mstparser.Alphabet;
import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.KBestParseForest;
import edu.upenn.seas.mstparser.Parameters;
import edu.upenn.seas.mstparser.ParserOptions;
import edu.upenn.seas.mstparser.io.DependencyReader;
import edu.upenn.seas.mstparser.io.DependencyWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class DependencyPipe {
    public Alphabet dataAlphabet;
    public Alphabet typeAlphabet;
    private DependencyReader depReader;
    DependencyWriter depWriter;
    public String[] types;
    public int[] typesInt;
    public boolean labeled = false;
    private boolean isCONLL = true;
    private ParserOptions options;
    public int testint = 0;

    public DependencyPipe(ParserOptions options) throws IOException {
        Random random = new Random(System.nanoTime());
        this.testint = random.nextInt();
        this.options = options;
        if (!options.format.equals("CONLL")) {
            this.isCONLL = false;
        }
        this.dataAlphabet = new Alphabet();
        this.typeAlphabet = new Alphabet();
        this.depReader = DependencyReader.createDependencyReader(options.format, options.discourseMode);
    }

    public void initInputFile(String file, boolean fileAccess) throws IOException {
        this.labeled = this.depReader.startReading(file, fileAccess);
    }

    public void initOutputFile(String file) throws IOException {
        this.depWriter = DependencyWriter.createDependencyWriter(this.options.format, this.labeled);
        this.depWriter.startWriting(file);
    }

    public String outputInstance(DependencyInstance instance, boolean fileAccess) throws IOException {
        return this.depWriter.write(instance, fileAccess);
    }

    public void close() throws IOException {
        if (null != this.depWriter) {
            this.depWriter.finishWriting();
        }
    }

    public String getType(int typeIndex) {
        return this.types[typeIndex];
    }

    protected final DependencyInstance nextInstance() throws IOException {
        DependencyInstance instance = this.depReader.getNext();
        if (instance == null || instance.forms == null) {
            return null;
        }
        instance.setFeatureVector(this.createFeatureVector(instance));
        String[] labs = instance.deprels;
        int[] heads = instance.heads;
        StringBuffer spans = new StringBuffer(heads.length * 5);
        for (int i = 1; i < heads.length; ++i) {
            spans.append(heads[i]).append("|").append(i).append(":").append(this.typeAlphabet.lookupIndex(labs[i])).append(" ");
        }
        instance.actParseTree = spans.substring(0, spans.length() - 1);
        return instance;
    }

    public int[] createInstances(String file, File featFileName, boolean fileAccess) throws IOException {
        this.createAlphabet(file, fileAccess);
        System.out.println("Num Features: " + this.dataAlphabet.size());
        this.labeled = this.depReader.startReading(file, fileAccess);
        TIntArrayList lengths = new TIntArrayList();
        ObjectOutputStream out = this.options.createForest ? new ObjectOutputStream(new FileOutputStream(featFileName)) : null;
        DependencyInstance instance = this.depReader.getNext();
        int num1 = 0;
        while (instance != null) {
            System.out.print(num1 + " ");
            instance.setFeatureVector(this.createFeatureVector(instance));
            String[] labs = instance.deprels;
            int[] heads = instance.heads;
            StringBuffer spans = new StringBuffer(heads.length * 5);
            for (int i = 1; i < heads.length; ++i) {
                spans.append(heads[i]).append("|").append(i).append(":").append(this.typeAlphabet.lookupIndex(labs[i])).append(" ");
            }
            instance.actParseTree = spans.substring(0, spans.length() - 1);
            lengths.add(instance.length());
            if (this.options.createForest) {
                this.writeInstance(instance, out);
            }
            instance = null;
            instance = this.depReader.getNext();
            ++num1;
        }
        System.out.println();
        this.closeAlphabets();
        if (this.options.createForest) {
            out.close();
        }
        return lengths.toNativeArray();
    }

    private final void createAlphabet(String file, boolean fileAccess) throws IOException {
        System.out.print("Creating Alphabet ... ");
        this.labeled = this.depReader.startReading(file, fileAccess);
        DependencyInstance instance = this.depReader.getNext();
        while (instance != null) {
            String[] labs = instance.deprels;
            for (int i = 0; i < labs.length; ++i) {
                this.typeAlphabet.lookupIndex(labs[i]);
            }
            this.createFeatureVector(instance);
            System.out.println(instance.feats.length);
            instance = this.depReader.getNext();
        }
        this.closeAlphabets();
    }

    public void closeAlphabets() {
        this.dataAlphabet.stopGrowth();
        this.typeAlphabet.stopGrowth();
        this.types = new String[this.typeAlphabet.size()];
        Object[] keys = this.typeAlphabet.toArray();
        for (int i = 0; i < keys.length; ++i) {
            int indx = this.typeAlphabet.lookupIndex(keys[i]);
            this.types[indx] = (String)keys[i];
        }
        KBestParseForest.rootType = this.typeAlphabet.lookupIndex("<root-type>");
    }

    public final void add(String feat, FeatureVector fv) {
        int num = this.dataAlphabet.lookupIndex(feat);
        if (num >= 0) {
            fv.add(num, 1.0);
        }
    }

    public final void add(String feat, double val, FeatureVector fv) {
        int num = this.dataAlphabet.lookupIndex(feat);
        if (num >= 0) {
            fv.add(num, val);
        }
    }

    public FeatureVector createFeatureVector(DependencyInstance instance) {
        int instanceLength = instance.length();
        FeatureVector fv = null;
        try {
            String[] labs = instance.deprels;
            int[] heads = instance.heads;
            fv = new FeatureVector();
            for (int i = 0; i < instanceLength; ++i) {
                if (heads[i] == -1) continue;
                int small = i < heads[i] ? i : heads[i];
                int large = i > heads[i] ? i : heads[i];
                boolean attR = i >= heads[i];
                this.addCoreFeatures(instance, small, large, attR, fv);
                if (!this.labeled) continue;
                this.addLabeledFeatures(instance, i, labs[i], attR, true, fv);
                this.addLabeledFeatures(instance, heads[i], labs[i], attR, false, fv);
            }
            this.addExtendedFeatures(instance, fv);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return fv;
    }

    protected void addExtendedFeatures(DependencyInstance instance, FeatureVector fv) {
    }

    public void addCoreFeatures(DependencyInstance instance, int small, int large, boolean attR, FeatureVector fv) {
        String[] forms = instance.forms;
        String[] pos = instance.postags;
        String[] posA = instance.cpostags;
        String att = attR ? "RA" : "LA";
        int dist = Math.abs(large - small);
        String distBool = "0";
        distBool = dist > 10 ? "10" : (dist > 5 ? "5" : Integer.toString(dist - 1));
        String attDist = "&" + att + "&" + distBool;
        this.addLinearFeatures("POS", pos, small, large, attDist, fv);
        this.addLinearFeatures("CPOS", posA, small, large, attDist, fv);
        int headIndex = small;
        int childIndex = large;
        if (!attR) {
            headIndex = large;
            childIndex = small;
        }
        this.addTwoObsFeatures("HC", forms[headIndex], pos[headIndex], forms[childIndex], pos[childIndex], attDist, fv);
        if (this.isCONLL) {
            this.addTwoObsFeatures("HCA", forms[headIndex], posA[headIndex], forms[childIndex], posA[childIndex], attDist, fv);
            this.addTwoObsFeatures("HCC", instance.lemmas[headIndex], pos[headIndex], instance.lemmas[childIndex], pos[childIndex], attDist, fv);
            this.addTwoObsFeatures("HCD", instance.lemmas[headIndex], posA[headIndex], instance.lemmas[childIndex], posA[childIndex], attDist, fv);
            if (this.options.discourseMode) {
                this.addDiscourseFeatures(instance, small, large, headIndex, childIndex, attDist, fv);
            } else {
                for (int i = 0; i < instance.feats[headIndex].length; ++i) {
                    for (int j = 0; j < instance.feats[childIndex].length; ++j) {
                        this.addTwoObsFeatures("FF" + i + "*" + j, instance.forms[headIndex], instance.feats[headIndex][i], instance.forms[childIndex], instance.feats[childIndex][j], attDist, fv);
                        this.addTwoObsFeatures("LF" + i + "*" + j, instance.lemmas[headIndex], instance.feats[headIndex][i], instance.lemmas[childIndex], instance.feats[childIndex][j], attDist, fv);
                    }
                }
            }
        } else {
            int hL = forms[headIndex].length();
            int cL = forms[childIndex].length();
            if (hL > 5 || cL > 5) {
                this.addOldMSTStemFeatures(instance.lemmas[headIndex], pos[headIndex], instance.lemmas[childIndex], pos[childIndex], attDist, hL, cL, fv);
            }
        }
    }

    private final void addLinearFeatures(String type, String[] obsVals, int first, int second, String attachDistance, FeatureVector fv) {
        String pLeft = first > 0 ? obsVals[first - 1] : "STR";
        String pRight = second < obsVals.length - 1 ? obsVals[second + 1] : "END";
        String pLeftRight = first < second - 1 ? obsVals[first + 1] : "MID";
        String pRightLeft = second > first + 1 ? obsVals[second - 1] : "MID";
        StringBuilder featPos = new StringBuilder(type + "PC=" + obsVals[first] + " " + obsVals[second]);
        for (int i = first + 1; i < second; ++i) {
            String allPos = featPos.toString() + " " + obsVals[i];
            this.add(allPos, fv);
            this.add(allPos + attachDistance, fv);
        }
        this.addCorePosFeatures(type + "PT", pLeft, obsVals[first], pLeftRight, pRightLeft, obsVals[second], pRight, attachDistance, fv);
    }

    private final void addCorePosFeatures(String prefix, String leftOf1, String one, String rightOf1, String leftOf2, String two, String rightOf2, String attachDistance, FeatureVector fv) {
        this.add((String)prefix + "=" + leftOf1 + " " + one + " " + two + "*" + attachDistance, fv);
        StringBuilder feat = new StringBuilder((String)prefix + "1=" + leftOf1 + " " + one + " " + two);
        this.add(feat.toString(), fv);
        feat.append(' ').append(rightOf2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "2=" + leftOf1 + " " + two + " " + rightOf2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "3=" + leftOf1 + " " + one + " " + rightOf2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "4=" + one + " " + two + " " + rightOf2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        prefix = "A" + (String)prefix;
        this.add((String)prefix + "1=" + one + " " + rightOf1 + " " + leftOf2 + "*" + attachDistance, fv);
        feat = new StringBuilder((String)prefix + "1=" + one + " " + rightOf1 + " " + leftOf2);
        this.add(feat.toString(), fv);
        feat.append(' ').append(two);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "2=" + one + " " + rightOf1 + " " + two);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "3=" + one + " " + leftOf2 + " " + two);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "4=" + rightOf1 + " " + leftOf2 + " " + two);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        prefix = "B" + (String)prefix;
        feat = new StringBuilder((String)prefix + "1=" + leftOf1 + " " + one + " " + leftOf2 + " " + two);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder((String)prefix + "2=" + one + " " + rightOf1 + " " + two + " " + rightOf2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
    }

    private final void addTwoObsFeatures(String prefix, String item1F1, String item1F2, String item2F1, String item2F2, String attachDistance, FeatureVector fv) {
        StringBuilder feat = new StringBuilder(prefix + "2FF1=" + item1F1);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF1=" + item1F1 + " " + item1F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF1=" + item1F1 + " " + item1F2 + " " + item2F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF1=" + item1F1 + " " + item1F2 + " " + item2F2 + " " + item2F1);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF2=" + item1F1 + " " + item2F1);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF3=" + item1F1 + " " + item2F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF4=" + item1F2 + " " + item2F1);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF4=" + item1F2 + " " + item2F1 + " " + item2F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF5=" + item1F2 + " " + item2F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF6=" + item2F1 + " " + item2F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF7=" + item1F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF8=" + item2F1);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
        feat = new StringBuilder(prefix + "2FF9=" + item2F2);
        this.add(feat.toString(), fv);
        feat.append('*').append(attachDistance);
        this.add(feat.toString(), fv);
    }

    public void addLabeledFeatures(DependencyInstance instance, int word, String type, boolean attR, boolean childFeatures, FeatureVector fv) {
        if (!this.labeled) {
            return;
        }
        String[] forms = instance.forms;
        String[] pos = instance.postags;
        Object att = "";
        att = attR ? "RA" : "LA";
        att = (String)att + "&" + childFeatures;
        String w = forms[word];
        String wP = pos[word];
        String wPm1 = word > 0 ? pos[word - 1] : "STR";
        String wPp1 = word < pos.length - 1 ? pos[word + 1] : "END";
        this.add("NTS1=" + type + "&" + (String)att, fv);
        this.add("ANTS1=" + type, fv);
        for (int i = 0; i < 2; ++i) {
            Object suff = i < 1 ? "&" + (String)att : "";
            suff = "&" + type + (String)suff;
            this.add("NTH=" + w + " " + wP + (String)suff, fv);
            this.add("NTI=" + wP + (String)suff, fv);
            this.add("NTIA=" + wPm1 + " " + wP + (String)suff, fv);
            this.add("NTIB=" + wP + " " + wPp1 + (String)suff, fv);
            this.add("NTIC=" + wPm1 + " " + wP + " " + wPp1 + (String)suff, fv);
            this.add("NTJ=" + w + (String)suff, fv);
        }
    }

    private void addDiscourseFeatures(DependencyInstance instance, int small, int large, int headIndex, int childIndex, String attDist, FeatureVector fv) {
        this.addLinearFeatures("FORM", instance.forms, small, large, attDist, fv);
        this.addLinearFeatures("LEMMA", instance.lemmas, small, large, attDist, fv);
        this.addTwoObsFeatures("HCB1", instance.forms[headIndex], instance.lemmas[headIndex], instance.forms[childIndex], instance.lemmas[childIndex], attDist, fv);
        this.addTwoObsFeatures("HCB2", instance.forms[headIndex], instance.lemmas[headIndex], instance.forms[childIndex], instance.postags[childIndex], attDist, fv);
        this.addTwoObsFeatures("HCB3", instance.forms[headIndex], instance.lemmas[headIndex], instance.forms[childIndex], instance.cpostags[childIndex], attDist, fv);
        this.addTwoObsFeatures("HC2", instance.forms[headIndex], instance.postags[headIndex], instance.forms[childIndex], instance.cpostags[childIndex], attDist, fv);
        this.addTwoObsFeatures("HCC2", instance.lemmas[headIndex], instance.postags[headIndex], instance.lemmas[childIndex], instance.cpostags[childIndex], attDist, fv);
        for (int i = 0; i < instance.feats.length; ++i) {
            int j;
            this.addLinearFeatures("F" + i, instance.feats[i], small, large, attDist, fv);
            this.addTwoObsFeatures("FF" + i, instance.forms[headIndex], instance.feats[i][headIndex], instance.forms[childIndex], instance.feats[i][childIndex], attDist, fv);
            this.addTwoObsFeatures("LF" + i, instance.lemmas[headIndex], instance.feats[i][headIndex], instance.lemmas[childIndex], instance.feats[i][childIndex], attDist, fv);
            this.addTwoObsFeatures("PF" + i, instance.postags[headIndex], instance.feats[i][headIndex], instance.postags[childIndex], instance.feats[i][childIndex], attDist, fv);
            this.addTwoObsFeatures("CPF" + i, instance.cpostags[headIndex], instance.feats[i][headIndex], instance.cpostags[childIndex], instance.feats[i][childIndex], attDist, fv);
            for (j = i + 1; j < instance.feats.length; ++j) {
                this.addTwoObsFeatures("CPF" + i + "_" + j, instance.feats[i][headIndex], instance.feats[j][headIndex], instance.feats[i][childIndex], instance.feats[j][childIndex], attDist, fv);
            }
            for (j = 0; j < instance.feats.length; ++j) {
                this.addTwoObsFeatures("XFF" + i + "_" + j, instance.forms[headIndex], instance.feats[i][headIndex], instance.forms[childIndex], instance.feats[j][childIndex], attDist, fv);
                this.addTwoObsFeatures("XLF" + i + "_" + j, instance.lemmas[headIndex], instance.feats[i][headIndex], instance.lemmas[childIndex], instance.feats[j][childIndex], attDist, fv);
                this.addTwoObsFeatures("XPF" + i + "_" + j, instance.postags[headIndex], instance.feats[i][headIndex], instance.postags[childIndex], instance.feats[j][childIndex], attDist, fv);
                this.addTwoObsFeatures("XCF" + i + "_" + j, instance.cpostags[headIndex], instance.feats[i][headIndex], instance.cpostags[childIndex], instance.feats[j][childIndex], attDist, fv);
            }
        }
        if (this.options.useRelationalFeatures) {
            for (int rf_index = 0; rf_index < instance.relFeats.length; ++rf_index) {
                String headToChild = "H2C" + rf_index + instance.relFeats[rf_index].getFeature(headIndex, childIndex);
                this.addTwoObsFeatures("RFA1", instance.forms[headIndex], instance.lemmas[headIndex], instance.postags[childIndex], headToChild, attDist, fv);
                this.addTwoObsFeatures("RFA2", instance.postags[headIndex], instance.cpostags[headIndex], instance.forms[childIndex], headToChild, attDist, fv);
                this.addTwoObsFeatures("RFA3", instance.lemmas[headIndex], instance.postags[headIndex], instance.forms[childIndex], headToChild, attDist, fv);
                this.addTwoObsFeatures("RFB1", headToChild, instance.postags[headIndex], instance.forms[childIndex], instance.lemmas[childIndex], attDist, fv);
                this.addTwoObsFeatures("RFB2", headToChild, instance.forms[headIndex], instance.postags[childIndex], instance.cpostags[childIndex], attDist, fv);
                this.addTwoObsFeatures("RFB3", headToChild, instance.forms[headIndex], instance.lemmas[childIndex], instance.postags[childIndex], attDist, fv);
            }
        }
    }

    public void fillFeatureVectors(DependencyInstance instance, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, Parameters params) {
        int w1;
        int instanceLength = instance.length();
        for (w1 = 0; w1 < instanceLength; ++w1) {
            for (int w2 = w1 + 1; w2 < instanceLength; ++w2) {
                for (int ph = 0; ph < 2; ++ph) {
                    boolean attR = ph == 0;
                    int childInt = attR ? w2 : w1;
                    int parInt = attR ? w1 : w2;
                    FeatureVector prodFV = new FeatureVector();
                    this.addCoreFeatures(instance, w1, w2, attR, prodFV);
                    double prodProb = params.getScore(prodFV);
                    fvs[w1][w2][ph] = prodFV;
                    probs[w1][w2][ph] = prodProb;
                }
            }
        }
        if (this.labeled) {
            for (w1 = 0; w1 < instanceLength; ++w1) {
                for (int t = 0; t < this.types.length; ++t) {
                    String type = this.types[t];
                    for (int ph = 0; ph < 2; ++ph) {
                        boolean attR = ph == 0;
                        for (int ch = 0; ch < 2; ++ch) {
                            boolean child = ch == 0;
                            FeatureVector prodFV = new FeatureVector();
                            this.addLabeledFeatures(instance, w1, type, attR, child, prodFV);
                            double nt_prob = params.getScore(prodFV);
                            nt_fvs[w1][t][ph][ch] = prodFV;
                            nt_probs[w1][t][ph][ch] = nt_prob;
                        }
                    }
                }
            }
        }
    }

    protected void writeInstance(DependencyInstance instance, ObjectOutputStream out) {
        int instanceLength = instance.length();
        try {
            int w1;
            for (w1 = 0; w1 < instanceLength; ++w1) {
                for (int w2 = w1 + 1; w2 < instanceLength; ++w2) {
                    for (int ph = 0; ph < 2; ++ph) {
                        boolean attR = ph == 0;
                        FeatureVector prodFV = new FeatureVector();
                        this.addCoreFeatures(instance, w1, w2, attR, prodFV);
                        out.writeObject(prodFV.keys());
                    }
                }
            }
            out.writeInt(-3);
            if (this.labeled) {
                for (w1 = 0; w1 < instanceLength; ++w1) {
                    for (int t = 0; t < this.types.length; ++t) {
                        String type = this.types[t];
                        for (int ph = 0; ph < 2; ++ph) {
                            boolean attR = ph == 0;
                            for (int ch = 0; ch < 2; ++ch) {
                                boolean child = ch == 0;
                                FeatureVector prodFV = new FeatureVector();
                                this.addLabeledFeatures(instance, w1, type, attR, child, prodFV);
                                out.writeObject(prodFV.keys());
                            }
                        }
                    }
                }
                out.writeInt(-3);
            }
            this.writeExtendedFeatures(instance, out);
            out.writeObject(instance.fv.keys());
            out.writeInt(-4);
            out.writeObject(instance);
            out.writeInt(-1);
            out.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeExtendedFeatures(DependencyInstance instance, ObjectOutputStream out) throws IOException {
    }

    public DependencyInstance readInstance(ObjectInputStream in, int length, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, Parameters params) throws IOException {
        try {
            for (int w1 = 0; w1 < length; ++w1) {
                for (int w2 = w1 + 1; w2 < length; ++w2) {
                    for (int ph = 0; ph < 2; ++ph) {
                        FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                        double prodProb = params.getScore(prodFV);
                        fvs[w1][w2][ph] = prodFV;
                        probs[w1][w2][ph] = prodProb;
                    }
                }
            }
            int last = in.readInt();
            if (last != -3) {
                System.err.println("Error reading file.");
                System.exit(0);
            }
            if (this.labeled) {
                for (int w1 = 0; w1 < length; ++w1) {
                    for (int t = 0; t < this.types.length; ++t) {
                        String type = this.types[t];
                        for (int ph = 0; ph < 2; ++ph) {
                            for (int ch = 0; ch < 2; ++ch) {
                                FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                                double nt_prob = params.getScore(prodFV);
                                nt_fvs[w1][t][ph][ch] = prodFV;
                                nt_probs[w1][t][ph][ch] = nt_prob;
                            }
                        }
                    }
                }
                last = in.readInt();
                if (last != -3) {
                    System.out.println("Error reading file.");
                    System.exit(0);
                }
            }
            FeatureVector nfv = new FeatureVector((int[])in.readObject());
            last = in.readInt();
            if (last != -4) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            DependencyInstance marshalledDI = (DependencyInstance)in.readObject();
            marshalledDI.setFeatureVector(nfv);
            last = in.readInt();
            if (last != -1) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            return marshalledDI;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error reading file.");
            System.exit(0);
            return null;
        }
    }

    private final void addOldMSTStemFeatures(String hLemma, String headP, String cLemma, String childP, String attDist, int hL, int cL, FeatureVector fv) {
        String all = hLemma + " " + headP + " " + cLemma + " " + childP;
        String hPos = headP + " " + cLemma + " " + childP;
        String cPos = hLemma + " " + headP + " " + childP;
        String hP = headP + " " + cLemma;
        String cP = hLemma + " " + childP;
        String oPos = headP + " " + childP;
        String oLex = hLemma + " " + cLemma;
        this.add("SA=" + all + attDist, fv);
        this.add("SF=" + oLex + attDist, fv);
        this.add("SAA=" + all, fv);
        this.add("SFF=" + oLex, fv);
        if (cL > 5) {
            this.add("SB=" + hPos + attDist, fv);
            this.add("SD=" + hP + attDist, fv);
            this.add("SK=" + cLemma + " " + childP + attDist, fv);
            this.add("SM=" + cLemma + attDist, fv);
            this.add("SBB=" + hPos, fv);
            this.add("SDD=" + hP, fv);
            this.add("SKK=" + cLemma + " " + childP, fv);
            this.add("SMM=" + cLemma, fv);
        }
        if (hL > 5) {
            this.add("SC=" + cPos + attDist, fv);
            this.add("SE=" + cP + attDist, fv);
            this.add("SH=" + hLemma + " " + headP + attDist, fv);
            this.add("SJ=" + hLemma + attDist, fv);
            this.add("SCC=" + cPos, fv);
            this.add("SEE=" + cP, fv);
            this.add("SHH=" + hLemma + " " + headP, fv);
            this.add("SJJ=" + hLemma, fv);
        }
    }
}

