/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.RelationalFeature;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class DependencyInstance
implements Serializable {
    public FeatureVector fv;
    public String actParseTree;
    public String[] forms;
    public String[] lemmas;
    public String[] cpostags;
    public String[] postags;
    public String[][] feats;
    public int[] heads;
    public String[] deprels;
    public RelationalFeature[] relFeats;

    public DependencyInstance() {
    }

    public DependencyInstance(DependencyInstance source) {
        this.fv = source.fv;
        this.actParseTree = source.actParseTree;
    }

    public DependencyInstance(String[] forms, FeatureVector fv) {
        this.forms = forms;
        this.fv = fv;
    }

    public DependencyInstance(String[] forms, String[] postags, FeatureVector fv) {
        this(forms, fv);
        this.postags = postags;
    }

    public DependencyInstance(String[] forms, String[] postags, String[] labs, FeatureVector fv) {
        this(forms, postags, fv);
        this.deprels = labs;
    }

    public DependencyInstance(String[] forms, String[] postags, String[] labs, int[] heads) {
        this.forms = forms;
        this.postags = postags;
        this.deprels = labs;
        this.heads = heads;
    }

    public DependencyInstance(String[] forms, String[] lemmas, String[] cpostags, String[] postags, String[][] feats, String[] labs, int[] heads) {
        this(forms, postags, labs, heads);
        this.lemmas = lemmas;
        this.cpostags = cpostags;
        this.feats = feats;
    }

    public DependencyInstance(String[] forms, String[] lemmas, String[] cpostags, String[] postags, String[][] feats, String[] labs, int[] heads, RelationalFeature[] relFeats) {
        this(forms, lemmas, cpostags, postags, feats, labs, heads);
        this.relFeats = relFeats;
    }

    public void setFeatureVector(FeatureVector fv) {
        this.fv = fv;
    }

    public int length() {
        return this.forms.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(Arrays.toString(this.forms)).append("\n");
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.forms);
        out.writeObject(this.lemmas);
        out.writeObject(this.cpostags);
        out.writeObject(this.postags);
        out.writeObject(this.heads);
        out.writeObject(this.deprels);
        out.writeObject(this.actParseTree);
        out.writeObject(this.feats);
        out.writeObject(this.relFeats);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.forms = (String[])in.readObject();
        this.lemmas = (String[])in.readObject();
        this.cpostags = (String[])in.readObject();
        this.postags = (String[])in.readObject();
        this.heads = (int[])in.readObject();
        this.deprels = (String[])in.readObject();
        this.actParseTree = (String)in.readObject();
        this.feats = (String[][])in.readObject();
        this.relFeats = (RelationalFeature[])in.readObject();
    }
}

