/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import de.julielab.gnu.trove.TIntIntHashMap;
import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.DependencyPipe;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.KBestParseForest;
import edu.upenn.seas.mstparser.ParseForestItem;
import java.util.ArrayList;
import java.util.Arrays;

public class DependencyDecoder {
    DependencyPipe pipe;

    public DependencyDecoder(DependencyPipe pipe) {
        this.pipe = pipe;
    }

    protected int[][] getTypes(double[][][][] nt_probs, int len) {
        int[][] static_types = new int[len][len];
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < len; ++j) {
                if (i == j) {
                    static_types[i][j] = 0;
                    continue;
                }
                int wh = -1;
                double best = Double.NEGATIVE_INFINITY;
                for (int t = 0; t < this.pipe.types.length; ++t) {
                    double score = 0.0;
                    score = i < j ? nt_probs[i][t][0][1] + nt_probs[j][t][0][0] : nt_probs[i][t][1][1] + nt_probs[j][t][1][0];
                    if (!(score > best)) continue;
                    wh = t;
                    best = score;
                }
                static_types[i][j] = wh;
            }
        }
        return static_types;
    }

    public Object[][] decodeProjective(DependencyInstance inst, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, int K) {
        String[] forms = inst.forms;
        String[] pos = inst.postags;
        int[][] static_types = null;
        if (this.pipe.labeled) {
            static_types = this.getTypes(nt_probs, forms.length);
        }
        KBestParseForest pf = new KBestParseForest(0, forms.length - 1, inst, K);
        for (int s = 0; s < forms.length; ++s) {
            pf.add(s, -1, 0, 0.0, new FeatureVector());
            pf.add(s, -1, 1, 0.0, new FeatureVector());
        }
        for (int j = 1; j < forms.length; ++j) {
            for (int s = 0; s < forms.length && s + j < forms.length; ++s) {
                double bc;
                int comp2;
                int comp1;
                int k;
                int[][] pairs;
                ParseForestItem[] c1;
                ParseForestItem[] b1;
                int r;
                int t = s + j;
                FeatureVector prodFV_st = fvs[s][t][0];
                FeatureVector prodFV_ts = fvs[s][t][1];
                double prodProb_st = probs[s][t][0];
                double prodProb_ts = probs[s][t][1];
                int type1 = this.pipe.labeled ? static_types[s][t] : 0;
                int type2 = this.pipe.labeled ? static_types[t][s] : 0;
                FeatureVector nt_fv_s_01 = nt_fvs[s][type1][0][1];
                FeatureVector nt_fv_s_10 = nt_fvs[s][type2][1][0];
                FeatureVector nt_fv_t_00 = nt_fvs[t][type1][0][0];
                FeatureVector nt_fv_t_11 = nt_fvs[t][type2][1][1];
                double nt_prob_s_01 = nt_probs[s][type1][0][1];
                double nt_prob_s_10 = nt_probs[s][type2][1][0];
                double nt_prob_t_00 = nt_probs[t][type1][0][0];
                double nt_prob_t_11 = nt_probs[t][type2][1][1];
                double prodProb = 0.0;
                for (r = s; r <= t; ++r) {
                    if (r == t) continue;
                    b1 = pf.getItems(s, r, 0, 0);
                    c1 = pf.getItems(r + 1, t, 1, 0);
                    if (b1 == null || c1 == null) continue;
                    pairs = pf.getKBestPairs(b1, c1);
                    for (k = 0; k < pairs.length && pairs[k][0] != -1 && pairs[k][1] != -1; ++k) {
                        comp1 = pairs[k][0];
                        comp2 = pairs[k][1];
                        bc = b1[comp1].prob + c1[comp2].prob;
                        double prob_fin = bc + prodProb_st;
                        FeatureVector fv_fin = prodFV_st;
                        if (this.pipe.labeled) {
                            fv_fin = nt_fv_s_01.cat(nt_fv_t_00.cat(fv_fin));
                            prob_fin += nt_prob_s_01 + nt_prob_t_00;
                        }
                        pf.add(s, r, t, type1, 0, 1, prob_fin, fv_fin, b1[comp1], c1[comp2]);
                        prob_fin = bc + prodProb_ts;
                        fv_fin = prodFV_ts;
                        if (this.pipe.labeled) {
                            fv_fin = nt_fv_t_11.cat(nt_fv_s_10.cat(fv_fin));
                            prob_fin += nt_prob_t_11 + nt_prob_s_10;
                        }
                        pf.add(s, r, t, type2, 1, 1, prob_fin, fv_fin, b1[comp1], c1[comp2]);
                    }
                }
                for (r = s; r <= t; ++r) {
                    if (r != s) {
                        b1 = pf.getItems(s, r, 0, 1);
                        c1 = pf.getItems(r, t, 0, 0);
                        if (b1 != null && c1 != null) {
                            pairs = pf.getKBestPairs(b1, c1);
                            for (k = 0; k < pairs.length && pairs[k][0] != -1 && pairs[k][1] != -1 && pf.add(s, r, t, -1, 0, 0, bc = b1[comp1].prob + c1[comp2].prob, new FeatureVector(), b1[comp1 = pairs[k][0]], c1[comp2 = pairs[k][1]]); ++k) {
                            }
                        }
                    }
                    if (r == t) continue;
                    b1 = pf.getItems(s, r, 1, 0);
                    c1 = pf.getItems(r, t, 1, 1);
                    if (b1 == null || c1 == null) continue;
                    pairs = pf.getKBestPairs(b1, c1);
                    for (k = 0; k < pairs.length && pairs[k][0] != -1 && pairs[k][1] != -1 && pf.add(s, r, t, -1, 1, 0, bc = b1[comp1].prob + c1[comp2].prob, new FeatureVector(), b1[comp1 = pairs[k][0]], c1[comp2 = pairs[k][1]]); ++k) {
                    }
                }
            }
        }
        return pf.getBestParses();
    }

    public Object[][] decodeNonProjective(DependencyInstance inst, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, int K) {
        String[] pos = inst.postags;
        int numWords = inst.length();
        int[][] oldI = new int[numWords][numWords];
        int[][] oldO = new int[numWords][numWords];
        double[][] scoreMatrix = new double[numWords][numWords];
        double[][] orig_scoreMatrix = new double[numWords][numWords];
        boolean[] curr_nodes = new boolean[numWords];
        TIntIntHashMap[] reps = new TIntIntHashMap[numWords];
        int[][] static_types = null;
        if (this.pipe.labeled) {
            static_types = this.getTypes(nt_probs, pos.length);
        }
        for (int i = 0; i < numWords; ++i) {
            curr_nodes[i] = true;
            reps[i] = new TIntIntHashMap();
            reps[i].put(i, 0);
            for (int j = 0; j < numWords; ++j) {
                scoreMatrix[i][j] = probs[i < j ? i : j][i < j ? j : i][i < j ? 0 : 1] + (this.pipe.labeled ? nt_probs[i][static_types[i][j]][i < j ? 0 : 1][1] + nt_probs[j][static_types[i][j]][i < j ? 0 : 1][0] : 0.0);
                orig_scoreMatrix[i][j] = probs[i < j ? i : j][i < j ? j : i][i < j ? 0 : 1] + (this.pipe.labeled ? nt_probs[i][static_types[i][j]][i < j ? 0 : 1][1] + nt_probs[j][static_types[i][j]][i < j ? 0 : 1][0] : 0.0);
                oldI[i][j] = i;
                oldO[i][j] = j;
                if (i != j && j != 0) continue;
            }
        }
        TIntIntHashMap final_edges = DependencyDecoder.chuLiuEdmonds(scoreMatrix, curr_nodes, oldI, oldO, false, new TIntIntHashMap(), reps);
        int[] par = new int[numWords];
        int[] ns = final_edges.keys();
        for (int i = 0; i < ns.length; ++i) {
            int pr;
            int ch = ns[i];
            par[ch] = pr = final_edges.get(ns[i]);
        }
        int[] n_par = this.getKChanges(par, orig_scoreMatrix, Math.min(K, par.length));
        int new_k = 1;
        for (int i = 0; i < n_par.length; ++i) {
            if (n_par[i] <= -1) continue;
            ++new_k;
        }
        int[][] fin_par = new int[new_k][numWords];
        FeatureVector[][] fin_fv = new FeatureVector[new_k][numWords];
        fin_par[0] = par;
        int c = 1;
        for (int i = 0; i < n_par.length; ++i) {
            if (n_par[i] <= -1) continue;
            int[] t_par = new int[par.length];
            for (int j = 0; j < t_par.length; ++j) {
                t_par[j] = par[j];
            }
            t_par[i] = n_par[i];
            fin_par[c] = t_par;
            ++c;
        }
        for (int k = 0; k < fin_par.length; ++k) {
            for (int i = 0; i < fin_par[k].length; ++i) {
                int ch = i;
                int pr = fin_par[k][i];
                if (pr != -1) {
                    fin_fv[k][ch] = fvs[ch < pr ? ch : pr][ch < pr ? pr : ch][ch < pr ? 1 : 0];
                    if (!this.pipe.labeled) continue;
                    fin_fv[k][ch] = fin_fv[k][ch].cat(nt_fvs[ch][static_types[pr][ch]][ch < pr ? 1 : 0][0]);
                    fin_fv[k][ch] = fin_fv[k][ch].cat(nt_fvs[pr][static_types[pr][ch]][ch < pr ? 1 : 0][1]);
                    continue;
                }
                fin_fv[k][ch] = new FeatureVector();
            }
        }
        FeatureVector[] fin = new FeatureVector[new_k];
        String[] result = new String[new_k];
        for (int k = 0; k < fin.length; ++k) {
            int i;
            fin[k] = new FeatureVector();
            for (i = 1; i < fin_fv[k].length; ++i) {
                fin[k] = fin_fv[k][i].cat(fin[k]);
            }
            result[k] = "";
            for (i = 1; i < par.length; ++i) {
                int n = k;
                result[n] = result[n] + fin_par[k][i] + "|" + i + (String)(this.pipe.labeled ? ":" + static_types[fin_par[k][i]][i] : ":0") + " ";
            }
        }
        Object[][] d = new Object[new_k][2];
        for (int k = 0; k < new_k; ++k) {
            d[k][0] = fin[k];
            d[k][1] = result[k].trim();
        }
        return d;
    }

    private int[] getKChanges(int[] par, double[][] scoreMatrix, int K) {
        int wh;
        double max;
        int[] result = new int[par.length];
        int[] n_par = new int[par.length];
        double[] n_score = new double[par.length];
        for (int i = 0; i < par.length; ++i) {
            result[i] = -1;
            n_par[i] = -1;
            n_score[i] = Double.NEGATIVE_INFINITY;
        }
        boolean[][] isChild = this.calcChilds(par);
        for (int i = 1; i < n_par.length; ++i) {
            max = Double.NEGATIVE_INFINITY;
            wh = -1;
            for (int j = 0; j < n_par.length; ++j) {
                if (i == j || par[i] == j || isChild[i][j] || !(scoreMatrix[j][i] > max)) continue;
                max = scoreMatrix[j][i];
                wh = j;
            }
            n_par[i] = wh;
            n_score[i] = max;
        }
        for (int k = 0; k < K; ++k) {
            max = Double.NEGATIVE_INFINITY;
            wh = -1;
            int whI = -1;
            for (int i = 0; i < n_par.length; ++i) {
                double score;
                if (n_par[i] == -1 || !((score = scoreMatrix[n_par[i]][i]) > max)) continue;
                max = score;
                whI = i;
                wh = n_par[i];
            }
            if (max == Double.NEGATIVE_INFINITY) break;
            result[whI] = wh;
            n_par[whI] = -1;
        }
        return result;
    }

    private boolean[][] calcChilds(int[] par) {
        boolean[][] isChild = new boolean[par.length][par.length];
        for (int i = 1; i < par.length; ++i) {
            int l = par[i];
            while (l != -1) {
                isChild[l][i] = true;
                l = par[l];
            }
        }
        return isChild;
    }

    private static TIntIntHashMap chuLiuEdmonds(double[][] scoreMatrix, boolean[] curr_nodes, int[][] oldI, int[][] oldO, boolean print, TIntIntHashMap final_edges, TIntIntHashMap[] reps) {
        int j;
        int[] keys;
        int i;
        int i2;
        int i3;
        int[] par = new int[curr_nodes.length];
        int numWords = curr_nodes.length;
        par[0] = -1;
        for (i3 = 1; i3 < par.length; ++i3) {
            if (!curr_nodes[i3]) continue;
            double maxScore = scoreMatrix[0][i3];
            par[i3] = 0;
            for (int j2 = 0; j2 < par.length; ++j2) {
                double newScore;
                if (j2 == i3 || !curr_nodes[j2] || !((newScore = scoreMatrix[j2][i3]) > maxScore)) continue;
                maxScore = newScore;
                par[i3] = j2;
            }
        }
        if (print) {
            System.out.println("After init");
            for (i3 = 0; i3 < par.length; ++i3) {
                if (!curr_nodes[i3]) continue;
                System.out.print(par[i3] + "|" + i3 + " ");
            }
            System.out.println();
        }
        ArrayList<TIntIntHashMap> cycles = new ArrayList<TIntIntHashMap>();
        boolean[] added = new boolean[numWords];
        block3: for (i2 = 0; i2 < numWords && cycles.size() == 0; ++i2) {
            if (added[i2] || !curr_nodes[i2]) continue;
            added[i2] = true;
            TIntIntHashMap cycle = new TIntIntHashMap();
            cycle.put(i2, 0);
            int l = i2;
            while (true) {
                if (par[l] == -1) {
                    added[l] = true;
                    continue block3;
                }
                if (cycle.contains(par[l])) {
                    cycle = new TIntIntHashMap();
                    int lorg = par[l];
                    cycle.put(lorg, par[lorg]);
                    added[lorg] = true;
                    int l1 = par[lorg];
                    while (l1 != lorg) {
                        cycle.put(l1, par[l1]);
                        added[l1] = true;
                        l1 = par[l1];
                    }
                    cycles.add(cycle);
                    continue block3;
                }
                cycle.put(l, 0);
                l = par[l];
                if (added[l] && !cycle.contains(l)) continue block3;
                added[l] = true;
            }
        }
        if (cycles.size() == 0) {
            for (i2 = 0; i2 < par.length; ++i2) {
                if (!curr_nodes[i2]) continue;
                if (par[i2] != -1) {
                    int pr = oldI[par[i2]][i2];
                    int ch = oldO[par[i2]][i2];
                    final_edges.put(ch, pr);
                    continue;
                }
                final_edges.put(0, -1);
            }
            return final_edges;
        }
        int max_cyc = 0;
        int wh_cyc = 0;
        for (int i4 = 0; i4 < cycles.size(); ++i4) {
            TIntIntHashMap cycle = (TIntIntHashMap)cycles.get(i4);
            if (cycle.size() <= max_cyc) continue;
            max_cyc = cycle.size();
            wh_cyc = i4;
        }
        TIntIntHashMap cycle = (TIntIntHashMap)cycles.get(wh_cyc);
        int[] cyc_nodes = cycle.keys();
        int rep = cyc_nodes[0];
        if (print) {
            System.out.println("Found Cycle");
            for (int i5 = 0; i5 < cyc_nodes.length; ++i5) {
                System.out.print(cyc_nodes[i5] + " ");
            }
            System.out.println();
        }
        double cyc_weight = 0.0;
        for (int j3 = 0; j3 < cyc_nodes.length; ++j3) {
            cyc_weight += scoreMatrix[par[cyc_nodes[j3]]][cyc_nodes[j3]];
        }
        for (int i6 = 0; i6 < numWords; ++i6) {
            if (!curr_nodes[i6] || cycle.contains(i6)) continue;
            double max1 = Double.NEGATIVE_INFINITY;
            int wh1 = -1;
            double max2 = Double.NEGATIVE_INFINITY;
            int wh2 = -1;
            for (int j4 = 0; j4 < cyc_nodes.length; ++j4) {
                double scr;
                int j1 = cyc_nodes[j4];
                if (scoreMatrix[j1][i6] > max1) {
                    max1 = scoreMatrix[j1][i6];
                    wh1 = j1;
                }
                if (!((scr = cyc_weight + scoreMatrix[i6][j1] - scoreMatrix[par[j1]][j1]) > max2)) continue;
                max2 = scr;
                wh2 = j1;
            }
            scoreMatrix[rep][i6] = max1;
            oldI[rep][i6] = oldI[wh1][i6];
            oldO[rep][i6] = oldO[wh1][i6];
            scoreMatrix[i6][rep] = max2;
            oldO[i6][rep] = oldO[i6][wh2];
            oldI[i6][rep] = oldI[i6][wh2];
        }
        TIntIntHashMap[] rep_cons = new TIntIntHashMap[cyc_nodes.length];
        for (i = 0; i < cyc_nodes.length; ++i) {
            rep_cons[i] = new TIntIntHashMap();
            keys = reps[cyc_nodes[i]].keys();
            Arrays.sort(keys);
            if (print) {
                System.out.print(cyc_nodes[i] + ": ");
            }
            for (j = 0; j < keys.length; ++j) {
                rep_cons[i].put(keys[j], 0);
                if (!print) continue;
                System.out.print(keys[j] + " ");
            }
            if (!print) continue;
            System.out.println();
        }
        for (i = 1; i < cyc_nodes.length; ++i) {
            curr_nodes[cyc_nodes[i]] = false;
            keys = reps[cyc_nodes[i]].keys();
            for (j = 0; j < keys.length; ++j) {
                reps[rep].put(keys[j], 0);
            }
        }
        DependencyDecoder.chuLiuEdmonds(scoreMatrix, curr_nodes, oldI, oldO, print, final_edges, reps);
        int wh = -1;
        boolean found = false;
        for (int i7 = 0; i7 < rep_cons.length && !found; ++i7) {
            int[] keys2 = rep_cons[i7].keys();
            for (int j5 = 0; j5 < keys2.length && !found; ++j5) {
                if (!final_edges.contains(keys2[j5])) continue;
                wh = cyc_nodes[i7];
                found = true;
            }
        }
        int l = par[wh];
        while (l != wh) {
            int ch = oldO[par[l]][l];
            int pr = oldI[par[l]][l];
            final_edges.put(ch, pr);
            l = par[l];
        }
        if (print) {
            int[] keys3 = final_edges.keys();
            Arrays.sort(keys3);
            for (int i8 = 0; i8 < keys3.length; ++i8) {
                System.out.print(final_edges.get(keys3[i8]) + "|" + keys3[i8] + " ");
            }
            System.out.println();
        }
        return final_edges;
    }
}

