/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove.benchmark;

import de.julielab.gnu.trove.benchmark.Operation;
import de.julielab.gnu.trove.benchmark.Result;
import de.julielab.gnu.trove.benchmark.Timer;

class Repeater
implements Timer {
    int _count;
    Operation _operation;

    Repeater(Operation o) {
        this._count = o.getIterationCount();
        this._operation = o;
    }

    public Result run() {
        long theirs = this.theirs();
        long ours = this.ours();
        Result r = new Result();
        r.setTheirs(theirs);
        r.setOurs(ours);
        r.setIterations(this._count);
        r.setDescription(this._operation.toString());
        return r;
    }

    public long theirs() {
        long then = System.currentTimeMillis();
        int i = 0;
        while (i < this._count) {
            this._operation.theirs();
            ++i;
        }
        long now = System.currentTimeMillis();
        return now - then;
    }

    public long ours() {
        long then = System.currentTimeMillis();
        int i = 0;
        while (i < this._count) {
            this._operation.ours();
            ++i;
        }
        long now = System.currentTimeMillis();
        return now - then;
    }

    public Operation getOperation() {
        return this._operation;
    }
}

