/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove.benchmark;

import de.julielab.gnu.trove.THashMap;
import de.julielab.gnu.trove.THashSet;
import de.julielab.gnu.trove.TIntArrayList;
import de.julielab.gnu.trove.TLinkableAdaptor;
import de.julielab.gnu.trove.TLinkedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class MemoryUsage {
    public static long sizeOf(Creator c) {
        long size = 0L;
        Object[] objects = new Object[100];
        try {
            Object primer = c.create();
            long startingMemoryUse = MemoryUsage.getUsedMemory();
            int i = 0;
            while (i < objects.length) {
                objects[i] = c.create();
                ++i;
            }
            long endingMemoryUse = MemoryUsage.getUsedMemory();
            float approxSize = (float)(endingMemoryUse - startingMemoryUse) / 100.0f;
            size = Math.round(approxSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    private static long getUsedMemory() {
        MemoryUsage.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        MemoryUsage.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return usedMemory;
    }

    private static void gc() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            MemoryComparator set = new MemoryComparator(new TroveSetCreator(), new JavasoftSetCreator(), "Compare size of Set implementation: 1,000 Integer objects measured in bytes");
            set.compare();
            set = null;
            MemoryComparator list = new MemoryComparator(new TroveListCreator(), new JavasoftListCreator(), "Compare size of LinkedList implementation: 1,000 TLinkableAdaptor objects measured in bytes");
            list.compare();
            list = null;
            MemoryComparator list2 = new MemoryComparator(new TroveIntArrayListCreator(), new JavasoftIntegerArrayListCreator(), "Compare size of int/IntegerArrayList implementation: 1,000 ints measured in bytes");
            list2.compare();
            list2 = null;
            MemoryComparator map = new MemoryComparator(new TroveMapCreator(), new JavasoftMapCreator(), "Compare size of Map implementation: 1,000 Integer->Integer mappings measured in bytes");
            map.compare();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    static interface Creator {
        public Object create();
    }

    static class JavasoftIntegerArrayListCreator
    implements Creator {
        JavasoftIntegerArrayListCreator() {
        }

        public Object create() {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int i = 0;
            while (i < 1000) {
                Integer x = new Integer(i);
                list.add(x);
                ++i;
            }
            list.trimToSize();
            return list;
        }
    }

    static class JavasoftListCreator
    implements Creator {
        JavasoftListCreator() {
        }

        public Object create() {
            LinkedList<TLinkableAdaptor> list = new LinkedList<TLinkableAdaptor>();
            int i = 0;
            while (i < 1000) {
                TLinkableAdaptor a = new TLinkableAdaptor();
                list.add(a);
                ++i;
            }
            return list;
        }
    }

    static class JavasoftMapCreator
    implements Creator {
        JavasoftMapCreator() {
        }

        public Object create() {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            int i = 0;
            while (i < 1000) {
                Integer x = new Integer(i);
                map.put(x, x);
                ++i;
            }
            return map;
        }
    }

    static class JavasoftSetCreator
    implements Creator {
        JavasoftSetCreator() {
        }

        public Object create() {
            HashSet<Integer> map = new HashSet<Integer>();
            int i = 0;
            while (i < 1000) {
                Integer x = new Integer(i);
                map.add(x);
                ++i;
            }
            return map;
        }
    }

    static class MemoryComparator {
        Creator trove;
        Creator javasoft;
        String description;

        MemoryComparator(Creator trove, Creator javasoft, String description) {
            this.trove = trove;
            this.javasoft = javasoft;
            this.description = description;
        }

        public void compare() {
            MemoryUsage.gc();
            long j = MemoryUsage.sizeOf(this.javasoft);
            MemoryUsage.gc();
            long t = MemoryUsage.sizeOf(this.trove);
            long p = Math.round(t * 100L / j * 100L) / 100;
            System.out.println("--------------------------");
            System.out.println(this.description);
            System.out.println("javasoft: " + j);
            System.out.println("trove: " + t);
            System.out.println("trove's collection requires " + p + "% of the memory needed by javasoft's collection");
        }
    }

    static class TroveIntArrayListCreator
    implements Creator {
        TroveIntArrayListCreator() {
        }

        public Object create() {
            TIntArrayList list = new TIntArrayList();
            int i = 0;
            while (i < 1000) {
                list.add(i);
                ++i;
            }
            list.trimToSize();
            return list;
        }
    }

    static class TroveListCreator
    implements Creator {
        TroveListCreator() {
        }

        public Object create() {
            TLinkedList list = new TLinkedList();
            int i = 0;
            while (i < 1000) {
                TLinkableAdaptor a = new TLinkableAdaptor();
                list.add(a);
                ++i;
            }
            return list;
        }
    }

    static class TroveMapCreator
    implements Creator {
        TroveMapCreator() {
        }

        public Object create() {
            THashMap map = new THashMap();
            int i = 0;
            while (i < 1000) {
                Integer x = new Integer(i);
                map.put(x, x);
                ++i;
            }
            return map;
        }
    }

    static class TroveSetCreator
    implements Creator {
        TroveSetCreator() {
        }

        public Object create() {
            THashSet map = new THashSet();
            int i = 0;
            while (i < 1000) {
                Integer x = new Integer(i);
                map.add(x);
                ++i;
            }
            return map;
        }
    }
}

