/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove;

import de.julielab.gnu.trove.SerializationProcedure;
import de.julielab.gnu.trove.TShortHash;
import de.julielab.gnu.trove.TShortHashingStrategy;
import de.julielab.gnu.trove.TShortIterator;
import de.julielab.gnu.trove.TShortProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TShortHashSet
extends TShortHash
implements Serializable {
    static final long serialVersionUID = 1L;

    public TShortHashSet() {
    }

    public TShortHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TShortHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TShortHashSet(short[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TShortHashSet(TShortHashingStrategy strategy) {
        super(strategy);
    }

    public TShortHashSet(int initialCapacity, TShortHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TShortHashSet(int initialCapacity, float loadFactor, TShortHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TShortHashSet(short[] array, TShortHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TShortIterator iterator() {
        return new TShortIterator(this);
    }

    public boolean add(short val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        short[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new short[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            short o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public short[] toArray() {
        short[] result = new short[this.size()];
        short[] set = this._set;
        byte[] states = this._states;
        int i = states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result[j++] = set[i];
        }
        return result;
    }

    public void clear() {
        super.clear();
        short[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TShortHashSet)) {
            return false;
        }
        final TShortHashSet that = (TShortHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TShortProcedure(){

            public final boolean execute(short value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(short val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(short[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(short[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(short[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(short[] array) {
        boolean changed = false;
        Arrays.sort(array);
        short[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            short val = stream.readShort();
            this.add(val);
        }
    }

    private final class HashProcedure
    implements TShortProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(short key) {
            this.h += TShortHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

