/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove;

import de.julielab.gnu.trove.HashFunctions;
import de.julielab.gnu.trove.SerializationProcedure;
import de.julielab.gnu.trove.TDoubleFunction;
import de.julielab.gnu.trove.TDoubleProcedure;
import de.julielab.gnu.trove.TShortDoubleIterator;
import de.julielab.gnu.trove.TShortDoubleProcedure;
import de.julielab.gnu.trove.TShortHash;
import de.julielab.gnu.trove.TShortHashingStrategy;
import de.julielab.gnu.trove.TShortProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TShortDoubleHashMap
extends TShortHash
implements Serializable {
    static final long serialVersionUID = 1L;
    protected transient double[] _values;

    public TShortDoubleHashMap() {
    }

    public TShortDoubleHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TShortDoubleHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TShortDoubleHashMap(TShortHashingStrategy strategy) {
        super(strategy);
    }

    public TShortDoubleHashMap(int initialCapacity, TShortHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TShortDoubleHashMap(int initialCapacity, float loadFactor, TShortHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public Object clone() {
        TShortDoubleHashMap m = (TShortDoubleHashMap)super.clone();
        m._values = (double[])this._values.clone();
        return m;
    }

    public TShortDoubleIterator iterator() {
        return new TShortDoubleIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new double[capacity];
        return capacity;
    }

    public double put(short key, double value) {
        double previous = 0.0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = key;
        this._states[index] = 1;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        short[] oldKeys = this._set;
        double[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new short[newCapacity];
        this._values = new double[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            short o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    public double get(short key) {
        int index = this.index(key);
        return index < 0 ? 0.0 : this._values[index];
    }

    public void clear() {
        super.clear();
        short[] keys = this._set;
        double[] vals = this._values;
        byte[] states = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            vals[i] = 0.0;
            states[i] = 0;
        }
    }

    public double remove(short key) {
        double prev = 0.0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TShortDoubleHashMap)) {
            return false;
        }
        TShortDoubleHashMap that = (TShortDoubleHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = 0.0;
    }

    public double[] getValues() {
        double[] vals = new double[this.size()];
        double[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public short[] keys() {
        short[] keys = new short[this.size()];
        short[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(double val) {
        byte[] states = this._states;
        double[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (states[i] != 1 || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(short key) {
        return this.contains(key);
    }

    public boolean forEachKey(TShortProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TShortDoubleProcedure procedure) {
        byte[] states = this._states;
        short[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TShortDoubleProcedure procedure) {
        boolean modified = false;
        byte[] states = this._states;
        short[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TDoubleFunction function) {
        byte[] states = this._states;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(short key) {
        return this.adjustValue(key, 1.0);
    }

    public boolean adjustValue(short key, double amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            short key = stream.readShort();
            double val = stream.readDouble();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TShortDoubleProcedure {
        private final TShortDoubleHashMap _otherMap;

        EqProcedure(TShortDoubleHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(short key, double value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(double v1, double v2) {
            return v1 == v2;
        }
    }

    private final class HashProcedure
    implements TShortDoubleProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(short key, double value) {
            this.h += TShortDoubleHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value);
            return true;
        }
    }
}

