/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove;

import de.julielab.gnu.trove.TIterator;
import de.julielab.gnu.trove.TObjectHash;
import de.julielab.gnu.trove.TObjectShortHashMap;
import java.util.ConcurrentModificationException;

public class TObjectShortIterator
extends TIterator {
    private final TObjectShortHashMap _map;

    public TObjectShortIterator(TObjectShortHashMap map) {
        super(map);
        this._map = map;
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == TObjectHash.FREE || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public Object key() {
        return this._map._set[this._index];
    }

    public short value() {
        return this._map._values[this._index];
    }

    public short setValue(short val) {
        short old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

