/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove;

import de.julielab.gnu.trove.SerializationProcedure;
import de.julielab.gnu.trove.TDoubleFunction;
import de.julielab.gnu.trove.TDoubleProcedure;
import de.julielab.gnu.trove.TObjectDoubleIterator;
import de.julielab.gnu.trove.TObjectDoubleProcedure;
import de.julielab.gnu.trove.TObjectHash;
import de.julielab.gnu.trove.TObjectHashingStrategy;
import de.julielab.gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TObjectDoubleHashMap
extends TObjectHash
implements Serializable {
    static final long serialVersionUID = 1L;
    protected transient double[] _values;

    public TObjectDoubleHashMap() {
    }

    public TObjectDoubleHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectDoubleHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectDoubleHashMap(TObjectHashingStrategy strategy) {
        super(strategy);
    }

    public TObjectDoubleHashMap(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectDoubleHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectDoubleIterator iterator() {
        return new TObjectDoubleIterator(this);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new double[capacity];
        return capacity;
    }

    public double put(Object key, double value) {
        double previous = 0.0;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        Object oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == FREE);
        }
        return previous;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        double[] oldVals = this._values;
        this._set = new Object[newCapacity];
        Arrays.fill(this._set, FREE);
        this._values = new double[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == FREE || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            if (index < 0) {
                this.throwObjectContractViolation(this._set[-index - 1], o);
            }
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public double get(Object key) {
        int index = this.index(key);
        return index < 0 ? 0.0 : this._values[index];
    }

    public void clear() {
        super.clear();
        Object[] keys = this._set;
        double[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = FREE;
            vals[i] = 0.0;
        }
    }

    public double remove(Object key) {
        double prev = 0.0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectDoubleHashMap)) {
            return false;
        }
        TObjectDoubleHashMap that = (TObjectDoubleHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = 0.0;
    }

    public double[] getValues() {
        double[] vals = new double[this.size()];
        double[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == FREE || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(double val) {
        Object[] keys = this._set;
        double[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    public boolean forEachKey(TObjectProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TDoubleProcedure procedure) {
        Object[] keys = this._set;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectDoubleProcedure procedure) {
        Object[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectDoubleProcedure procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        double[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TDoubleFunction function) {
        Object[] keys = this._set;
        double[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == FREE || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(Object key) {
        return this.adjustValue(key, 1.0);
    }

    public boolean adjustValue(Object key, double amount) {
        int index = this.index(key);
        if (index < 0) {
            return false;
        }
        int n = index;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            double val = stream.readDouble();
            this.put(key, val);
        }
    }

    private static final class EqProcedure
    implements TObjectDoubleProcedure {
        private final TObjectDoubleHashMap _otherMap;

        EqProcedure(TObjectDoubleHashMap otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(Object key, double value) {
            int index = this._otherMap.index(key);
            return index >= 0 && this.eq(value, this._otherMap.get(key));
        }

        private final boolean eq(double v1, double v2) {
            return v1 == v2;
        }
    }
}

