/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser.io;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.io.CONLLReader;
import edu.upenn.seas.mstparser.io.MSTReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public abstract class DependencyReader {
    protected BufferedReader inputReader;
    protected boolean labeled = true;

    public static DependencyReader createDependencyReader(String format, boolean discourseMode) throws IOException {
        if (format.equals("MST")) {
            return new MSTReader();
        }
        if (format.equals("CONLL")) {
            return new CONLLReader(discourseMode);
        }
        System.out.println("!!!!!!!  Not a supported format: " + format);
        System.out.println("********* Assuming CONLL format. **********");
        return new CONLLReader(discourseMode);
    }

    public static DependencyReader createDependencyReader(String format) throws IOException {
        return DependencyReader.createDependencyReader(format, false);
    }

    public boolean startReading(String content, boolean fileAccess) throws IOException {
        this.labeled = this.fileContainsLabels(content, fileAccess);
        this.inputReader = new BufferedReader(this.getReader(content, fileAccess));
        return this.labeled;
    }

    protected Reader getReader(String content, boolean fileAccess) throws IOException {
        if (fileAccess) {
            return new InputStreamReader((InputStream)new FileInputStream(content), "UTF8");
        }
        return new StringReader(content);
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public abstract DependencyInstance getNext() throws IOException;

    protected abstract boolean fileContainsLabels(String var1, boolean var2) throws IOException;

    protected String normalize(String s) {
        if (s.matches("[0-9]+|[0-9]+\\.[0-9]+|[0-9]+[0-9,]+")) {
            return "<num>";
        }
        return s;
    }
}

