/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RelationalFeature
implements Serializable {
    public String name;
    public String[][] values;

    public RelationalFeature(int size, String declaration, BufferedReader br) throws IOException {
        this.values = new String[size][size];
        String[] declist = declaration.split(" ");
        this.name = declist[2];
        for (int i = 0; i < size; ++i) {
            this.values[i] = br.readLine().substring(2).split(" ");
        }
    }

    public String getFeature(int firstIndex, int secondIndex) {
        if (firstIndex == 0 || secondIndex == 0) {
            return this.name + "=NULL";
        }
        return this.name + "=" + this.values[firstIndex - 1][secondIndex - 1];
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.values);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.values = (String[][])in.readObject();
    }
}

