/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.BinaryHeap;
import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.ParseForestItem;
import edu.upenn.seas.mstparser.ValueIndexPair;

public class KBestParseForest2O {
    private ParseForestItem[][][][][] chart;
    private String[] sent;
    private String[] pos;
    private int start;
    private int end;
    private int K;

    public KBestParseForest2O(int start, int end, DependencyInstance inst, int K) {
        this.K = K;
        this.chart = new ParseForestItem[end + 1][end + 1][2][3][K];
        this.start = start;
        this.end = end;
        this.sent = inst.forms;
        this.pos = inst.postags;
    }

    public boolean add(int s, int type, int dir, double score, FeatureVector fv) {
        int i;
        boolean added = false;
        if (this.chart[s][s][dir][0][0] == null) {
            for (i = 0; i < this.K; ++i) {
                this.chart[s][s][dir][0][i] = new ParseForestItem(s, type, dir, Double.NEGATIVE_INFINITY, null);
            }
        }
        if (this.chart[s][s][dir][0][this.K - 1].prob > score) {
            return false;
        }
        for (i = 0; i < this.K; ++i) {
            if (!(this.chart[s][s][dir][0][i].prob < score)) continue;
            ParseForestItem tmp = this.chart[s][s][dir][0][i];
            this.chart[s][s][dir][0][i] = new ParseForestItem(s, type, dir, score, fv);
            for (int j = i + 1; j < this.K && tmp.prob != Double.NEGATIVE_INFINITY; ++j) {
                ParseForestItem tmp1 = this.chart[s][s][dir][0][j];
                this.chart[s][s][dir][0][j] = tmp;
                tmp = tmp1;
            }
            added = true;
            break;
        }
        return added;
    }

    public boolean add(int s, int r, int t, int type, int dir, int comp, double score, FeatureVector fv, ParseForestItem p1, ParseForestItem p2) {
        int i;
        boolean added = false;
        if (this.chart[s][t][dir][comp][0] == null) {
            for (i = 0; i < this.K; ++i) {
                this.chart[s][t][dir][comp][i] = new ParseForestItem(s, r, t, type, dir, comp, Double.NEGATIVE_INFINITY, null, null, null);
            }
        }
        if (this.chart[s][t][dir][comp][this.K - 1].prob > score) {
            return false;
        }
        for (i = 0; i < this.K; ++i) {
            if (!(this.chart[s][t][dir][comp][i].prob < score)) continue;
            ParseForestItem tmp = this.chart[s][t][dir][comp][i];
            this.chart[s][t][dir][comp][i] = new ParseForestItem(s, r, t, type, dir, comp, score, fv, p1, p2);
            for (int j = i + 1; j < this.K && tmp.prob != Double.NEGATIVE_INFINITY; ++j) {
                ParseForestItem tmp1 = this.chart[s][t][dir][comp][j];
                this.chart[s][t][dir][comp][j] = tmp;
                tmp = tmp1;
            }
            added = true;
            break;
        }
        return added;
    }

    public double getProb(int s, int t, int dir, int comp) {
        return this.getProb(s, t, dir, comp, 0);
    }

    public double getProb(int s, int t, int dir, int comp, int i) {
        if (this.chart[s][t][dir][comp][i] != null) {
            return this.chart[s][t][dir][comp][i].prob;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double[] getProbs(int s, int t, int dir, int comp) {
        double[] result = new double[this.K];
        for (int i = 0; i < this.K; ++i) {
            result[i] = this.chart[s][t][dir][comp][i] != null ? this.chart[s][t][dir][comp][i].prob : Double.NEGATIVE_INFINITY;
        }
        return result;
    }

    public ParseForestItem getItem(int s, int t, int dir, int comp) {
        return this.getItem(s, t, dir, comp, 0);
    }

    public ParseForestItem getItem(int s, int t, int dir, int comp, int i) {
        if (this.chart[s][t][dir][comp][i] != null) {
            return this.chart[s][t][dir][comp][i];
        }
        return null;
    }

    public ParseForestItem[] getItems(int s, int t, int dir, int comp) {
        if (this.chart[s][t][dir][comp][0] != null) {
            return this.chart[s][t][dir][comp];
        }
        return null;
    }

    public Object[] getBestParse() {
        Object[] d = new Object[]{this.getFeatureVector(this.chart[0][this.end][0][0][0]), this.getDepString(this.chart[0][this.end][0][0][0])};
        return d;
    }

    public Object[][] getBestParses() {
        Object[][] d = new Object[this.K][2];
        for (int k = 0; k < this.K; ++k) {
            if (this.chart[0][this.end][0][0][k].prob != Double.NEGATIVE_INFINITY) {
                d[k][0] = this.getFeatureVector(this.chart[0][this.end][0][0][k]);
                d[k][1] = this.getDepString(this.chart[0][this.end][0][0][k]);
                continue;
            }
            d[k][0] = null;
            d[k][1] = null;
        }
        return d;
    }

    public FeatureVector getFeatureVector(ParseForestItem pfi) {
        if (pfi.left == null) {
            return pfi.fv;
        }
        return this.cat(pfi.fv, this.cat(this.getFeatureVector(pfi.left), this.getFeatureVector(pfi.right)));
    }

    public String getDepString(ParseForestItem pfi) {
        if (pfi.left == null) {
            return "";
        }
        if (pfi.dir == 0 && pfi.comp == 1) {
            return ((this.getDepString(pfi.left) + " " + this.getDepString(pfi.right)).trim() + " " + pfi.s + "|" + pfi.t + ":" + pfi.type).trim();
        }
        if (pfi.dir == 1 && pfi.comp == 1) {
            return (pfi.t + "|" + pfi.s + ":" + pfi.type + " " + (this.getDepString(pfi.left) + " " + this.getDepString(pfi.right)).trim()).trim();
        }
        return (this.getDepString(pfi.left) + " " + this.getDepString(pfi.right)).trim();
    }

    public FeatureVector cat(FeatureVector fv1, FeatureVector fv2) {
        return fv1.cat(fv2);
    }

    public int[][] getKBestPairs(ParseForestItem[] items1, ParseForestItem[] items2) {
        boolean[][] beenPushed = new boolean[this.K][this.K];
        int[][] result = new int[this.K][2];
        for (int i = 0; i < this.K; ++i) {
            result[i][0] = -1;
            result[i][1] = -1;
        }
        BinaryHeap heap = new BinaryHeap(this.K + 1);
        int n = 0;
        ValueIndexPair vip = new ValueIndexPair(items1[0].prob + items2[0].prob, 0, 0);
        heap.add(vip);
        beenPushed[0][0] = true;
        while (n < this.K) {
            vip = heap.removeMax();
            if (vip.val == Double.NEGATIVE_INFINITY) break;
            result[n][0] = vip.i1;
            result[n][1] = vip.i2;
            if (++n >= this.K) break;
            if (!beenPushed[vip.i1 + 1][vip.i2]) {
                heap.add(new ValueIndexPair(items1[vip.i1 + 1].prob + items2[vip.i2].prob, vip.i1 + 1, vip.i2));
                beenPushed[vip.i1 + 1][vip.i2] = true;
            }
            if (beenPushed[vip.i1][vip.i2 + 1]) continue;
            heap.add(new ValueIndexPair(items1[vip.i1].prob + items2[vip.i2 + 1].prob, vip.i1, vip.i2 + 1));
            beenPushed[vip.i1][vip.i2 + 1] = true;
        }
        return result;
    }
}

