/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.ValueIndexPair;

class BinaryHeap {
    private int DEFAULT_CAPACITY;
    private int currentSize;
    private ValueIndexPair[] theArray;

    public BinaryHeap(int def_cap) {
        this.DEFAULT_CAPACITY = def_cap;
        this.theArray = new ValueIndexPair[this.DEFAULT_CAPACITY + 1];
        this.theArray[0] = new ValueIndexPair(Double.POSITIVE_INFINITY, -1, -1);
        this.currentSize = 0;
    }

    public ValueIndexPair getMax() {
        return this.theArray[1];
    }

    private int parent(int i) {
        return i / 2;
    }

    private int leftChild(int i) {
        return 2 * i;
    }

    private int rightChild(int i) {
        return 2 * i + 1;
    }

    public void add(ValueIndexPair e) {
        int where = this.currentSize + 1;
        while (e.compareTo(this.theArray[this.parent(where)]) > 0) {
            this.theArray[where] = this.theArray[this.parent(where)];
            where = this.parent(where);
        }
        this.theArray[where] = e;
        ++this.currentSize;
    }

    public ValueIndexPair removeMax() {
        ValueIndexPair min = this.theArray[1];
        this.theArray[1] = this.theArray[this.currentSize];
        --this.currentSize;
        boolean switched = true;
        int parent = 1;
        while (switched && parent < this.currentSize) {
            switched = false;
            int leftChild = this.leftChild(parent);
            int rightChild = this.rightChild(parent);
            if (leftChild > this.currentSize) continue;
            int largerChild = leftChild;
            if (rightChild <= this.currentSize && this.theArray[rightChild].compareTo(this.theArray[leftChild]) > 0) {
                largerChild = rightChild;
            }
            if (this.theArray[largerChild].compareTo(this.theArray[parent]) <= 0) continue;
            ValueIndexPair temp = this.theArray[largerChild];
            this.theArray[largerChild] = this.theArray[parent];
            this.theArray[parent] = temp;
            parent = largerChild;
            switched = true;
        }
        return min;
    }
}

