/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove.decorator;

import de.julielab.gnu.trove.TShortShortHashMap;
import de.julielab.gnu.trove.TShortShortIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TShortShortHashMapDecorator
extends AbstractMap
implements Map,
Cloneable {
    protected TShortShortHashMap _map;

    public TShortShortHashMapDecorator(TShortShortHashMap map) {
        this._map = map;
    }

    public Object clone() {
        try {
            TShortShortHashMapDecorator copy = (TShortShortHashMapDecorator)super.clone();
            copy._map = (TShortShortHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object put(Object key, Object value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Short && val instanceof Short) {
                    short k = this.unwrapKey(key);
                    short v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        short k = this.unwrapKey(key);
        short v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return TShortShortHashMapDecorator.this._map.size();
            }

            public boolean isEmpty() {
                return TShortShortHashMapDecorator.this.isEmpty();
            }

            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TShortShortHashMapDecorator.this.containsKey(k) && TShortShortHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            public Iterator iterator() {
                return new Iterator(){
                    private final TShortShortIterator it;
                    {
                        this.it = (this).TShortShortHashMapDecorator.this._map.iterator();
                    }

                    public Object next() {
                        this.it.advance();
                        final Short key = TShortShortHashMapDecorator.this.wrapKey(this.it.key());
                        Short v = TShortShortHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry(v){
                            private Object val;
                            {
                                this.val = object;
                            }

                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            public Object getKey() {
                                return key;
                            }

                            public Object getValue() {
                                return this.val;
                            }

                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            public Object setValue(Object value) {
                                this.val = value;
                                return TShortShortHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                TShortShortHashMapDecorator.this.clear();
            }
        };
    }

    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    public int size() {
        return this._map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Short wrapKey(short k) {
        return new Short(k);
    }

    protected short unwrapKey(Object key) {
        return (Short)key;
    }

    protected Short wrapValue(short k) {
        return new Short(k);
    }

    protected short unwrapValue(Object value) {
        return (Short)value;
    }
}

