/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove.decorator;

import de.julielab.gnu.trove.TShortHashSet;
import de.julielab.gnu.trove.TShortIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class TShortHashSetDecorator
extends AbstractSet
implements Set,
Cloneable {
    protected TShortHashSet _set;

    public TShortHashSetDecorator(TShortHashSet set) {
        this._set = set;
    }

    public Object clone() {
        try {
            TShortHashSetDecorator copy = (TShortHashSetDecorator)super.clone();
            copy._set = (TShortHashSet)this._set.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean add(Object value) {
        return this._set.add(this.unwrap(value));
    }

    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Short) {
                    short v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void clear() {
        this._set.clear();
    }

    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    public Iterator iterator() {
        return new Iterator(){
            private final TShortIterator it;
            {
                this.it = TShortHashSetDecorator.this._set.iterator();
            }

            public Object next() {
                return TShortHashSetDecorator.this.wrap(this.it.next());
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public void remove() {
                this.it.remove();
            }
        };
    }

    public int size() {
        return this._set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Short wrap(short k) {
        return new Short(k);
    }

    protected short unwrap(Object value) {
        return (Short)value;
    }
}

