/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove.decorator;

import de.julielab.gnu.trove.TShortFloatHashMap;
import de.julielab.gnu.trove.TShortFloatIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TShortFloatHashMapDecorator
extends AbstractMap
implements Map,
Cloneable {
    protected TShortFloatHashMap _map;

    public TShortFloatHashMapDecorator(TShortFloatHashMap map) {
        this._map = map;
    }

    public Object clone() {
        try {
            TShortFloatHashMapDecorator copy = (TShortFloatHashMapDecorator)super.clone();
            copy._map = (TShortFloatHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Object put(Object key, Object value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Short && val instanceof Float) {
                    short k = this.unwrapKey(key);
                    float v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        short k = this.unwrapKey(key);
        float v = this._map.get(k);
        if (v == 0.0f) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return TShortFloatHashMapDecorator.this._map.size();
            }

            public boolean isEmpty() {
                return TShortFloatHashMapDecorator.this.isEmpty();
            }

            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TShortFloatHashMapDecorator.this.containsKey(k) && TShortFloatHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            public Iterator iterator() {
                return new Iterator(){
                    private final TShortFloatIterator it;
                    {
                        this.it = (this).TShortFloatHashMapDecorator.this._map.iterator();
                    }

                    public Object next() {
                        this.it.advance();
                        final Short key = TShortFloatHashMapDecorator.this.wrapKey(this.it.key());
                        Float v = TShortFloatHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry(v){
                            private Object val;
                            {
                                this.val = object;
                            }

                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            public Object getKey() {
                                return key;
                            }

                            public Object getValue() {
                                return this.val;
                            }

                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            public Object setValue(Object value) {
                                this.val = value;
                                return TShortFloatHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            public boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                TShortFloatHashMapDecorator.this.clear();
            }
        };
    }

    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    public int size() {
        return this._map.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Short wrapKey(short k) {
        return new Short(k);
    }

    protected short unwrapKey(Object key) {
        return (Short)key;
    }

    protected Float wrapValue(float k) {
        return new Float(k);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }
}

