/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove;

import de.julielab.gnu.trove.TIterator;
import de.julielab.gnu.trove.TObjectDoubleHashMap;
import de.julielab.gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;

public class TObjectDoubleIterator
extends TIterator {
    private final TObjectDoubleHashMap _map;

    public TObjectDoubleIterator(TObjectDoubleHashMap map) {
        super(map);
        this._map = map;
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == TObjectHash.FREE || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public Object key() {
        return this._map._set[this._index];
    }

    public double value() {
        return this._map._values[this._index];
    }

    public double setValue(double val) {
        double old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

