/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.gnu.trove;

import de.julielab.gnu.trove.HashFunctions;
import de.julielab.gnu.trove.TDoubleHashingStrategy;
import de.julielab.gnu.trove.TDoubleProcedure;
import de.julielab.gnu.trove.TPrimitiveHash;
import java.io.Serializable;

public abstract class TDoubleHash
extends TPrimitiveHash
implements Serializable,
TDoubleHashingStrategy {
    protected transient double[] _set;
    protected TDoubleHashingStrategy _hashingStrategy;

    public TDoubleHash() {
        this._hashingStrategy = this;
    }

    public TDoubleHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TDoubleHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TDoubleHash(TDoubleHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TDoubleHash(int initialCapacity, TDoubleHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TDoubleHash(int initialCapacity, float loadFactor, TDoubleHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public Object clone() {
        TDoubleHash h = (TDoubleHash)super.clone();
        h._set = (double[])this._set.clone();
        return h;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new double[capacity];
        return capacity;
    }

    public boolean contains(double val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TDoubleProcedure procedure) {
        byte[] states = this._states;
        double[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._set[index] = 0.0;
    }

    protected int index(double val) {
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(double val) {
        byte[] states = this._states;
        double[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states[index] != 2) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] == 1 && set[index] != val);
        }
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    public final int computeHashCode(double val) {
        return HashFunctions.hash(val);
    }
}

