/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import de.julielab.gnu.trove.TIntArrayList;
import de.julielab.gnu.trove.TIntDoubleHashMap;
import de.julielab.gnu.trove.TLinkedList;
import edu.upenn.seas.mstparser.Feature;
import java.util.ListIterator;

public final class FeatureVector
extends TLinkedList {
    private FeatureVector subfv1 = null;
    private FeatureVector subfv2 = null;
    private boolean negateSecondSubFV = false;

    public FeatureVector() {
    }

    public FeatureVector(FeatureVector fv1) {
        this.subfv1 = fv1;
    }

    public FeatureVector(FeatureVector fv1, FeatureVector fv2) {
        this.subfv1 = fv1;
        this.subfv2 = fv2;
    }

    public FeatureVector(FeatureVector fv1, FeatureVector fv2, boolean negSecond) {
        this.subfv1 = fv1;
        this.subfv2 = fv2;
        this.negateSecondSubFV = negSecond;
    }

    public FeatureVector(int[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            this.add((Object)new Feature(keys[i], 1.0));
        }
    }

    public void add(int index, double value) {
        this.add((Object)new Feature(index, value));
    }

    public int[] keys() {
        TIntArrayList keys = new TIntArrayList();
        this.addKeysToList(keys);
        return keys.toNativeArray();
    }

    private void addKeysToList(TIntArrayList keys) {
        if (null != this.subfv1) {
            this.subfv1.addKeysToList(keys);
            if (null != this.subfv2) {
                this.subfv2.addKeysToList(keys);
            }
        }
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            keys.add(((Feature)((Object)it.next())).index);
        }
    }

    public final FeatureVector cat(FeatureVector fl2) {
        return new FeatureVector(this, fl2);
    }

    public FeatureVector getDistVector(FeatureVector fl2) {
        return new FeatureVector(this, fl2, true);
    }

    public final double getScore(double[] parameters) {
        return this.getScore(parameters, false);
    }

    private final double getScore(double[] parameters, boolean negate) {
        double score = 0.0;
        if (null != this.subfv1) {
            score += this.subfv1.getScore(parameters, negate);
            if (null != this.subfv2) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        ListIterator it = this.listIterator();
        if (negate) {
            while (it.hasNext()) {
                Feature f = (Feature)((Object)it.next());
                score -= parameters[f.index] * f.value;
            }
        } else {
            while (it.hasNext()) {
                Feature f = (Feature)((Object)it.next());
                score += parameters[f.index] * f.value;
            }
        }
        return score;
    }

    public void update(double[] parameters, double[] total, double alpha_k, double upd) {
        this.update(parameters, total, alpha_k, upd, false);
    }

    private final void update(double[] parameters, double[] total, double alpha_k, double upd, boolean negate) {
        if (null != this.subfv1) {
            this.subfv1.update(parameters, total, alpha_k, upd, negate);
            if (null != this.subfv2) {
                if (negate) {
                    this.subfv2.update(parameters, total, alpha_k, upd, !this.negateSecondSubFV);
                } else {
                    this.subfv2.update(parameters, total, alpha_k, upd, this.negateSecondSubFV);
                }
            }
        }
        ListIterator it = this.listIterator();
        if (negate) {
            while (it.hasNext()) {
                Feature f = (Feature)((Object)it.next());
                int n = f.index;
                parameters[n] = parameters[n] - alpha_k * f.value;
                int n2 = f.index;
                total[n2] = total[n2] - upd * alpha_k * f.value;
            }
        } else {
            while (it.hasNext()) {
                Feature f = (Feature)((Object)it.next());
                int n = f.index;
                parameters[n] = parameters[n] + alpha_k * f.value;
                int n3 = f.index;
                total[n3] = total[n3] + upd * alpha_k * f.value;
            }
        }
    }

    public double dotProduct(FeatureVector fl2) {
        TIntDoubleHashMap hm1 = new TIntDoubleHashMap(this.size());
        this.addFeaturesToMap(hm1, false);
        hm1.compact();
        TIntDoubleHashMap hm2 = new TIntDoubleHashMap(fl2.size());
        fl2.addFeaturesToMap(hm2, false);
        hm2.compact();
        int[] keys = hm1.keys();
        double result = 0.0;
        for (int i = 0; i < keys.length; ++i) {
            result += hm1.get(keys[i]) * hm2.get(keys[i]);
        }
        return result;
    }

    private void addFeaturesToMap(TIntDoubleHashMap map, boolean negate) {
        if (null != this.subfv1) {
            this.subfv1.addFeaturesToMap(map, negate);
            if (null != this.subfv2) {
                if (negate) {
                    this.subfv2.addFeaturesToMap(map, !this.negateSecondSubFV);
                } else {
                    this.subfv2.addFeaturesToMap(map, this.negateSecondSubFV);
                }
            }
        }
        ListIterator it = this.listIterator();
        if (negate) {
            while (it.hasNext()) {
                Feature f = (Feature)((Object)it.next());
                if (map.adjustValue(f.index, -f.value)) continue;
                map.put(f.index, -f.value);
            }
        } else {
            while (it.hasNext()) {
                Feature f = (Feature)((Object)it.next());
                if (map.adjustValue(f.index, f.value)) continue;
                map.put(f.index, f.value);
            }
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private final void toString(StringBuilder sb) {
        if (null != this.subfv1) {
            this.subfv1.toString(sb);
            if (null != this.subfv2) {
                this.subfv2.toString(sb);
            }
        }
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append(' ');
        }
    }
}

