/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.Alphabet;
import edu.upenn.seas.mstparser.DependencyDecoder;
import edu.upenn.seas.mstparser.DependencyDecoder2O;
import edu.upenn.seas.mstparser.DependencyEvaluator;
import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.DependencyPipe;
import edu.upenn.seas.mstparser.DependencyPipe2O;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.Parameters;
import edu.upenn.seas.mstparser.ParserOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class DependencyParser {
    public ParserOptions options;
    private DependencyPipe pipe;
    private DependencyDecoder decoder;
    private Parameters params;

    public DependencyParser(DependencyPipe pipe, ParserOptions options) {
        this.pipe = pipe;
        this.options = options;
        this.params = new Parameters(pipe.dataAlphabet.size());
        this.decoder = options.secondOrder ? new DependencyDecoder2O(pipe) : new DependencyDecoder(pipe);
    }

    public void train(int[] instanceLengths, String trainfile, File train_forest) throws IOException {
        int i = 0;
        for (i = 0; i < this.options.numIters; ++i) {
            long start = System.currentTimeMillis();
            this.trainingIter(instanceLengths, trainfile, train_forest, i + 1);
            long l = System.currentTimeMillis();
        }
        this.params.averageParams(i * instanceLengths.length);
    }

    private void trainingIter(int[] instanceLengths, String trainfile, File train_forest, int iter) throws IOException {
        boolean numUpd = false;
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(train_forest));
        boolean evaluateI = true;
        int numInstances = instanceLengths.length;
        for (int i = 0; i < numInstances; ++i) {
            if ((i + 1) % 500 == 0) {
                System.out.print(i + 1 + ",");
            }
            int length = instanceLengths[i];
            FeatureVector[][][] fvs = new FeatureVector[length][length][2];
            double[][][] probs = new double[length][length][2];
            FeatureVector[][][][] nt_fvs = new FeatureVector[length][this.pipe.types.length][2][2];
            double[][][][] nt_probs = new double[length][this.pipe.types.length][2][2];
            FeatureVector[][][] fvs_trips = new FeatureVector[length][length][length];
            double[][][] probs_trips = new double[length][length][length];
            FeatureVector[][][] fvs_sibs = new FeatureVector[length][length][2];
            double[][][] probs_sibs = new double[length][length][2];
            DependencyInstance inst = this.options.secondOrder ? ((DependencyPipe2O)this.pipe).readInstance(in, length, fvs, probs, fvs_trips, probs_trips, fvs_sibs, probs_sibs, nt_fvs, nt_probs, this.params) : this.pipe.readInstance(in, length, fvs, probs, nt_fvs, nt_probs, this.params);
            double upd = this.options.numIters * numInstances - (numInstances * (iter - 1) + i + 1) + 1;
            int K = this.options.trainK;
            Object[][] d = null;
            if (this.options.decodeType.equals("proj")) {
                d = this.options.secondOrder ? ((DependencyDecoder2O)this.decoder).decodeProjective(inst, fvs, probs, fvs_trips, probs_trips, fvs_sibs, probs_sibs, nt_fvs, nt_probs, K) : this.decoder.decodeProjective(inst, fvs, probs, nt_fvs, nt_probs, K);
            }
            if (this.options.decodeType.equals("non-proj")) {
                d = this.options.secondOrder ? ((DependencyDecoder2O)this.decoder).decodeNonProjective(inst, fvs, probs, fvs_trips, probs_trips, fvs_sibs, probs_sibs, nt_fvs, nt_probs, K) : this.decoder.decodeNonProjective(inst, fvs, probs, nt_fvs, nt_probs, K);
            }
            this.params.updateParamsMIRA(inst, d, upd);
        }
        in.close();
    }

    public void saveModel(String file) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        out.writeObject(this.params.parameters);
        out.writeObject(this.pipe.dataAlphabet);
        out.writeObject(this.pipe.typeAlphabet);
        out.close();
    }

    public void loadModel(String file) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        this.params.parameters = (double[])in.readObject();
        this.pipe.dataAlphabet = (Alphabet)in.readObject();
        this.pipe.typeAlphabet = (Alphabet)in.readObject();
        in.close();
        this.pipe.closeAlphabets();
    }

    public void setParameters(double[] parameters) {
        this.params.parameters = parameters;
    }

    public String outputParses() throws IOException {
        return this.outputParses(null);
    }

    public String outputParses(String content) throws IOException {
        boolean fileAccess = content == null || content.length() <= 0;
        String tFile = this.options.testfile;
        String file = this.options.outfile;
        long start = System.currentTimeMillis();
        if (fileAccess) {
            System.out.println("file access " + this.options.testfile);
            this.pipe.initInputFile(tFile, fileAccess);
        } else {
            this.pipe.initInputFile(content, fileAccess);
        }
        this.pipe.initOutputFile(file);
        DependencyInstance instance = this.pipe.nextInstance();
        int cnt = 0;
        String result = "";
        while (instance != null) {
            ++cnt;
            Object[] forms = instance.forms;
            int length = forms.length;
            FeatureVector[][][] fvs = new FeatureVector[forms.length][forms.length][2];
            double[][][] probs = new double[forms.length][forms.length][2];
            FeatureVector[][][][] nt_fvs = new FeatureVector[forms.length][this.pipe.types.length][2][2];
            double[][][][] nt_probs = new double[forms.length][this.pipe.types.length][2][2];
            FeatureVector[][][] fvs_trips = new FeatureVector[length][length][length];
            double[][][] probs_trips = new double[length][length][length];
            FeatureVector[][][] fvs_sibs = new FeatureVector[length][length][2];
            double[][][] probs_sibs = new double[length][length][2];
            if (this.options.secondOrder) {
                ((DependencyPipe2O)this.pipe).fillFeatureVectors(instance, fvs, probs, fvs_trips, probs_trips, fvs_sibs, probs_sibs, nt_fvs, nt_probs, this.params);
            } else {
                this.pipe.fillFeatureVectors(instance, fvs, probs, nt_fvs, nt_probs, this.params);
            }
            int K = this.options.testK;
            Object[][] d = null;
            if (this.options.decodeType.equals("proj")) {
                d = this.options.secondOrder ? ((DependencyDecoder2O)this.decoder).decodeProjective(instance, fvs, probs, fvs_trips, probs_trips, fvs_sibs, probs_sibs, nt_fvs, nt_probs, K) : this.decoder.decodeProjective(instance, fvs, probs, nt_fvs, nt_probs, K);
            }
            if (this.options.decodeType.equals("non-proj")) {
                d = this.options.secondOrder ? ((DependencyDecoder2O)this.decoder).decodeNonProjective(instance, fvs, probs, fvs_trips, probs_trips, fvs_sibs, probs_sibs, nt_fvs, nt_probs, K) : this.decoder.decodeNonProjective(instance, fvs, probs, nt_fvs, nt_probs, K);
            }
            Object[] res = ((String)d[0][1]).split(" ");
            String[] pos = instance.cpostags;
            String[] formsNoRoot = new String[forms.length - 1];
            String[] posNoRoot = new String[formsNoRoot.length];
            String[] labels = new String[formsNoRoot.length];
            int[] heads = new int[formsNoRoot.length];
            Arrays.toString(forms);
            Arrays.toString(res);
            for (int j = 0; j < formsNoRoot.length; ++j) {
                formsNoRoot[j] = forms[j + 1];
                posNoRoot[j] = pos[j + 1];
                String[] trip = ((String)res[j]).split("[\\|:]");
                labels[j] = this.pipe.types[Integer.parseInt(trip[2])];
                heads[j] = Integer.parseInt(trip[0]);
            }
            result = this.pipe.outputInstance(new DependencyInstance(formsNoRoot, posNoRoot, labels, heads), fileAccess);
            instance = this.pipe.nextInstance();
        }
        this.pipe.close();
        long end = System.currentTimeMillis();
        return result;
    }

    public static void main(String[] args) throws FileNotFoundException, Exception {
        DependencyPipe pipe;
        ParserOptions options = new ParserOptions(args);
        if (options.train) {
            pipe = options.secondOrder ? new DependencyPipe2O(options) : new DependencyPipe(options);
            int[] instanceLengths = pipe.createInstances(options.trainfile, options.trainforest, true);
            pipe.closeAlphabets();
            DependencyParser dp = new DependencyParser(pipe, options);
            int numFeats = pipe.dataAlphabet.size();
            int numTypes = pipe.typeAlphabet.size();
            System.out.print("Num Feats: " + numFeats);
            System.out.println(".\tNum Edge Labels: " + numTypes);
            System.out.println("Instance length " + instanceLengths.length);
            dp.train(instanceLengths, options.trainfile, options.trainforest);
            System.out.print("Saving model...");
            dp.saveModel(options.modelName);
            System.out.print("done.");
        }
        if (options.test) {
            pipe = options.secondOrder ? new DependencyPipe2O(options) : new DependencyPipe(options);
            DependencyParser dp = new DependencyParser(pipe, options);
            System.out.print("\tLoading model..." + options.modelName);
            dp.loadModel(options.modelName);
            System.out.println("done.");
            pipe.closeAlphabets();
            dp.outputParses(null);
        }
        System.out.println();
        if (options.eval) {
            System.out.println("\nEVALUATION PERFORMANCE:");
            DependencyEvaluator.evaluate(options.goldfile, options.outfile, options.format, true);
        }
    }
}

