/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import java.io.File;
import java.io.IOException;

public final class CopyOfParserOptions {
    public String trainfile = null;
    public String testfile = null;
    public File trainforest = null;
    public File testforest = null;
    public boolean train = false;
    public boolean eval = false;
    public boolean test = false;
    public String modelName = "dep.model";
    public String lossType = "punc";
    public boolean createForest = true;
    public String decodeType = "proj";
    public String format = "CONLL";
    public int numIters = 10;
    public String outfile = "out.txt";
    public String goldfile = null;
    public int trainK = 1;
    public int testK = 1;
    public boolean secondOrder = false;
    public boolean useRelationalFeatures = false;
    public boolean discourseMode = false;

    public CopyOfParserOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String[] pair = args[i].split(":");
            if (pair[0].equals("train")) {
                this.train = true;
            }
            if (pair[0].equals("eval")) {
                this.eval = true;
            }
            if (pair[0].equals("test")) {
                this.test = true;
            }
            if (pair[0].equals("iters")) {
                this.numIters = Integer.parseInt(pair[1]);
            }
            if (pair[0].equals("output-file")) {
                this.outfile = pair[1];
            }
            if (pair[0].equals("gold-file")) {
                this.goldfile = pair[1];
            }
            if (pair[0].equals("train-file")) {
                this.trainfile = pair[1];
            }
            if (pair[0].equals("test-file")) {
                this.testfile = pair[1];
            }
            if (pair[0].equals("model-name")) {
                this.modelName = pair[1];
            }
            if (pair[0].equals("training-k")) {
                this.trainK = Integer.parseInt(pair[1]);
            }
            if (pair[0].equals("loss-type")) {
                this.lossType = pair[1];
            }
            if (pair[0].equals("order") && pair[1].equals("2")) {
                this.secondOrder = true;
            }
            if (pair[0].equals("create-forest")) {
                boolean bl = this.createForest = pair[1].equals("true");
            }
            if (pair[0].equals("decode-type")) {
                this.decodeType = pair[1];
            }
            if (pair[0].equals("format")) {
                this.format = pair[1];
            }
            if (pair[0].equals("relational-features")) {
                boolean bl = this.useRelationalFeatures = pair[1].equals("true");
            }
            if (!pair[0].equals("discourse-mode")) continue;
            this.discourseMode = pair[1].equals("true");
        }
        try {
            File tmpDir = new File("/tmp");
            if (null != this.trainfile) {
                this.trainforest = File.createTempFile("train", ".forest");
                this.trainforest.deleteOnExit();
            }
            if (null != this.testfile) {
                this.testforest = File.createTempFile("test", ".forest");
                this.testforest.deleteOnExit();
            }
        }
        catch (IOException e) {
            System.out.println("Unable to create tmp files for feature forests!");
            System.out.println(e);
            System.exit(0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FLAGS [");
        sb.append("train-file: " + this.trainfile);
        sb.append(" | ");
        sb.append("test-file: " + this.testfile);
        sb.append(" | ");
        sb.append("gold-file: " + this.goldfile);
        sb.append(" | ");
        sb.append("output-file: " + this.outfile);
        sb.append(" | ");
        sb.append("model-name: " + this.modelName);
        sb.append(" | ");
        sb.append("train: " + this.train);
        sb.append(" | ");
        sb.append("test: " + this.test);
        sb.append(" | ");
        sb.append("eval: " + this.eval);
        sb.append(" | ");
        sb.append("loss-type: " + this.lossType);
        sb.append(" | ");
        sb.append("second-order: " + this.secondOrder);
        sb.append(" | ");
        sb.append("training-iterations: " + this.numIters);
        sb.append(" | ");
        sb.append("training-k: " + this.trainK);
        sb.append(" | ");
        sb.append("decode-type: " + this.decodeType);
        sb.append(" | ");
        sb.append("create-forest: " + this.createForest);
        sb.append(" | ");
        sb.append("format: " + this.format);
        sb.append(" | ");
        sb.append("relational-features: " + this.useRelationalFeatures);
        sb.append(" | ");
        sb.append("discourse-mode: " + this.discourseMode);
        sb.append("]\n");
        return sb.toString();
    }
}

