/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser.io;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.io.CONLLWriter;
import edu.upenn.seas.mstparser.io.MSTWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public abstract class DependencyWriter {
    protected BufferedWriter writer;
    protected boolean labeled = false;

    public static DependencyWriter createDependencyWriter(String format, boolean labeled) throws IOException {
        if (format.equals("MST")) {
            return new MSTWriter(labeled);
        }
        if (format.equals("CONLL")) {
            return new CONLLWriter(labeled);
        }
        System.out.println("!!!!!!!  Not a supported format: " + format);
        System.out.println("********* Assuming CONLL format. **********");
        return new CONLLWriter(labeled);
    }

    public void startWriting(String file) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
    }

    public void finishWriting() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    public boolean isLabeled() {
        return this.labeled;
    }

    public abstract String write(DependencyInstance var1, boolean var2) throws IOException;
}

