/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser.io;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.Util;
import edu.upenn.seas.mstparser.io.DependencyReader;
import java.io.BufferedReader;
import java.io.IOException;

public class MSTReader
extends DependencyReader {
    @Override
    public DependencyInstance getNext() throws IOException {
        String line = this.inputReader.readLine();
        String pos_line = this.inputReader.readLine();
        String deprel_line = this.labeled ? this.inputReader.readLine() : pos_line;
        String heads_line = this.inputReader.readLine();
        this.inputReader.readLine();
        if (line == null) {
            this.inputReader.close();
            return null;
        }
        String[] forms = line.split("\t");
        String[] pos = pos_line.split("\t");
        String[] deprels = deprel_line.split("\t");
        int[] heads = Util.stringsToInts(heads_line.split("\t"));
        String[] forms_new = new String[forms.length + 1];
        String[] pos_new = new String[pos.length + 1];
        String[] deprels_new = new String[deprels.length + 1];
        int[] heads_new = new int[heads.length + 1];
        forms_new[0] = "<root>";
        pos_new[0] = "<root-POS>";
        deprels_new[0] = "<no-type>";
        heads_new[0] = -1;
        int i = 0;
        while (i < forms.length) {
            forms_new[i + 1] = this.normalize(forms[i]);
            pos_new[i + 1] = pos[i];
            deprels_new[i + 1] = this.labeled ? deprels[i] : "<no-type>";
            heads_new[i + 1] = heads[i];
            ++i;
        }
        DependencyInstance instance = new DependencyInstance(forms_new, pos_new, deprels_new, heads_new);
        String[] cpostags = new String[pos_new.length];
        cpostags[0] = "<root-CPOS>";
        int i2 = 1;
        while (i2 < pos_new.length) {
            cpostags[i2] = pos_new[i2].substring(0, 1);
            ++i2;
        }
        instance.cpostags = cpostags;
        String[] lemmas = new String[forms_new.length];
        cpostags[0] = "<root-LEMMA>";
        int i3 = 1;
        while (i3 < forms_new.length) {
            int formLength = forms_new[i3].length();
            lemmas[i3] = formLength > 5 ? forms_new[i3].substring(0, 5) : forms_new[i3];
            ++i3;
        }
        instance.lemmas = lemmas;
        instance.feats = new String[0][0];
        return instance;
    }

    @Override
    protected boolean fileContainsLabels(String content, boolean fileAccess) throws IOException {
        BufferedReader in = new BufferedReader(this.getReader(content, fileAccess));
        in.readLine();
        in.readLine();
        in.readLine();
        String line = in.readLine();
        in.close();
        return line.trim().length() > 0;
    }
}

