/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser.io;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.RelationalFeature;
import edu.upenn.seas.mstparser.io.DependencyReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class CONLLReader
extends DependencyReader {
    protected boolean discourseMode = false;

    public CONLLReader(boolean discourseMode) {
        this.discourseMode = discourseMode;
    }

    @Override
    public DependencyInstance getNext() throws IOException {
        ArrayList<String[]> lineList = new ArrayList<String[]>();
        String line = this.inputReader.readLine();
        while (line != null && !line.equals("") && !line.startsWith("*")) {
            lineList.add(line.split("\t"));
            line = this.inputReader.readLine();
        }
        int length = lineList.size();
        if (length == 0) {
            this.inputReader.close();
            return null;
        }
        String[] forms = new String[length + 1];
        String[] lemmas = new String[length + 1];
        String[] cpos = new String[length + 1];
        String[] pos = new String[length + 1];
        String[][] feats = new String[length + 1][];
        String[] deprels = new String[length + 1];
        int[] heads = new int[length + 1];
        forms[0] = "<root>";
        lemmas[0] = "<root-LEMMA>";
        cpos[0] = "<root-CPOS>";
        pos[0] = "<root-POS>";
        deprels[0] = "<no-type>";
        heads[0] = -1;
        int i = 0;
        while (i < length) {
            String[] info = (String[])lineList.get(i);
            forms[i + 1] = this.normalize(info[1]);
            lemmas[i + 1] = this.normalize(info[2]);
            cpos[i + 1] = info[3];
            pos[i + 1] = info[4];
            feats[i + 1] = info[5].split("\\|");
            deprels[i + 1] = this.labeled ? info[7] : "<no-type>";
            heads[i + 1] = Integer.parseInt(info[6]);
            ++i;
        }
        feats[0] = new String[feats[1].length];
        i = 0;
        while (i < feats[1].length) {
            feats[0][i] = "<root-feat>" + i;
            ++i;
        }
        if (this.discourseMode) {
            String[][] extended_feats = new String[feats[0].length][length + 1];
            int i2 = 0;
            while (i2 < extended_feats.length) {
                int j = 0;
                while (j < length + 1) {
                    extended_feats[i2][j] = feats[j][i2];
                    ++j;
                }
                ++i2;
            }
            feats = extended_feats;
        }
        ArrayList<RelationalFeature> rfeats = new ArrayList<RelationalFeature>();
        while (line != null && !line.equals("")) {
            rfeats.add(new RelationalFeature(length, line, this.inputReader));
            line = this.inputReader.readLine();
        }
        RelationalFeature[] rfeatsList = new RelationalFeature[rfeats.size()];
        rfeats.toArray(rfeatsList);
        return new DependencyInstance(forms, lemmas, cpos, pos, feats, deprels, heads, rfeatsList);
    }

    @Override
    protected boolean fileContainsLabels(String content, boolean fileAccess) throws IOException {
        BufferedReader in = new BufferedReader(this.getReader(content, fileAccess));
        String line = in.readLine();
        in.close();
        return line.trim().length() > 0;
    }
}

