/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.FeatureVector;

public class Parameters {
    private double SCORE = 0.0;
    public double[] parameters;
    public double[] total;
    public String lossType = "punc";

    public Parameters(int size) {
        this.parameters = new double[size];
        this.total = new double[size];
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = 0.0;
            this.total[i] = 0.0;
            ++i;
        }
        this.lossType = "punc";
    }

    public void setLoss(String lt) {
        this.lossType = lt;
    }

    public void averageParams(double avVal) {
        int j = 0;
        while (j < this.total.length) {
            int n = j++;
            this.total[n] = this.total[n] * (1.0 / avVal);
        }
        this.parameters = this.total;
    }

    public void updateParamsMIRA(DependencyInstance inst, Object[][] d, double upd) {
        String actParseTree = inst.actParseTree;
        FeatureVector actFV = inst.fv;
        int K = 0;
        int i = 0;
        while (i < d.length && d[i][0] != null) {
            K = i + 1;
            ++i;
        }
        double[] b = new double[K];
        double[] lam_dist = new double[K];
        FeatureVector[] dist = new FeatureVector[K];
        int k = 0;
        while (k < K) {
            lam_dist[k] = this.getScore(actFV) - this.getScore((FeatureVector)((Object)d[k][0]));
            b[k] = this.numErrors(inst, (String)d[k][1], actParseTree);
            int n = k;
            b[n] = b[n] - lam_dist[k];
            dist[k] = actFV.getDistVector((FeatureVector)((Object)d[k][0]));
            ++k;
        }
        double[] alpha = this.hildreth(dist, b);
        FeatureVector fv = null;
        boolean res = false;
        int k2 = 0;
        while (k2 < K) {
            fv = dist[k2];
            fv.update(this.parameters, this.total, alpha[k2], upd);
            ++k2;
        }
    }

    public double getScore(FeatureVector fv) {
        return fv.getScore(this.parameters);
    }

    private double[] hildreth(FeatureVector[] a, double[] b) {
        int max_iter = 10000;
        double eps = 1.0E-8;
        double zero = 1.0E-12;
        double[] alpha = new double[b.length];
        double[] F = new double[b.length];
        double[] kkt = new double[b.length];
        double max_kkt = Double.NEGATIVE_INFINITY;
        int K = a.length;
        double[][] A = new double[K][K];
        boolean[] is_computed = new boolean[K];
        int i = 0;
        while (i < K) {
            A[i][i] = a[i].dotProduct(a[i]);
            is_computed[i] = false;
            ++i;
        }
        int max_kkt_i = -1;
        i = 0;
        while (i < F.length) {
            F[i] = b[i];
            kkt[i] = F[i];
            if (kkt[i] > max_kkt) {
                max_kkt = kkt[i];
                max_kkt_i = i;
            }
            ++i;
        }
        int iter = 0;
        while (max_kkt >= eps && iter < max_iter) {
            double diff_alpha = A[max_kkt_i][max_kkt_i] <= zero ? 0.0 : F[max_kkt_i] / A[max_kkt_i][max_kkt_i];
            double try_alpha = alpha[max_kkt_i] + diff_alpha;
            double add_alpha = 0.0;
            add_alpha = try_alpha < 0.0 ? -1.0 * alpha[max_kkt_i] : diff_alpha;
            alpha[max_kkt_i] = alpha[max_kkt_i] + add_alpha;
            if (!is_computed[max_kkt_i]) {
                i = 0;
                while (i < K) {
                    A[i][max_kkt_i] = a[i].dotProduct(a[max_kkt_i]);
                    is_computed[max_kkt_i] = true;
                    ++i;
                }
            }
            i = 0;
            while (i < F.length) {
                int n = i;
                F[n] = F[n] - add_alpha * A[i][max_kkt_i];
                kkt[i] = F[i];
                if (alpha[i] > zero) {
                    kkt[i] = Math.abs(F[i]);
                }
                ++i;
            }
            max_kkt = Double.NEGATIVE_INFINITY;
            max_kkt_i = -1;
            i = 0;
            while (i < F.length) {
                if (kkt[i] > max_kkt) {
                    max_kkt = kkt[i];
                    max_kkt_i = i;
                }
                ++i;
            }
            ++iter;
        }
        return alpha;
    }

    public double numErrors(DependencyInstance inst, String pred, String act) {
        if (this.lossType.equals("nopunc")) {
            return this.numErrorsDepNoPunc(inst, pred, act) + this.numErrorsLabelNoPunc(inst, pred, act);
        }
        return this.numErrorsDep(inst, pred, act) + this.numErrorsLabel(inst, pred, act);
    }

    public double numErrorsDep(DependencyInstance inst, String pred, String act) {
        String[] act_spans = act.split(" ");
        String[] pred_spans = pred.split(" ");
        int correct = 0;
        int i = 0;
        while (i < pred_spans.length) {
            String a;
            String p = pred_spans[i].split(":")[0];
            if (p.equals(a = act_spans[i].split(":")[0])) {
                ++correct;
            }
            ++i;
        }
        return (double)act_spans.length - (double)correct;
    }

    public double numErrorsLabel(DependencyInstance inst, String pred, String act) {
        String[] act_spans = act.split(" ");
        String[] pred_spans = pred.split(" ");
        int correct = 0;
        int i = 0;
        while (i < pred_spans.length) {
            String a;
            String p = pred_spans[i].split(":")[1];
            if (p.equals(a = act_spans[i].split(":")[1])) {
                ++correct;
            }
            ++i;
        }
        return (double)act_spans.length - (double)correct;
    }

    public double numErrorsDepNoPunc(DependencyInstance inst, String pred, String act) {
        String[] act_spans = act.split(" ");
        String[] pred_spans = pred.split(" ");
        String[] pos = inst.postags;
        int correct = 0;
        int numPunc = 0;
        int i = 0;
        while (i < pred_spans.length) {
            String p = pred_spans[i].split(":")[0];
            String a = act_spans[i].split(":")[0];
            if (pos[i + 1].matches("[,:.'`]+")) {
                ++numPunc;
            } else if (p.equals(a)) {
                ++correct;
            }
            ++i;
        }
        return (double)act_spans.length - (double)numPunc - (double)correct;
    }

    public double numErrorsLabelNoPunc(DependencyInstance inst, String pred, String act) {
        String[] act_spans = act.split(" ");
        String[] pred_spans = pred.split(" ");
        String[] pos = inst.postags;
        int correct = 0;
        int numPunc = 0;
        int i = 0;
        while (i < pred_spans.length) {
            String p = pred_spans[i].split(":")[1];
            String a = act_spans[i].split(":")[1];
            if (pos[i + 1].matches("[,:.'`]+")) {
                ++numPunc;
            } else if (p.equals(a)) {
                ++correct;
            }
            ++i;
        }
        return (double)act_spans.length - (double)numPunc - (double)correct;
    }
}

