/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.BinaryHeap;
import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.ParseForestItem;
import edu.upenn.seas.mstparser.ValueIndexPair;

public class KBestParseForest {
    public static int rootType;
    public ParseForestItem[][][][][] chart;
    private String[] sent;
    private String[] pos;
    private int start;
    private int end;
    private int K;

    public KBestParseForest(int start, int end, DependencyInstance inst, int K) {
        this.K = K;
        this.chart = new ParseForestItem[end + 1][end + 1][2][2][K];
        this.start = start;
        this.end = end;
        this.sent = inst.forms;
        this.pos = inst.postags;
    }

    public boolean add(int s, int type, int dir, double score, FeatureVector fv) {
        int i;
        boolean added = false;
        if (this.chart[s][s][dir][0][0] == null) {
            i = 0;
            while (i < this.K) {
                this.chart[s][s][dir][0][i] = new ParseForestItem(s, type, dir, Double.NEGATIVE_INFINITY, null);
                ++i;
            }
        }
        if (this.chart[s][s][dir][0][this.K - 1].prob > score) {
            return false;
        }
        i = 0;
        while (i < this.K) {
            if (this.chart[s][s][dir][0][i].prob < score) {
                ParseForestItem tmp = this.chart[s][s][dir][0][i];
                this.chart[s][s][dir][0][i] = new ParseForestItem(s, type, dir, score, fv);
                int j = i + 1;
                while (j < this.K && tmp.prob != Double.NEGATIVE_INFINITY) {
                    ParseForestItem tmp1 = this.chart[s][s][dir][0][j];
                    this.chart[s][s][dir][0][j] = tmp;
                    tmp = tmp1;
                    ++j;
                }
                added = true;
                break;
            }
            ++i;
        }
        return added;
    }

    public boolean add(int s, int r, int t, int type, int dir, int comp, double score, FeatureVector fv, ParseForestItem p1, ParseForestItem p2) {
        int i;
        boolean added = false;
        if (this.chart[s][t][dir][comp][0] == null) {
            i = 0;
            while (i < this.K) {
                this.chart[s][t][dir][comp][i] = new ParseForestItem(s, r, t, type, dir, comp, Double.NEGATIVE_INFINITY, null, null, null);
                ++i;
            }
        }
        if (this.chart[s][t][dir][comp][this.K - 1].prob > score) {
            return false;
        }
        i = 0;
        while (i < this.K) {
            if (this.chart[s][t][dir][comp][i].prob < score) {
                ParseForestItem tmp = this.chart[s][t][dir][comp][i];
                this.chart[s][t][dir][comp][i] = new ParseForestItem(s, r, t, type, dir, comp, score, fv, p1, p2);
                int j = i + 1;
                while (j < this.K && tmp.prob != Double.NEGATIVE_INFINITY) {
                    ParseForestItem tmp1 = this.chart[s][t][dir][comp][j];
                    this.chart[s][t][dir][comp][j] = tmp;
                    tmp = tmp1;
                    ++j;
                }
                added = true;
                break;
            }
            ++i;
        }
        return added;
    }

    public double getProb(int s, int t, int dir, int comp) {
        return this.getProb(s, t, dir, comp, 0);
    }

    public double getProb(int s, int t, int dir, int comp, int i) {
        if (this.chart[s][t][dir][comp][i] != null) {
            return this.chart[s][t][dir][comp][i].prob;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double[] getProbs(int s, int t, int dir, int comp) {
        double[] result = new double[this.K];
        int i = 0;
        while (i < this.K) {
            result[i] = this.chart[s][t][dir][comp][i] != null ? this.chart[s][t][dir][comp][i].prob : Double.NEGATIVE_INFINITY;
            ++i;
        }
        return result;
    }

    public ParseForestItem getItem(int s, int t, int dir, int comp) {
        return this.getItem(s, t, dir, comp, 0);
    }

    public ParseForestItem getItem(int s, int t, int dir, int comp, int k) {
        if (this.chart[s][t][dir][comp][k] != null) {
            return this.chart[s][t][dir][comp][k];
        }
        return null;
    }

    public ParseForestItem[] getItems(int s, int t, int dir, int comp) {
        if (this.chart[s][t][dir][comp][0] != null) {
            return this.chart[s][t][dir][comp];
        }
        return null;
    }

    public Object[] getBestParse() {
        Object[] d = new Object[]{this.getFeatureVector(this.chart[0][this.end][0][0][0]), this.getDepString(this.chart[0][this.end][0][0][0])};
        return d;
    }

    public Object[][] getBestParses() {
        Object[][] d = new Object[this.K][2];
        int k = 0;
        while (k < this.K) {
            if (this.chart[0][this.end][0][0][k].prob != Double.NEGATIVE_INFINITY) {
                d[k][0] = this.getFeatureVector(this.chart[0][this.end][0][0][k]);
                d[k][1] = this.getDepString(this.chart[0][this.end][0][0][k]);
            } else {
                d[k][0] = null;
                d[k][1] = null;
            }
            ++k;
        }
        return d;
    }

    public FeatureVector getFeatureVector(ParseForestItem pfi) {
        if (pfi.left == null) {
            return pfi.fv;
        }
        return this.cat(pfi.fv, this.cat(this.getFeatureVector(pfi.left), this.getFeatureVector(pfi.right)));
    }

    public String getDepString(ParseForestItem pfi) {
        if (pfi.left == null) {
            return "";
        }
        if (pfi.comp == 0) {
            return (String.valueOf(this.getDepString(pfi.left)) + " " + this.getDepString(pfi.right)).trim();
        }
        if (pfi.dir == 0) {
            return (String.valueOf((String.valueOf(this.getDepString(pfi.left)) + " " + this.getDepString(pfi.right)).trim()) + " " + pfi.s + "|" + pfi.t + ":" + pfi.type).trim();
        }
        return (String.valueOf(pfi.t) + "|" + pfi.s + ":" + pfi.type + " " + (String.valueOf(this.getDepString(pfi.left)) + " " + this.getDepString(pfi.right)).trim()).trim();
    }

    public FeatureVector cat(FeatureVector fv1, FeatureVector fv2) {
        return fv1.cat(fv2);
    }

    public int[][] getKBestPairs(ParseForestItem[] items1, ParseForestItem[] items2) {
        boolean[][] beenPushed = new boolean[this.K][this.K];
        int[][] result = new int[this.K][2];
        int i = 0;
        while (i < this.K) {
            result[i][0] = -1;
            result[i][1] = -1;
            ++i;
        }
        if (items1 == null || items2 == null || items1[0] == null || items2[0] == null) {
            return result;
        }
        BinaryHeap heap = new BinaryHeap(this.K + 1);
        int n = 0;
        ValueIndexPair vip = new ValueIndexPair(items1[0].prob + items2[0].prob, 0, 0);
        heap.add(vip);
        beenPushed[0][0] = true;
        while (n < this.K) {
            vip = heap.removeMax();
            if (vip.val == Double.NEGATIVE_INFINITY) break;
            result[n][0] = vip.i1;
            result[n][1] = vip.i2;
            if (++n >= this.K) break;
            if (!beenPushed[vip.i1 + 1][vip.i2]) {
                heap.add(new ValueIndexPair(items1[vip.i1 + 1].prob + items2[vip.i2].prob, vip.i1 + 1, vip.i2));
                beenPushed[vip.i1 + 1][vip.i2] = true;
            }
            if (beenPushed[vip.i1][vip.i2 + 1]) continue;
            heap.add(new ValueIndexPair(items1[vip.i1].prob + items2[vip.i2 + 1].prob, vip.i1, vip.i2 + 1));
            beenPushed[vip.i1][vip.i2 + 1] = true;
        }
        return result;
    }
}

