/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.DependencyPipe;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.Parameters;
import edu.upenn.seas.mstparser.ParserOptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DependencyPipe2O
extends DependencyPipe {
    public DependencyPipe2O(ParserOptions options) throws IOException {
        super(options);
    }

    @Override
    protected void addExtendedFeatures(DependencyInstance instance, FeatureVector fv) {
        int instanceLength = instance.length();
        int[] heads = instance.heads;
        int i = 0;
        while (i < instanceLength) {
            if (heads[i] != -1 || i == 0) {
                int prev = i;
                int j = i + 1;
                while (j < instanceLength) {
                    if (heads[j] == i) {
                        this.addTripFeatures(instance, i, prev, j, fv);
                        this.addSiblingFeatures(instance, prev, j, prev == i, fv);
                        prev = j;
                    }
                    ++j;
                }
                prev = i;
                j = i - 1;
                while (j >= 0) {
                    if (heads[j] == i) {
                        this.addTripFeatures(instance, i, prev, j, fv);
                        this.addSiblingFeatures(instance, prev, j, prev == i, fv);
                        prev = j;
                    }
                    --j;
                }
            }
            ++i;
        }
    }

    public void fillFeatureVectors(DependencyInstance instance, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][] fvs_trips, double[][][] probs_trips, FeatureVector[][][] fvs_sibs, double[][][] probs_sibs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, Parameters params) {
        double prodProb;
        FeatureVector prodFV;
        int w2;
        this.fillFeatureVectors(instance, fvs, probs, nt_fvs, nt_probs, params);
        int instanceLength = instance.length();
        int w1 = 0;
        while (w1 < instanceLength) {
            int w3;
            w2 = w1;
            while (w2 < instanceLength) {
                w3 = w2 + 1;
                while (w3 < instanceLength) {
                    prodFV = new FeatureVector();
                    this.addTripFeatures(instance, w1, w2, w3, prodFV);
                    prodProb = params.getScore(prodFV);
                    fvs_trips[w1][w2][w3] = prodFV;
                    probs_trips[w1][w2][w3] = prodProb;
                    ++w3;
                }
                ++w2;
            }
            w2 = w1;
            while (w2 >= 0) {
                w3 = w2 - 1;
                while (w3 >= 0) {
                    prodFV = new FeatureVector();
                    this.addTripFeatures(instance, w1, w2, w3, prodFV);
                    prodProb = params.getScore(prodFV);
                    fvs_trips[w1][w2][w3] = prodFV;
                    probs_trips[w1][w2][w3] = prodProb;
                    --w3;
                }
                --w2;
            }
            ++w1;
        }
        w1 = 0;
        while (w1 < instanceLength) {
            w2 = 0;
            while (w2 < instanceLength) {
                int wh = 0;
                while (wh < 2) {
                    if (w1 != w2) {
                        prodFV = new FeatureVector();
                        this.addSiblingFeatures(instance, w1, w2, wh == 0, prodFV);
                        prodProb = params.getScore(prodFV);
                        fvs_sibs[w1][w2][wh] = prodFV;
                        probs_sibs[w1][w2][wh] = prodProb;
                    }
                    ++wh;
                }
                ++w2;
            }
            ++w1;
        }
    }

    private final void addSiblingFeatures(DependencyInstance instance, int ch1, int ch2, boolean isST, FeatureVector fv) {
        String[] forms = instance.forms;
        String[] pos = instance.postags;
        String dir = ch1 > ch2 ? "RA" : "LA";
        String ch1_pos = isST ? "STPOS" : pos[ch1];
        String ch2_pos = pos[ch2];
        String ch1_word = isST ? "STWRD" : forms[ch1];
        String ch2_word = forms[ch2];
        this.add("CH_PAIR=" + ch1_pos + "_" + ch2_pos + "_" + dir, 1.0, fv);
        this.add("CH_WPAIR=" + ch1_word + "_" + ch2_word + "_" + dir, 1.0, fv);
        this.add("CH_WPAIRA=" + ch1_word + "_" + ch2_pos + "_" + dir, 1.0, fv);
        this.add("CH_WPAIRB=" + ch1_pos + "_" + ch2_word + "_" + dir, 1.0, fv);
        this.add("ACH_PAIR=" + ch1_pos + "_" + ch2_pos, 1.0, fv);
        this.add("ACH_WPAIR=" + ch1_word + "_" + ch2_word, 1.0, fv);
        this.add("ACH_WPAIRA=" + ch1_word + "_" + ch2_pos, 1.0, fv);
        this.add("ACH_WPAIRB=" + ch1_pos + "_" + ch2_word, 1.0, fv);
        int dist = Math.max(ch1, ch2) - Math.min(ch1, ch2);
        String distBool = "0";
        if (dist > 1) {
            distBool = "1";
        }
        if (dist > 2) {
            distBool = "2";
        }
        if (dist > 3) {
            distBool = "3";
        }
        if (dist > 4) {
            distBool = "4";
        }
        if (dist > 5) {
            distBool = "5";
        }
        if (dist > 10) {
            distBool = "10";
        }
        this.add("SIB_PAIR_DIST=" + distBool + "_" + dir, 1.0, fv);
        this.add("ASIB_PAIR_DIST=" + distBool, 1.0, fv);
        this.add("CH_PAIR_DIST=" + ch1_pos + "_" + ch2_pos + "_" + distBool + "_" + dir, 1.0, fv);
        this.add("ACH_PAIR_DIST=" + ch1_pos + "_" + ch2_pos + "_" + distBool, 1.0, fv);
    }

    private final void addTripFeatures(DependencyInstance instance, int par, int ch1, int ch2, FeatureVector fv) {
        String[] pos = instance.postags;
        String dir = par > ch2 ? "RA" : "LA";
        String par_pos = pos[par];
        String ch1_pos = ch1 == par ? "STPOS" : pos[ch1];
        String ch2_pos = pos[ch2];
        String pTrip = String.valueOf(par_pos) + "_" + ch1_pos + "_" + ch2_pos;
        this.add("POS_TRIP=" + pTrip + "_" + dir, 1.0, fv);
        this.add("APOS_TRIP=" + pTrip, 1.0, fv);
    }

    @Override
    protected void writeExtendedFeatures(DependencyInstance instance, ObjectOutputStream out) throws IOException {
        FeatureVector prodFV;
        int w2;
        int instanceLength = instance.length();
        int w1 = 0;
        while (w1 < instanceLength) {
            int w3;
            w2 = w1;
            while (w2 < instanceLength) {
                w3 = w2 + 1;
                while (w3 < instanceLength) {
                    prodFV = new FeatureVector();
                    this.addTripFeatures(instance, w1, w2, w3, prodFV);
                    out.writeObject(prodFV.keys());
                    ++w3;
                }
                ++w2;
            }
            w2 = w1;
            while (w2 >= 0) {
                w3 = w2 - 1;
                while (w3 >= 0) {
                    prodFV = new FeatureVector();
                    this.addTripFeatures(instance, w1, w2, w3, prodFV);
                    out.writeObject(prodFV.keys());
                    --w3;
                }
                --w2;
            }
            ++w1;
        }
        out.writeInt(-3);
        w1 = 0;
        while (w1 < instanceLength) {
            w2 = 0;
            while (w2 < instanceLength) {
                int wh = 0;
                while (wh < 2) {
                    if (w1 != w2) {
                        prodFV = new FeatureVector();
                        this.addSiblingFeatures(instance, w1, w2, wh == 0, prodFV);
                        out.writeObject(prodFV.keys());
                    }
                    ++wh;
                }
                ++w2;
            }
            ++w1;
        }
        out.writeInt(-3);
    }

    public DependencyInstance readInstance(ObjectInputStream in, int length, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][] fvs_trips, double[][][] probs_trips, FeatureVector[][][] fvs_sibs, double[][][] probs_sibs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, Parameters params) throws IOException {
        try {
            int w2;
            int w1;
            int w12 = 0;
            while (w12 < length) {
                int w22 = w12 + 1;
                while (w22 < length) {
                    int ph = 0;
                    while (ph < 2) {
                        FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                        double prodProb = params.getScore(prodFV);
                        fvs[w12][w22][ph] = prodFV;
                        probs[w12][w22][ph] = prodProb;
                        ++ph;
                    }
                    ++w22;
                }
                ++w12;
            }
            int last = in.readInt();
            if (last != -3) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            if (this.labeled) {
                w1 = 0;
                while (w1 < length) {
                    int t = 0;
                    while (t < this.types.length) {
                        String type = this.types[t];
                        int ph = 0;
                        while (ph < 2) {
                            int ch = 0;
                            while (ch < 2) {
                                FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                                double nt_prob = params.getScore(prodFV);
                                nt_fvs[w1][t][ph][ch] = prodFV;
                                nt_probs[w1][t][ph][ch] = nt_prob;
                                ++ch;
                            }
                            ++ph;
                        }
                        ++t;
                    }
                    ++w1;
                }
                last = in.readInt();
                if (last != -3) {
                    System.out.println("Error reading file.");
                    System.exit(0);
                }
            }
            w1 = 0;
            while (w1 < length) {
                w2 = w1;
                while (w2 < length) {
                    int w3 = w2 + 1;
                    while (w3 < length) {
                        FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                        double prodProb = params.getScore(prodFV);
                        fvs_trips[w1][w2][w3] = prodFV;
                        probs_trips[w1][w2][w3] = prodProb;
                        ++w3;
                    }
                    ++w2;
                }
                w2 = w1;
                while (w2 >= 0) {
                    int w3 = w2 - 1;
                    while (w3 >= 0) {
                        FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                        double prodProb = params.getScore(prodFV);
                        fvs_trips[w1][w2][w3] = prodFV;
                        probs_trips[w1][w2][w3] = prodProb;
                        --w3;
                    }
                    --w2;
                }
                ++w1;
            }
            last = in.readInt();
            if (last != -3) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            w1 = 0;
            while (w1 < length) {
                w2 = 0;
                while (w2 < length) {
                    int wh = 0;
                    while (wh < 2) {
                        if (w1 != w2) {
                            FeatureVector prodFV = new FeatureVector((int[])in.readObject());
                            double prodProb = params.getScore(prodFV);
                            fvs_sibs[w1][w2][wh] = prodFV;
                            probs_sibs[w1][w2][wh] = prodProb;
                        }
                        ++wh;
                    }
                    ++w2;
                }
                ++w1;
            }
            last = in.readInt();
            if (last != -3) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            FeatureVector nfv = new FeatureVector((int[])in.readObject());
            last = in.readInt();
            if (last != -4) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            DependencyInstance marshalledDI = (DependencyInstance)in.readObject();
            marshalledDI.setFeatureVector(nfv);
            last = in.readInt();
            if (last != -1) {
                System.out.println("Error reading file.");
                System.exit(0);
            }
            return marshalledDI;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error reading file.");
            System.exit(0);
            return null;
        }
    }
}

