/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.io.DependencyReader;
import java.io.IOException;

public class DependencyEvaluator {
    public static void evaluate(String act_file, String pred_file, String format, boolean fileAccess) throws IOException {
        DependencyReader predictedReader;
        boolean predLabeled;
        DependencyReader goldReader = DependencyReader.createDependencyReader(format);
        boolean labeled = goldReader.startReading(act_file, fileAccess);
        if (labeled != (predLabeled = (predictedReader = DependencyReader.createDependencyReader(format)).startReading(pred_file, fileAccess))) {
            System.out.println("Gold file and predicted file appear to differ on whether or not they are labeled. Expect problems!!!");
        }
        int total = 0;
        int corr = 0;
        int corrL = 0;
        int numsent = 0;
        int corrsent = 0;
        int corrsentL = 0;
        boolean root_act = false;
        boolean root_guess = false;
        boolean root_corr = false;
        DependencyInstance goldInstance = goldReader.getNext();
        DependencyInstance predInstance = predictedReader.getNext();
        while (goldInstance != null) {
            int instanceLength = goldInstance.length();
            if (instanceLength != predInstance.length()) {
                System.out.println("Lengths do not match on sentence " + numsent);
            }
            int[] goldHeads = goldInstance.heads;
            String[] goldLabels = goldInstance.deprels;
            int[] predHeads = predInstance.heads;
            String[] predLabels = predInstance.deprels;
            boolean whole = true;
            boolean wholeL = true;
            int i = 1;
            while (i < instanceLength) {
                if (predHeads[i] == goldHeads[i]) {
                    ++corr;
                    if (labeled) {
                        if (goldLabels[i].equals(predLabels[i])) {
                            ++corrL;
                        } else {
                            wholeL = false;
                        }
                    }
                } else {
                    whole = false;
                    wholeL = false;
                }
                ++i;
            }
            total += instanceLength - 1;
            if (whole) {
                ++corrsent;
            }
            if (wholeL) {
                ++corrsentL;
            }
            ++numsent;
            goldInstance = goldReader.getNext();
            predInstance = predictedReader.getNext();
        }
        System.out.println("Tokens: " + total);
        System.out.println("Correct: " + corr);
        System.out.println("Unlabeled Accuracy: " + (double)corr / (double)total);
        System.out.println("Unlabeled Complete Correct: " + (double)corrsent / (double)numsent);
        if (labeled) {
            System.out.println("Labeled Accuracy: " + (double)corrL / (double)total);
            System.out.println("Labeled Complete Correct: " + (double)corrsentL / (double)numsent);
        }
    }

    public static void main(String[] args) throws IOException {
        String format = "CONLL";
        if (args.length > 2) {
            format = args[2];
        }
        DependencyEvaluator.evaluate(args[0], args[1], format, true);
    }
}

