/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import de.julielab.gnu.trove.TIntIntHashMap;
import edu.upenn.seas.mstparser.DependencyInstance;
import edu.upenn.seas.mstparser.DependencyPipe;
import edu.upenn.seas.mstparser.FeatureVector;
import edu.upenn.seas.mstparser.KBestParseForest;
import edu.upenn.seas.mstparser.ParseForestItem;
import java.util.ArrayList;
import java.util.Arrays;

public class DependencyDecoder {
    DependencyPipe pipe;

    public DependencyDecoder(DependencyPipe pipe) {
        this.pipe = pipe;
    }

    protected int[][] getTypes(double[][][][] nt_probs, int len) {
        int[][] static_types = new int[len][len];
        int i = 0;
        while (i < len) {
            int j = 0;
            while (j < len) {
                if (i == j) {
                    static_types[i][j] = 0;
                } else {
                    int wh = -1;
                    double best = Double.NEGATIVE_INFINITY;
                    int t = 0;
                    while (t < this.pipe.types.length) {
                        double score = 0.0;
                        score = i < j ? nt_probs[i][t][0][1] + nt_probs[j][t][0][0] : nt_probs[i][t][1][1] + nt_probs[j][t][1][0];
                        if (score > best) {
                            wh = t;
                            best = score;
                        }
                        ++t;
                    }
                    static_types[i][j] = wh;
                }
                ++j;
            }
            ++i;
        }
        return static_types;
    }

    public Object[][] decodeProjective(DependencyInstance inst, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, int K) {
        String[] forms = inst.forms;
        String[] pos = inst.postags;
        int[][] static_types = null;
        if (this.pipe.labeled) {
            static_types = this.getTypes(nt_probs, forms.length);
        }
        KBestParseForest pf = new KBestParseForest(0, forms.length - 1, inst, K);
        int s = 0;
        while (s < forms.length) {
            pf.add(s, -1, 0, 0.0, new FeatureVector());
            pf.add(s, -1, 1, 0.0, new FeatureVector());
            ++s;
        }
        int j = 1;
        while (j < forms.length) {
            int s2 = 0;
            while (s2 < forms.length && s2 + j < forms.length) {
                double bc;
                int comp2;
                int comp1;
                int k;
                int[][] pairs;
                ParseForestItem[] c1;
                ParseForestItem[] b1;
                int t = s2 + j;
                FeatureVector prodFV_st = fvs[s2][t][0];
                FeatureVector prodFV_ts = fvs[s2][t][1];
                double prodProb_st = probs[s2][t][0];
                double prodProb_ts = probs[s2][t][1];
                int type1 = this.pipe.labeled ? static_types[s2][t] : 0;
                int type2 = this.pipe.labeled ? static_types[t][s2] : 0;
                FeatureVector nt_fv_s_01 = nt_fvs[s2][type1][0][1];
                FeatureVector nt_fv_s_10 = nt_fvs[s2][type2][1][0];
                FeatureVector nt_fv_t_00 = nt_fvs[t][type1][0][0];
                FeatureVector nt_fv_t_11 = nt_fvs[t][type2][1][1];
                double nt_prob_s_01 = nt_probs[s2][type1][0][1];
                double nt_prob_s_10 = nt_probs[s2][type2][1][0];
                double nt_prob_t_00 = nt_probs[t][type1][0][0];
                double nt_prob_t_11 = nt_probs[t][type2][1][1];
                double prodProb = 0.0;
                int r = s2;
                while (r <= t) {
                    if (r != t) {
                        b1 = pf.getItems(s2, r, 0, 0);
                        c1 = pf.getItems(r + 1, t, 1, 0);
                        if (b1 != null && c1 != null) {
                            pairs = pf.getKBestPairs(b1, c1);
                            k = 0;
                            while (k < pairs.length) {
                                if (pairs[k][0] == -1 || pairs[k][1] == -1) break;
                                comp1 = pairs[k][0];
                                comp2 = pairs[k][1];
                                bc = b1[comp1].prob + c1[comp2].prob;
                                double prob_fin = bc + prodProb_st;
                                FeatureVector fv_fin = prodFV_st;
                                if (this.pipe.labeled) {
                                    fv_fin = nt_fv_s_01.cat(nt_fv_t_00.cat(fv_fin));
                                    prob_fin += nt_prob_s_01 + nt_prob_t_00;
                                }
                                pf.add(s2, r, t, type1, 0, 1, prob_fin, fv_fin, b1[comp1], c1[comp2]);
                                prob_fin = bc + prodProb_ts;
                                fv_fin = prodFV_ts;
                                if (this.pipe.labeled) {
                                    fv_fin = nt_fv_t_11.cat(nt_fv_s_10.cat(fv_fin));
                                    prob_fin += nt_prob_t_11 + nt_prob_s_10;
                                }
                                pf.add(s2, r, t, type2, 1, 1, prob_fin, fv_fin, b1[comp1], c1[comp2]);
                                ++k;
                            }
                        }
                    }
                    ++r;
                }
                r = s2;
                while (r <= t) {
                    if (r != s2) {
                        b1 = pf.getItems(s2, r, 0, 1);
                        c1 = pf.getItems(r, t, 0, 0);
                        if (b1 != null && c1 != null) {
                            pairs = pf.getKBestPairs(b1, c1);
                            k = 0;
                            while (k < pairs.length) {
                                if (pairs[k][0] == -1 || pairs[k][1] == -1 || !pf.add(s2, r, t, -1, 0, 0, bc = b1[comp1].prob + c1[comp2].prob, new FeatureVector(), b1[comp1 = pairs[k][0]], c1[comp2 = pairs[k][1]])) break;
                                ++k;
                            }
                        }
                    }
                    if (r != t) {
                        b1 = pf.getItems(s2, r, 1, 0);
                        c1 = pf.getItems(r, t, 1, 1);
                        if (b1 != null && c1 != null) {
                            pairs = pf.getKBestPairs(b1, c1);
                            k = 0;
                            while (k < pairs.length) {
                                if (pairs[k][0] == -1 || pairs[k][1] == -1 || !pf.add(s2, r, t, -1, 1, 0, bc = b1[comp1].prob + c1[comp2].prob, new FeatureVector(), b1[comp1 = pairs[k][0]], c1[comp2 = pairs[k][1]])) break;
                                ++k;
                            }
                        }
                    }
                    ++r;
                }
                ++s2;
            }
            ++j;
        }
        return pf.getBestParses();
    }

    public Object[][] decodeNonProjective(DependencyInstance inst, FeatureVector[][][] fvs, double[][][] probs, FeatureVector[][][][] nt_fvs, double[][][][] nt_probs, int K) {
        String[] pos = inst.postags;
        int numWords = inst.length();
        int[][] oldI = new int[numWords][numWords];
        int[][] oldO = new int[numWords][numWords];
        double[][] scoreMatrix = new double[numWords][numWords];
        double[][] orig_scoreMatrix = new double[numWords][numWords];
        boolean[] curr_nodes = new boolean[numWords];
        TIntIntHashMap[] reps = new TIntIntHashMap[numWords];
        int[][] static_types = null;
        if (this.pipe.labeled) {
            static_types = this.getTypes(nt_probs, pos.length);
        }
        int i = 0;
        while (i < numWords) {
            curr_nodes[i] = true;
            reps[i] = new TIntIntHashMap();
            reps[i].put(i, 0);
            int j = 0;
            while (j < numWords) {
                scoreMatrix[i][j] = probs[i < j ? i : j][i < j ? j : i][i < j ? 0 : 1] + (this.pipe.labeled ? nt_probs[i][static_types[i][j]][i < j ? 0 : 1][1] + nt_probs[j][static_types[i][j]][i < j ? 0 : 1][0] : 0.0);
                orig_scoreMatrix[i][j] = probs[i < j ? i : j][i < j ? j : i][i < j ? 0 : 1] + (this.pipe.labeled ? nt_probs[i][static_types[i][j]][i < j ? 0 : 1][1] + nt_probs[j][static_types[i][j]][i < j ? 0 : 1][0] : 0.0);
                oldI[i][j] = i;
                oldO[i][j] = j;
                if (i == j || j == 0) {
                    // empty if block
                }
                ++j;
            }
            ++i;
        }
        TIntIntHashMap final_edges = DependencyDecoder.chuLiuEdmonds(scoreMatrix, curr_nodes, oldI, oldO, false, new TIntIntHashMap(), reps);
        int[] par = new int[numWords];
        int[] ns = final_edges.keys();
        int i2 = 0;
        while (i2 < ns.length) {
            int pr;
            int ch = ns[i2];
            par[ch] = pr = final_edges.get(ns[i2]);
            ++i2;
        }
        int[] n_par = this.getKChanges(par, orig_scoreMatrix, Math.min(K, par.length));
        int new_k = 1;
        int i3 = 0;
        while (i3 < n_par.length) {
            if (n_par[i3] > -1) {
                ++new_k;
            }
            ++i3;
        }
        int[][] fin_par = new int[new_k][numWords];
        FeatureVector[][] fin_fv = new FeatureVector[new_k][numWords];
        fin_par[0] = par;
        int c = 1;
        int i4 = 0;
        while (i4 < n_par.length) {
            if (n_par[i4] > -1) {
                int[] t_par = new int[par.length];
                int j = 0;
                while (j < t_par.length) {
                    t_par[j] = par[j];
                    ++j;
                }
                t_par[i4] = n_par[i4];
                fin_par[c] = t_par;
                ++c;
            }
            ++i4;
        }
        int k = 0;
        while (k < fin_par.length) {
            int i5 = 0;
            while (i5 < fin_par[k].length) {
                int ch = i5;
                int pr = fin_par[k][i5];
                if (pr != -1) {
                    fin_fv[k][ch] = fvs[ch < pr ? ch : pr][ch < pr ? pr : ch][ch < pr ? 1 : 0];
                    if (this.pipe.labeled) {
                        fin_fv[k][ch] = fin_fv[k][ch].cat(nt_fvs[ch][static_types[pr][ch]][ch < pr ? 1 : 0][0]);
                        fin_fv[k][ch] = fin_fv[k][ch].cat(nt_fvs[pr][static_types[pr][ch]][ch < pr ? 1 : 0][1]);
                    }
                } else {
                    fin_fv[k][ch] = new FeatureVector();
                }
                ++i5;
            }
            ++k;
        }
        FeatureVector[] fin = new FeatureVector[new_k];
        String[] result = new String[new_k];
        int k2 = 0;
        while (k2 < fin.length) {
            fin[k2] = new FeatureVector();
            int i6 = 1;
            while (i6 < fin_fv[k2].length) {
                fin[k2] = fin_fv[k2][i6].cat(fin[k2]);
                ++i6;
            }
            result[k2] = "";
            i6 = 1;
            while (i6 < par.length) {
                int n = k2;
                result[n] = String.valueOf(result[n]) + fin_par[k2][i6] + "|" + i6 + (this.pipe.labeled ? ":" + static_types[fin_par[k2][i6]][i6] : ":0") + " ";
                ++i6;
            }
            ++k2;
        }
        Object[][] d = new Object[new_k][2];
        int k3 = 0;
        while (k3 < new_k) {
            d[k3][0] = fin[k3];
            d[k3][1] = result[k3].trim();
            ++k3;
        }
        return d;
    }

    private int[] getKChanges(int[] par, double[][] scoreMatrix, int K) {
        int wh;
        double max;
        int[] result = new int[par.length];
        int[] n_par = new int[par.length];
        double[] n_score = new double[par.length];
        int i = 0;
        while (i < par.length) {
            result[i] = -1;
            n_par[i] = -1;
            n_score[i] = Double.NEGATIVE_INFINITY;
            ++i;
        }
        boolean[][] isChild = this.calcChilds(par);
        int i2 = 1;
        while (i2 < n_par.length) {
            max = Double.NEGATIVE_INFINITY;
            wh = -1;
            int j = 0;
            while (j < n_par.length) {
                if (i2 != j && par[i2] != j && !isChild[i2][j] && scoreMatrix[j][i2] > max) {
                    max = scoreMatrix[j][i2];
                    wh = j;
                }
                ++j;
            }
            n_par[i2] = wh;
            n_score[i2] = max;
            ++i2;
        }
        int k = 0;
        while (k < K) {
            max = Double.NEGATIVE_INFINITY;
            wh = -1;
            int whI = -1;
            int i3 = 0;
            while (i3 < n_par.length) {
                double score;
                if (n_par[i3] != -1 && (score = scoreMatrix[n_par[i3]][i3]) > max) {
                    max = score;
                    whI = i3;
                    wh = n_par[i3];
                }
                ++i3;
            }
            if (max == Double.NEGATIVE_INFINITY) break;
            result[whI] = wh;
            n_par[whI] = -1;
            ++k;
        }
        return result;
    }

    private boolean[][] calcChilds(int[] par) {
        boolean[][] isChild = new boolean[par.length][par.length];
        int i = 1;
        while (i < par.length) {
            int l = par[i];
            while (l != -1) {
                isChild[l][i] = true;
                l = par[l];
            }
            ++i;
        }
        return isChild;
    }

    private static TIntIntHashMap chuLiuEdmonds(double[][] scoreMatrix, boolean[] curr_nodes, int[][] oldI, int[][] oldO, boolean print, TIntIntHashMap final_edges, TIntIntHashMap[] reps) {
        int j;
        int[] keys;
        int[] par = new int[curr_nodes.length];
        int numWords = curr_nodes.length;
        par[0] = -1;
        int i = 1;
        while (i < par.length) {
            if (curr_nodes[i]) {
                double maxScore = scoreMatrix[0][i];
                par[i] = 0;
                int j2 = 0;
                while (j2 < par.length) {
                    double newScore;
                    if (j2 != i && curr_nodes[j2] && (newScore = scoreMatrix[j2][i]) > maxScore) {
                        maxScore = newScore;
                        par[i] = j2;
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (print) {
            System.out.println("After init");
            i = 0;
            while (i < par.length) {
                if (curr_nodes[i]) {
                    System.out.print(String.valueOf(par[i]) + "|" + i + " ");
                }
                ++i;
            }
            System.out.println();
        }
        ArrayList<TIntIntHashMap> cycles = new ArrayList<TIntIntHashMap>();
        boolean[] added = new boolean[numWords];
        int i2 = 0;
        while (i2 < numWords && cycles.size() == 0) {
            if (!added[i2] && curr_nodes[i2]) {
                added[i2] = true;
                TIntIntHashMap cycle = new TIntIntHashMap();
                cycle.put(i2, 0);
                int l = i2;
                while (true) {
                    if (par[l] == -1) {
                        added[l] = true;
                        break;
                    }
                    if (cycle.contains(par[l])) {
                        cycle = new TIntIntHashMap();
                        int lorg = par[l];
                        cycle.put(lorg, par[lorg]);
                        added[lorg] = true;
                        int l1 = par[lorg];
                        while (l1 != lorg) {
                            cycle.put(l1, par[l1]);
                            added[l1] = true;
                            l1 = par[l1];
                        }
                        cycles.add(cycle);
                        break;
                    }
                    cycle.put(l, 0);
                    l = par[l];
                    if (added[l] && !cycle.contains(l)) break;
                    added[l] = true;
                }
            }
            ++i2;
        }
        if (cycles.size() == 0) {
            i2 = 0;
            while (i2 < par.length) {
                if (curr_nodes[i2]) {
                    if (par[i2] != -1) {
                        int pr = oldI[par[i2]][i2];
                        int ch = oldO[par[i2]][i2];
                        final_edges.put(ch, pr);
                    } else {
                        final_edges.put(0, -1);
                    }
                }
                ++i2;
            }
            return final_edges;
        }
        int max_cyc = 0;
        int wh_cyc = 0;
        int i3 = 0;
        while (i3 < cycles.size()) {
            TIntIntHashMap cycle = (TIntIntHashMap)cycles.get(i3);
            if (cycle.size() > max_cyc) {
                max_cyc = cycle.size();
                wh_cyc = i3;
            }
            ++i3;
        }
        TIntIntHashMap cycle = (TIntIntHashMap)cycles.get(wh_cyc);
        int[] cyc_nodes = cycle.keys();
        int rep = cyc_nodes[0];
        if (print) {
            System.out.println("Found Cycle");
            int i4 = 0;
            while (i4 < cyc_nodes.length) {
                System.out.print(String.valueOf(cyc_nodes[i4]) + " ");
                ++i4;
            }
            System.out.println();
        }
        double cyc_weight = 0.0;
        int j3 = 0;
        while (j3 < cyc_nodes.length) {
            cyc_weight += scoreMatrix[par[cyc_nodes[j3]]][cyc_nodes[j3]];
            ++j3;
        }
        int i5 = 0;
        while (i5 < numWords) {
            if (curr_nodes[i5] && !cycle.contains(i5)) {
                double max1 = Double.NEGATIVE_INFINITY;
                int wh1 = -1;
                double max2 = Double.NEGATIVE_INFINITY;
                int wh2 = -1;
                int j4 = 0;
                while (j4 < cyc_nodes.length) {
                    double scr;
                    int j1 = cyc_nodes[j4];
                    if (scoreMatrix[j1][i5] > max1) {
                        max1 = scoreMatrix[j1][i5];
                        wh1 = j1;
                    }
                    if ((scr = cyc_weight + scoreMatrix[i5][j1] - scoreMatrix[par[j1]][j1]) > max2) {
                        max2 = scr;
                        wh2 = j1;
                    }
                    ++j4;
                }
                scoreMatrix[rep][i5] = max1;
                oldI[rep][i5] = oldI[wh1][i5];
                oldO[rep][i5] = oldO[wh1][i5];
                scoreMatrix[i5][rep] = max2;
                oldO[i5][rep] = oldO[i5][wh2];
                oldI[i5][rep] = oldI[i5][wh2];
            }
            ++i5;
        }
        TIntIntHashMap[] rep_cons = new TIntIntHashMap[cyc_nodes.length];
        int i6 = 0;
        while (i6 < cyc_nodes.length) {
            rep_cons[i6] = new TIntIntHashMap();
            keys = reps[cyc_nodes[i6]].keys();
            Arrays.sort(keys);
            if (print) {
                System.out.print(String.valueOf(cyc_nodes[i6]) + ": ");
            }
            j = 0;
            while (j < keys.length) {
                rep_cons[i6].put(keys[j], 0);
                if (print) {
                    System.out.print(String.valueOf(keys[j]) + " ");
                }
                ++j;
            }
            if (print) {
                System.out.println();
            }
            ++i6;
        }
        i6 = 1;
        while (i6 < cyc_nodes.length) {
            curr_nodes[cyc_nodes[i6]] = false;
            keys = reps[cyc_nodes[i6]].keys();
            j = 0;
            while (j < keys.length) {
                reps[rep].put(keys[j], 0);
                ++j;
            }
            ++i6;
        }
        DependencyDecoder.chuLiuEdmonds(scoreMatrix, curr_nodes, oldI, oldO, print, final_edges, reps);
        int wh = -1;
        boolean found = false;
        int i7 = 0;
        while (i7 < rep_cons.length && !found) {
            int[] keys2 = rep_cons[i7].keys();
            int j5 = 0;
            while (j5 < keys2.length && !found) {
                if (final_edges.contains(keys2[j5])) {
                    wh = cyc_nodes[i7];
                    found = true;
                }
                ++j5;
            }
            ++i7;
        }
        int l = par[wh];
        while (l != wh) {
            int ch = oldO[par[l]][l];
            int pr = oldI[par[l]][l];
            final_edges.put(ch, pr);
            l = par[l];
        }
        if (print) {
            int[] keys3 = final_edges.keys();
            Arrays.sort(keys3);
            int i8 = 0;
            while (i8 < keys3.length) {
                System.out.print(String.valueOf(final_edges.get(keys3[i8])) + "|" + keys3[i8] + " ");
                ++i8;
            }
            System.out.println();
        }
        return final_edges;
    }
}

