/*
 * Decompiled with CFR 0.152.
 */
package edu.upenn.seas.mstparser;

import de.julielab.gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Alphabet
implements Serializable {
    TObjectIntHashMap map;
    int numEntries;
    boolean growthStopped = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public Alphabet(int capacity) {
        this.map = new TObjectIntHashMap(capacity);
        this.numEntries = 0;
    }

    public Alphabet() {
        this(10000);
    }

    public int lookupIndex(Object entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        int ret = this.map.get(entry);
        if (ret == -1 && !this.growthStopped) {
            ret = this.numEntries++;
            this.map.put(entry, ret);
        }
        return ret;
    }

    public Object[] toArray() {
        return this.map.keys();
    }

    public boolean contains(Object entry) {
        return this.map.contains(entry);
    }

    public int size() {
        return this.numEntries;
    }

    public void stopGrowth() {
        this.growthStopped = true;
        this.map.compact();
    }

    public void allowGrowth() {
        this.growthStopped = false;
    }

    public boolean growthStopped() {
        return this.growthStopped;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeInt(this.numEntries);
        out.writeObject(this.map);
        out.writeBoolean(this.growthStopped);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.numEntries = in.readInt();
        this.map = (TObjectIntHashMap)in.readObject();
        this.growthStopped = in.readBoolean();
    }
}

