/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.mstparser.main;

import de.julielab.jcore.ae.mstparser.main.MSTParserWrapper;
import edu.upenn.seas.mstparser.Alphabet;
import edu.upenn.seas.mstparser.DependencyParser;
import edu.upenn.seas.mstparser.DependencyPipe;
import edu.upenn.seas.mstparser.ParserOptions;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSTParserWrapperImpl
implements MSTParserWrapper,
SharedResourceObject {
    static Random random = new Random(System.currentTimeMillis());
    public static final String COMPONENT_ID = "de.julielab.jcore.ae.mstparser.main.MSTParserWrapper";
    private static Alphabet dataAlphabet;
    private static double[] parameters;
    private static final Logger LOGGER;
    private static final String EMPTY_STRING = "";
    private static boolean first;
    private static Alphabet typeAlphabet;
    private static String format;
    private static String modelFilename;

    static {
        LOGGER = LoggerFactory.getLogger(MSTParserWrapperImpl.class);
        first = false;
    }

    @Override
    public DependencyParser loadModel() {
        ParserOptions options = new ParserOptions(new String[]{"model-name:" + modelFilename, "format:" + format});
        try {
            DependencyPipe pipe = new DependencyPipe(options);
            MSTParserWrapperImpl.loadModelToPipe(pipe, options.modelName);
            DependencyParser parser = new DependencyParser(pipe, options);
            parser.setParameters(parameters);
            return parser;
        }
        catch (IOException e) {
            LOGGER.error("loadModel - Could not read from file. Message: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            LOGGER.error("loadModel - An Error occurred. Message: " + e.getMessage());
            return null;
        }
    }

    private static synchronized boolean checkFirst() {
        if (!first) {
            first = true;
            return true;
        }
        return false;
    }

    private static synchronized void loadModelToPipe(DependencyPipe pipe, String file) {
        pipe.dataAlphabet = dataAlphabet;
        pipe.typeAlphabet = typeAlphabet;
        while (pipe.dataAlphabet == null && pipe.typeAlphabet == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            pipe.dataAlphabet = dataAlphabet;
            pipe.typeAlphabet = typeAlphabet;
        }
        pipe.closeAlphabets();
    }

    @Override
    public String predict(DependencyParser parser, String inputSentence) throws IOException {
        if (StringUtils.isBlank((String)inputSentence)) {
            LOGGER.warn("Input sentence was empty.");
            return null;
        }
        String parsedSentence = null;
        try {
            parsedSentence = parser.outputParses(inputSentence);
        }
        catch (Exception e) {
            LOGGER.error("predict - Could not parse: " + e.getMessage());
            LOGGER.error("Input sentence was: " + inputSentence);
            e.printStackTrace();
        }
        return parsedSentence;
    }

    public void load(DataResource resource) throws ResourceInitializationException {
        try {
            DataInputStream in = new DataInputStream(resource.getInputStream());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String value_modelFileName = reader.readLine();
            String value_format = reader.readLine();
            try {
                if (this.checkParameters(value_modelFileName, value_format)) {
                    MSTParserWrapperImpl.loadModelParts(value_modelFileName, value_format);
                }
            }
            catch (Exception e) {
                LOGGER.error("Can't load Model from file " + value_modelFileName);
            }
        }
        catch (IOException e) {
            LOGGER.error("Can't read parameters from Config File ");
        }
    }

    private static synchronized void loadModelParts(String modelFilename, String format) {
        MSTParserWrapperImpl.modelFilename = modelFilename;
        MSTParserWrapperImpl.format = format;
        if (MSTParserWrapperImpl.checkFirst()) {
            try {
                LOGGER.info("Loading model...");
                GZIPInputStream gzin = new GZIPInputStream(new FileInputStream(modelFilename));
                ObjectInputStream in = new ObjectInputStream(gzin);
                parameters = (double[])in.readObject();
                dataAlphabet = (Alphabet)in.readObject();
                typeAlphabet = (Alphabet)in.readObject();
                in.close();
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Model could not be loaded");
                e.printStackTrace();
            }
            catch (IOException e) {
                LOGGER.error("Model could not be loaded");
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Model could not be loaded");
                e.printStackTrace();
            }
        } else {
            LOGGER.info("Model already loaded");
        }
    }

    private boolean checkParameters(String value_modelFileName, String value_format) {
        boolean parameters_valid = true;
        if (value_modelFileName == null) {
            LOGGER.error("Parameter modelFileName has an invalid value: " + value_modelFileName + ". Please set it to a valid value.");
            parameters_valid = false;
        } else {
            File file = new File(value_modelFileName);
            if (!file.exists()) {
                LOGGER.error("File " + value_modelFileName + " does not exist. Please check the parameter " + "modelFileName" + "!");
                parameters_valid = false;
            } else if (!file.canRead()) {
                LOGGER.error("Cannot read the file " + value_modelFileName + "! Please check the file properties.");
                parameters_valid = false;
            }
        }
        if (value_format == null || !value_format.equals("CONLL") && !value_format.equals("MST")) {
            LOGGER.error("Parameter format has an invalid value: " + value_format + ". Allowed are only \"" + "CONLL" + "\" and \"" + "MST" + "\".");
            parameters_valid = false;
            value_format = EMPTY_STRING;
        }
        return parameters_valid;
    }
}

