/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.mstparser.main;

import de.julielab.jcore.ae.mstparser.main.MSTParserWrapper;
import de.julielab.jcore.ae.mstparser.main.MSTParserWrapperImpl;
import de.julielab.jcore.types.DependencyRelation;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.POSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import edu.upenn.seas.mstparser.DependencyParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSTParserAnnotator
extends JCasAnnotator_ImplBase {
    private static final int TIMEOUT = 30;
    public static final String COMPONENT_ID = "de.julielab.jcore.ae.mstparser.main.MSTParserAnnotator";
    public static final String PARAM_MAX_NUM_TOKENS = "MaxNumTokens";
    @ConfigurationParameter(name="MaxNumTokens", description="The maximum number of tokens a sentence may have to be subject to parsing. If a sentence has more tokens, it will be skipped by the component. If no value is given, no restriction of the number of tokens is imposed.")
    private Integer maxNumTokens;
    @ExternalResource(key="SharedModel", mandatory=true)
    private MSTParserWrapper mstParserWrapper;
    private DependencyParser mstParser;
    private ExecutorService executor;
    private static final Logger LOGGER = LoggerFactory.getLogger(MSTParserAnnotator.class);
    static final String MODEL_FILE_NAME = "modelFileName";
    static final String TEMPORARY_PATH = "temporaryPath";
    private static final String PROJECTIVE = "proj";
    private static final String NON_PROJECTIVE = "non-proj";
    private static final String LABEL_DUMMY = "<no-type>";
    private static final String DEPENDENCY_DUMMY = "0";
    static final String FORMAT = "format";
    static final String FORMAT_MST = "MST";
    static final String FORMAT_CONLL = "CONLL";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String TABULATOR = "\t";
    private static final String PLACEHOLDER = "_";
    private static final String EMPTY_STRING = "";
    private static final boolean defaultProjective = true;
    public static final String RESOURCE_MODEL = "SharedModel";
    private static boolean parameters_valid = true;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        try {
            LOGGER.info("MST Parser Annotator is being initialized ... ");
            super.initialize(aContext);
            this.maxNumTokens = (Integer)aContext.getConfigParameterValue(PARAM_MAX_NUM_TOKENS);
            if (this.maxNumTokens != null) {
                LOGGER.info("Skipping sentences with more than " + this.maxNumTokens + " tokens");
            }
            aContext.getResourceObject(RESOURCE_MODEL);
            this.mstParserWrapper = new MSTParserWrapperImpl();
            this.mstParser = this.mstParserWrapper.loadModel();
            this.executor = Executors.newCachedThreadPool();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Cannot innitialize MST Parser " + e.getMessage());
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        if (parameters_valid) {
            LOGGER.info("MST Parser Annotator is processing ... ");
            AnnotationIndex sentenceIndex = jcas.getJFSIndexRepository().getAnnotationIndex(Sentence.type);
            AnnotationIndex tokenIndex = jcas.getJFSIndexRepository().getAnnotationIndex(Token.type);
            for (Sentence casSentence : sentenceIndex) {
                String parsedSentence;
                ArrayList<Token> tokenList;
                block20: {
                    FSIterator tokenIterator = tokenIndex.subiterator((AnnotationFS)casSentence);
                    tokenList = new ArrayList<Token>();
                    ArrayList<String> tokenTextList = new ArrayList<String>();
                    ArrayList<POSTag> posTagList = new ArrayList<POSTag>();
                    ArrayList<String> posTagTextList = new ArrayList<String>();
                    int i = 0;
                    while (tokenIterator.hasNext()) {
                        Token token = (Token)tokenIterator.next();
                        ++i;
                        String tokenText = token.getCoveredText();
                        tokenList.add(token);
                        tokenTextList.add(tokenText);
                        if (token.getPosTag() == null || token.getPosTag().size() == 0 || token.getPosTag(0) == null) {
                            String docId = this.getDocId(jcas);
                            throw new IllegalStateException("The parser expects that each token has (at least) one part of speech tag at index 0 of the PosTag feature array. However, the token \"" + token.getCoveredText() + "\", offsets " + token.getBegin() + "-" + token.getEnd() + " of document " + docId + " does not appear to have a POS tag.");
                        }
                        POSTag posTag = token.getPosTag(0);
                        String posText = posTag.getValue();
                        posTagList.add(posTag);
                        posTagTextList.add(posText);
                    }
                    if (this.maxNumTokens != null && i > this.maxNumTokens) {
                        LOGGER.warn("Skipping sentence with > " + this.maxNumTokens + " tokens: " + casSentence.getCoveredText());
                        break;
                    }
                    final String inputSentence = this.getSentence(tokenTextList, posTagTextList, null, null);
                    parsedSentence = null;
                    try {
                        Callable<String> task = new Callable<String>(){

                            @Override
                            public String call() throws IOException {
                                return MSTParserAnnotator.this.mstParserWrapper.predict(MSTParserAnnotator.this.mstParser, inputSentence);
                            }
                        };
                        Future<String> future = this.executor.submit(task);
                        try {
                            parsedSentence = future.get(30L, TimeUnit.SECONDS);
                        }
                        catch (TimeoutException ex) {
                            LOGGER.warn("The processing of a sentence was cancelled because it took too long (more than {} seconds). The actual sentence is put out below.", (Object)30);
                            future.cancel(true);
                            break block20;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            break block20;
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                            future.cancel(true);
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            break block20;
                        }
                        {
                            finally {
                                future.cancel(true);
                            }
                        }
                        future.cancel(true);
                    }
                    catch (OutOfMemoryError e) {
                        String docId = this.getDocId(jcas);
                        LOGGER.warn("OutOfMemory error occured when parsing the sentence \"{}\" of document \"{}\". This does not mean necessarely your application has too less allocated memory. On rare occasions (very rare: it seems there is only one document in the whole of MEDLINE causing this error, (PMID: 23717185) which contains a ridiculous large enumeration of terms), the parser seems to consume arbitrary amounts of memory without actually being able to parse the input. In such a case you would observe a sudden pike in memory consumption (e.g. from constantly around 10GB to suddenly 20GB then 30GB, depending on the maximum available amount of memory set by the -Xmx option). Only if the memory consumption is constantly near the maximum, you should consider to increase the amount of allocated memory.", (Object)casSentence.getCoveredText(), (Object)docId);
                    }
                }
                try {
                    this.writeCas(this.mstParser, jcas, parsedSentence, tokenList);
                }
                catch (Exception e) {
                    LOGGER.error("Sentence could not be parsed and will not have syntactic annotations in the CAS: " + casSentence.getCoveredText());
                }
            }
        } else {
            LOGGER.info("Cannot continue parsing. Please check the parameters!");
        }
    }

    protected String getDocId(JCas jcas) {
        FSIterator it = jcas.getJFSIndexRepository().getAnnotationIndex(Header.type).iterator();
        String docId = "<unknown>";
        if (it.hasNext()) {
            docId = ((Header)it.next()).getDocId();
        }
        return docId;
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.executor.shutdown();
        super.collectionProcessComplete();
    }

    public void destroy() {
        this.executor.shutdown();
        super.destroy();
    }

    private void writeCas(DependencyParser mstParser, JCas jcas, String parsedSentence, List<Token> tokenList) {
        int dependencyIndex = 0;
        List<Integer> depList = this.getDependencyRelations(parsedSentence);
        List<String> labelsList = this.getLabels(parsedSentence);
        int i = 0;
        while (i < tokenList.size()) {
            Token token = tokenList.get(i);
            dependencyIndex = depList.get(i) - 1;
            Token headToken = null;
            if (dependencyIndex >= 0) {
                headToken = tokenList.get(dependencyIndex);
                FSArray depRelationFSArray = new FSArray(jcas, 1);
                DependencyRelation depRelation = new DependencyRelation(jcas);
                depRelation.setHead(headToken);
                this.setProjective(depRelation, mstParser);
                depRelation.setLabel(labelsList.get(i));
                depRelation.setBegin(tokenList.get(i).getBegin());
                depRelation.setEnd(tokenList.get(i).getEnd());
                depRelation.setComponentId(COMPONENT_ID);
                depRelation.addToIndexes(jcas);
                depRelationFSArray.set(0, (FeatureStructure)depRelation);
                depRelationFSArray.addToIndexes(jcas);
                token.setDepRel(depRelationFSArray);
            } else {
                DependencyRelation depRelation = new DependencyRelation(jcas);
                depRelation.setComponentId(COMPONENT_ID);
                depRelation.addToIndexes();
                FSArray depRelationFSArray = new FSArray(jcas, 1);
                depRelationFSArray.set(0, (FeatureStructure)depRelation);
                depRelationFSArray.addToIndexes();
                token.setDepRel(depRelationFSArray);
            }
            ++i;
        }
    }

    private String getSentence(List<String> tokens, List<String> posTags, List<String> labels, List<String> depRelations) {
        if (labels == null || labels.size() != tokens.size()) {
            labels = this.createList(LABEL_DUMMY, tokens.size());
        }
        if (depRelations == null || depRelations.size() != tokens.size()) {
            depRelations = this.createList(DEPENDENCY_DUMMY, tokens.size());
        }
        StringBuffer sentence = new StringBuffer();
        if (this.mstParser.options.format.equals(FORMAT_MST)) {
            sentence.append(this.addListElements(tokens));
            sentence.append(this.addListElements(posTags));
            sentence.append(this.addListElements(labels));
            sentence.append(this.addListElements(depRelations));
        } else if (this.mstParser.options.format.equals(FORMAT_CONLL)) {
            int i = 0;
            while (i < tokens.size()) {
                sentence.append(i + 1);
                sentence.append(TABULATOR + tokens.get(i).replaceAll("\n", " ").replaceAll(TABULATOR, " "));
                sentence.append("\t_");
                sentence.append(TABULATOR + posTags.get(i));
                sentence.append(TABULATOR + posTags.get(i));
                sentence.append("\t_");
                sentence.append(TABULATOR + depRelations.get(i));
                sentence.append(TABULATOR + labels.get(i));
                sentence.append(LINE_SEPARATOR);
                ++i;
            }
        }
        return sentence.toString();
    }

    private void setProjective(DependencyRelation depRelation, DependencyParser mstParser) {
        String decodeType = mstParser.options.decodeType;
        if (decodeType.equals(PROJECTIVE)) {
            depRelation.setProjective(true);
        } else if (decodeType.equals(NON_PROJECTIVE)) {
            depRelation.setProjective(false);
        } else {
            LOGGER.error("setProjective: decode mode is invalid. Setting projective to the default value true");
            depRelation.setProjective(true);
        }
    }

    private List<Integer> getDependencyRelations(String parsedSentence) {
        ArrayList<Integer> depRels = new ArrayList<Integer>();
        try {
            if (this.mstParser.options.format.equals(FORMAT_MST)) {
                String depRelLine = parsedSentence.split(LINE_SEPARATOR)[3];
                String[] stringArray = depRelLine.split(TABULATOR);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String depRel = stringArray[n2];
                    depRels.add(Integer.parseInt(depRel));
                    ++n2;
                }
            } else if (this.mstParser.options.format.equals(FORMAT_CONLL)) {
                String[] stringArray = parsedSentence.split(LINE_SEPARATOR);
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String line = stringArray[n3];
                    depRels.add(Integer.parseInt(line.split(TABULATOR)[6]));
                    ++n3;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("The parsed sentence has unexpected format (no 8th. column exists).");
        }
        return depRels;
    }

    private List<String> getLabels(String parsedSentence) {
        List<String> labels = new ArrayList<String>();
        try {
            if (this.mstParser.options.format.equals(FORMAT_MST)) {
                String labelLine = parsedSentence.split(LINE_SEPARATOR)[2];
                labels = Arrays.asList(labelLine.split(TABULATOR));
            } else if (this.mstParser.options.format.equals(FORMAT_CONLL)) {
                String[] stringArray = parsedSentence.split(LINE_SEPARATOR);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    labels.add(line.split(TABULATOR)[7]);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected format of parsed sentence.");
        }
        return labels;
    }

    private List<String> createList(String element, int listSize) {
        ArrayList<String> outputList = new ArrayList<String>();
        int i = 0;
        while (i < listSize) {
            outputList.add(element);
            ++i;
        }
        return outputList;
    }

    private String addListElements(List<String> list) {
        StringBuffer sentence = new StringBuffer();
        if (!list.isEmpty()) {
            for (String element : list) {
                if (sentence.length() > 0) {
                    sentence.append(TABULATOR);
                }
                sentence.append(element);
            }
            sentence.append(LINE_SEPARATOR);
        }
        return sentence.toString();
    }
}

