/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.msdoc.main;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ReadSingleMSdoc {
    public static String INPUT_FILE = "";
    public static String CONTENT_HTML = "";
    public static String CONTENT_NORMAL = "";
    public static String CONTENT_TAB_MARKED = "";
    public static String LAB_PARAMS_HTML = "";
    public static String LAB_PARAMS_NORMAL = "";
    public static String LAB_PARAMS_TAB_MARKED = "";
    public static String CONTENT_WOLP_HTML = "";
    public static String CONTENT_WOLP_NORMAL = "";
    public static String CONTENT_WOLP_TAB_MARKED = "";
    public static boolean LAB_TABLE = false;

    public static void doc2Text() {
        CONTENT_HTML = "";
        CONTENT_NORMAL = "";
        CONTENT_TAB_MARKED = "";
        LAB_PARAMS_HTML = "";
        LAB_PARAMS_NORMAL = "";
        LAB_PARAMS_TAB_MARKED = "";
        CONTENT_WOLP_HTML = "";
        CONTENT_WOLP_NORMAL = "";
        CONTENT_WOLP_TAB_MARKED = "";
        try {
            FileInputStream fis = new FileInputStream(INPUT_FILE);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fis);
            HWPFDocument doc = new HWPFDocument(fs);
            Range docRange = doc.getRange();
            boolean inTable = false;
            boolean inRow = false;
            boolean tbOpen = false;
            boolean tdOpen = false;
            for (int i = 0; i < docRange.numParagraphs(); ++i) {
                Paragraph par = docRange.getParagraph(i);
                if (par.isInTable()) {
                    if (!inTable) {
                        CONTENT_HTML = CONTENT_HTML + "\n<table>\n";
                        inTable = true;
                    }
                    if (!inRow) {
                        if (tbOpen) {
                            CONTENT_HTML = CONTENT_HTML + "</tr>\n";
                        }
                        CONTENT_HTML = CONTENT_HTML + "<tr>";
                        inRow = true;
                        tbOpen = true;
                    }
                    if (par.isTableRowEnd()) {
                        inRow = false;
                        continue;
                    }
                    if (!tdOpen && par.text().endsWith("\u0007")) {
                        CONTENT_HTML = CONTENT_HTML + "<td>";
                        CONTENT_HTML = CONTENT_HTML + par.text().replaceAll("\\s", " ");
                        CONTENT_HTML = CONTENT_HTML + "</td>";
                        continue;
                    }
                    if (!tdOpen && !par.text().endsWith("\u0007")) {
                        CONTENT_HTML = CONTENT_HTML + "<td>";
                        CONTENT_HTML = CONTENT_HTML + par.text().replaceAll("\\s", " ");
                        tdOpen = true;
                        continue;
                    }
                    if (tdOpen && par.text().endsWith("\u0007")) {
                        CONTENT_HTML = CONTENT_HTML + par.text().replaceAll("\\s", " ");
                        CONTENT_HTML = CONTENT_HTML + "</td>";
                        tdOpen = false;
                        continue;
                    }
                    if (!tdOpen || par.text().endsWith("\u0007")) continue;
                    CONTENT_HTML = CONTENT_HTML + par.text().replaceAll("\\s", " ");
                    continue;
                }
                if (inTable) {
                    CONTENT_HTML = CONTENT_HTML + "</tr>\n</table>\n";
                    inTable = false;
                }
                CONTENT_HTML = CONTENT_HTML + par.text() + "<br/>";
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
        }
        CONTENT_HTML = ReadSingleMSdoc.characterChecker(CONTENT_HTML);
        CONTENT_NORMAL = ReadSingleMSdoc.makeNormalText(CONTENT_HTML);
        CONTENT_TAB_MARKED = ReadSingleMSdoc.makeTabMarked(CONTENT_HTML);
        String[] contentSplitMT = ReadSingleMSdoc.characterChecker(CONTENT_HTML).split("\n");
        boolean foundLabParams = false;
        for (int i = 0; i < contentSplitMT.length; ++i) {
            if (contentSplitMT[i].contains("<br/>Laborwerte:")) {
                for (int j = i; j < contentSplitMT.length; ++j) {
                    if (!contentSplitMT[j].contains("Normwert")) continue;
                    foundLabParams = true;
                    break;
                }
            }
            if (!foundLabParams) {
                CONTENT_WOLP_HTML = CONTENT_WOLP_HTML + contentSplitMT[i] + "\n";
                continue;
            }
            LAB_PARAMS_HTML = LAB_PARAMS_HTML + contentSplitMT[i] + "\n";
        }
        CONTENT_WOLP_NORMAL = ReadSingleMSdoc.makeNormalText(CONTENT_WOLP_HTML);
        CONTENT_WOLP_TAB_MARKED = ReadSingleMSdoc.makeTabMarked(CONTENT_WOLP_HTML);
        LAB_PARAMS_NORMAL = ReadSingleMSdoc.makeNormalText(LAB_PARAMS_HTML);
        LAB_PARAMS_TAB_MARKED = ReadSingleMSdoc.makeTabMarked(LAB_PARAMS_HTML);
        LAB_TABLE = LAB_PARAMS_HTML.contains("<table>") && LAB_PARAMS_HTML.contains("</table>") && LAB_PARAMS_HTML.contains("<tr>") && LAB_PARAMS_HTML.contains("</tr>");
    }

    private static String characterChecker(String content) {
        Object output = "";
        for (int i = 0; i < content.length(); ++i) {
            int charvalue = ReadSingleMSdoc.ReadIntegerValueOf1Character(content.charAt(i));
            if (57343 <= charvalue && charvalue <= 63742 || (3 > charvalue || charvalue > 125) && (160 > charvalue || charvalue > 254)) continue;
            output = (String)output + content.charAt(i);
        }
        output = ((String)output).replaceAll("", "");
        output = ((String)output).replaceAll("\u0007", "");
        output = ((String)output).replaceAll("\b", "");
        output = ((String)output).replaceAll("\u000b", "");
        output = ((String)output).replaceAll("\f", "");
        output = ((String)output).replaceAll("\\r", "\n");
        return output;
    }

    private static int ReadIntegerValueOf1Character(char c) {
        Object y = c + Character.digit(c, 10) + " ";
        y = ((String)y).substring(0, ((String)y).length() - 1);
        return Integer.parseInt((String)y);
    }

    private static String makeNormalText(String input) {
        String text = input;
        text = text.replaceAll("<table>", "");
        text = text.replaceAll("</table>", "");
        text = text.replaceAll("<tr>", "");
        text = text.replaceAll("</tr>", "\n");
        text = text.replaceAll("<td>", "");
        text = text.replaceAll("</td>", "\t");
        text = text.replaceAll("<br/>", "");
        if ((text = text.replaceAll("\n+", "\n")).startsWith("\n")) {
            text = text.replaceFirst("\n", "");
        }
        return text;
    }

    private static String makeTabMarked(String input) {
        String text = input;
        text = text.replaceAll("<table>", "");
        text = text.replaceAll("</table>", "");
        text = text.replaceAll("<tr>", "");
        text = text.replaceAll("</tr>", "");
        text = text.replaceAll("<td>", "|    ");
        text = text.replaceAll("</td>", "    |");
        text = text.replaceAll("<br/>", "");
        if ((text = text.replaceAll("\n+", "\n")).startsWith("\n")) {
            text = text.replaceFirst("\n", "");
        }
        return text;
    }
}

