/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.msdoc.main;

import de.julielab.jcore.reader.msdoc.main.ReadSingleMSdoc;
import de.julielab.jcore.types.pubmed.Header;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class MSdocReader
extends CollectionReader_ImplBase {
    public static final String DIRECTORY_INPUT = "InputDirectory";
    public static final String FILENAME_AS_DOC_ID = "UseFilenameAsDocId";
    public static final String ALLOWED_FILE_EXTENSIONS = "AllowedFileExtensions";
    public static final String DIRECTORY_SUBDIRS = "ReadSubDirs";
    private ArrayList<File> files;
    private int fileIndex;
    private File inputDirectory;
    private boolean useFilenameAsDocId;
    private boolean useSubDirs;

    public void initialize() throws ResourceInitializationException {
        Boolean subdir;
        this.inputDirectory = new File(((String)this.getConfigParameterValue(DIRECTORY_INPUT)).trim());
        Boolean filenameAsDocId = (Boolean)this.getConfigParameterValue(FILENAME_AS_DOC_ID);
        this.useFilenameAsDocId = null == filenameAsDocId ? false : filenameAsDocId;
        String[] allowedExtensionsArray = (String[])this.getConfigParameterValue(ALLOWED_FILE_EXTENSIONS);
        HashSet<String> allowedExtensions = new HashSet<String>();
        if (null != allowedExtensionsArray) {
            for (int i = 0; i < allowedExtensionsArray.length; ++i) {
                allowedExtensions.add(allowedExtensionsArray[i]);
            }
        }
        this.useSubDirs = null == (subdir = (Boolean)this.getConfigParameterValue(DIRECTORY_SUBDIRS)) ? false : subdir;
        this.fileIndex = 0;
        this.files = new ArrayList();
        try {
            this.createFileListByType(this.inputDirectory, allowedExtensions);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasNext() {
        return this.fileIndex < this.files.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        File file = this.files.get(this.fileIndex++);
        ReadSingleMSdoc.INPUT_FILE = file.getPath();
        ReadSingleMSdoc.doc2Text();
        String textWithMarkedTables = ReadSingleMSdoc.CONTENT_TAB_MARKED;
        jcas.setDocumentText(textWithMarkedTables);
        if (this.useFilenameAsDocId) {
            int extUnderScoreIndex;
            String filename = file.getName();
            int extDotIndex = filename.lastIndexOf(46);
            if (extDotIndex > 0) {
                filename = filename.substring(0, extDotIndex);
            }
            if ((extUnderScoreIndex = filename.lastIndexOf(95)) > 0) {
                filename = filename.substring(0, extUnderScoreIndex);
            }
            Header header = new Header(jcas);
            header.setDocId(filename);
            header.addToIndexes();
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.fileIndex, this.files.size(), "entities")};
    }

    private String[] createFileListByType(File inputDirectory, Set<String> allowedExtensions) throws IOException {
        String[] path = new File(inputDirectory.getPath()).list();
        for (int i = 0; i < path.length; ++i) {
            File file = new File(inputDirectory.getAbsolutePath() + "/" + path[i]);
            String CurrentExtension = path[i].substring(path[i].lastIndexOf(46) + 1);
            if (allowedExtensions.contains(CurrentExtension)) {
                this.files.add(file);
            }
            if (!this.useSubDirs || !file.isDirectory()) continue;
            this.createFileListByType(file, allowedExtensions);
        }
        return path;
    }

    private static void writeArtifactIntoTXT(String file, String text) {
        file = file.substring(0, file.length() - 4) + ".txt";
        File artifactFile = new File(file);
        try (FileOutputStream outputStream = new FileOutputStream(artifactFile);){
            outputStream.write(text.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

